/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.log.internal;

import de.rcenvironment.core.gui.log.internal.LogModel;
import de.rcenvironment.core.gui.log.internal.LogView;
import de.rcenvironment.core.log.SerializableLogEntry;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class LogTableFilter
extends ViewerFilter
implements SelectionListener,
KeyListener {
    private static final String Filter = ".*";
    private boolean myErrorSetup;
    private boolean myInfoSetup;
    private boolean myWarnSetup;
    private LogView myLoggingView;
    private String mySearchTerm;
    private TableViewer myTableViewer;
    private Pattern myPattern;

    public LogTableFilter(LogView loggingView, TableViewer tableViewer) {
        this.myLoggingView = loggingView;
        this.myTableViewer = tableViewer;
        this.updateTableView();
        this.myTableViewer.getTable().setFocus();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        SerializableLogEntry logEntry;
        boolean returnValue = false;
        if (element instanceof SerializableLogEntry && this.isLevelSelected((logEntry = (SerializableLogEntry)element).getLevel())) {
            returnValue = this.isSelectedBySearchTerm(logEntry.getMessage());
        }
        return returnValue;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateTableView();
        this.myTableViewer.getTable().setFocus();
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        this.updateTableView();
    }

    private void updateTableView() {
        this.myErrorSetup = this.myLoggingView.getErrorSelection();
        this.myInfoSetup = this.myLoggingView.getInfoSelection();
        this.myWarnSetup = this.myLoggingView.getWarnSelection();
        this.setSearchTerm(this.myLoggingView.getSearchText());
        LogModel.getInstance().setSelectedLogSource(this.myLoggingView.getPlatform());
        this.myTableViewer.refresh();
    }

    private boolean isLevelSelected(int level) {
        boolean returnValue = false;
        if (1 == level && this.myErrorSetup) {
            returnValue = true;
        } else if (3 == level && this.myInfoSetup) {
            returnValue = true;
        } else if (2 == level && this.myWarnSetup) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isSelectedBySearchTerm(String message) {
        boolean returnValue = false;
        if (this.mySearchTerm == null || this.mySearchTerm.length() == 0) {
            returnValue = true;
        } else if (this.messageMatchesSearchTerm(message)) {
            returnValue = true;
        }
        return returnValue;
    }

    private void setSearchTerm(String searchTerm) {
        char[] regexsymbols = new char[]{'(', ')', '{', '}', '[', ']', '^', '?', '.', '\\', '$', '|', '+'};
        this.mySearchTerm = searchTerm.toLowerCase();
        StringBuilder searchTermBuilder = new StringBuilder(this.mySearchTerm);
        int offset = 0;
        int i = 0;
        while (i < this.mySearchTerm.length()) {
            int j = 0;
            while (j < regexsymbols.length) {
                if (this.mySearchTerm.charAt(i) == regexsymbols[j]) {
                    searchTermBuilder.insert(i + offset, "\\");
                    ++offset;
                }
                ++j;
            }
            ++i;
        }
        this.mySearchTerm = searchTermBuilder.toString();
        while (this.mySearchTerm.contains(" ")) {
            this.mySearchTerm = this.mySearchTerm.indexOf(" ") != this.mySearchTerm.length() - 1 ? this.mySearchTerm.replaceFirst(" ", ".") : this.mySearchTerm.replaceFirst(" ", "");
        }
        this.mySearchTerm = this.mySearchTerm.replaceAll("\\*", Filter);
        this.mySearchTerm = Filter + this.mySearchTerm + Filter;
        try {
            this.myPattern = Pattern.compile(this.mySearchTerm);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.myPattern = Pattern.compile("");
        }
    }

    private boolean messageMatchesSearchTerm(String message) {
        return this.myPattern.matcher(message.toLowerCase()).matches();
    }
}

