/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.workflow.WorkflowConfigurationMap;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegrationService;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.integration.common.CommonIntegrationController;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapterToJsonConverter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowIntegrationController
extends CommonIntegrationController {
    private static final Log LOG = LogFactory.getLog(WorkflowIntegrationController.class);
    private WorkflowIntegrationService integrationService;
    private boolean editMode = false;
    private WorkflowDescription workflowDescription;
    private Optional<String> originalName = Optional.empty();

    public WorkflowIntegrationController(String componentName) throws FileNotFoundException {
        this.originalName = Optional.of(componentName);
        this.integrationService = (WorkflowIntegrationService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(WorkflowIntegrationService.class);
        this.setValue("integrationType", IntegrationContextType.WORKFLOW.toString(), ConfigurationContext.COMMON_SETTINGS);
        this.loadWorkflowIntegration(componentName);
    }

    public WorkflowIntegrationController() {
        this.integrationService = (WorkflowIntegrationService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(WorkflowIntegrationService.class);
        this.setValue("integrationType", IntegrationContextType.WORKFLOW.toString(), ConfigurationContext.COMMON_SETTINGS);
        this.setDefaultLaunchSettings();
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void instantiateModel() {
        this.setConfigurationModel((ConfigurationMap)new WorkflowConfigurationMap());
    }

    public WorkflowConfigurationMap getWorkflowConfigurationModel() {
        return (WorkflowConfigurationMap)this.configurationModel;
    }

    private void setDefaultLaunchSettings() {
        HashMap<String, String> launchSettings = new HashMap<String, String>();
        launchSettings.put("host", "RCE");
        launchSettings.put("rootWorkingDirectory", "");
        launchSettings.put("toolDirectory", ".");
        launchSettings.put("version", "0.0");
        launchSettings.put("limitInstallationInstances", "true");
        launchSettings.put("limitInstallationInstancesNumber", "10");
        this.setLaunchSettings(launchSettings);
    }

    public void setValue(String key, Object value, ConfigurationContext context) {
        if (context.equals((Object)ConfigurationContext.COMMON_SETTINGS)) {
            this.configurationModel.getRawConfigurationMap().put(key, value);
        } else if (context.equals((Object)ConfigurationContext.LAUNCH_SETTINGS)) {
            Map launchSettings = this.configurationModel.getFirstLaunchSettings();
            launchSettings.put(key, (String)value);
            this.setLaunchSettings(launchSettings);
        }
    }

    private void setLaunchSettings(Map<String, String> launchSettings) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        list.add(launchSettings);
        this.configurationModel.getRawConfigurationMap().put("launchSettings", list);
    }

    private void loadWorkflowIntegration(String componentName) throws FileNotFoundException {
        IntegrationContext context = this.integrationContextRegistry.getToolIntegrationContextByType(IntegrationContextType.WORKFLOW.toString());
        if (context == null) {
            LOG.error((Object)StringUtils.format((String)"The Workflow Integration Editor cannot be displayed. No Integration Context of the expected type \"%s\" of the Component \"%s\" exists.", (Object[])new Object[]{IntegrationContextType.WORKFLOW.toString(), componentName}));
            return;
        }
        String rootPath = context.getRootPathToToolIntegrationDirectory();
        String integrationDir = context.getNameOfToolIntegrationDirectory();
        Path configFilePath = Paths.get(rootPath, integrationDir, componentName, context.getConfigurationFilename());
        File configFile = configFilePath.toFile();
        if (!configFile.exists()) {
            throw new FileNotFoundException(configFilePath.toString());
        }
        try {
            this.configurationModel.setRawConfigurationMap((Map)JsonUtils.getDefaultObjectMapper().readValue(configFile, HashMap.class));
        }
        catch (IOException e) {
            throw new RuntimeException(StringUtils.format((String)"Error reading the configuration file of the integration \"%s\"", (Object[])new Object[]{componentName}), e);
        }
        Path workflowFilePath = Paths.get(rootPath, integrationDir, componentName, "workflow.wf");
        this.setWorkflowDescriptionFromFile(workflowFilePath.toFile());
    }

    private WorkflowDescription loadWorkflowDescriptionFromFile(File workflowFile) throws FileNotFoundException {
        ServiceRegistryAccess serviceRegistry = ServiceRegistry.createAccessFor((Object)((Object)this));
        PersistentWorkflowDescriptionLoaderService loaderService = (PersistentWorkflowDescriptionLoaderService)serviceRegistry.getService(PersistentWorkflowDescriptionLoaderService.class);
        WorkflowDescriptionLoaderCallback loaderCallback = new WorkflowDescriptionLoaderCallback(){

            public boolean arePartlyParsedWorkflowConsiderValid() {
                return false;
            }

            public void onNonSilentWorkflowFileUpdated(String message, String backupFilename) {
            }

            public void onSilentWorkflowFileUpdated(String message) {
            }

            public void onWorkflowFileParsingPartlyFailed(String backupFilename) {
            }
        };
        if (!workflowFile.exists()) {
            throw new FileNotFoundException(workflowFile.toString());
        }
        try {
            return loaderService.loadWorkflowDescriptionFromFile(workflowFile, loaderCallback);
        }
        catch (WorkflowFileException e) {
            LOG.error((Object)"Error reading the workflow file.", (Throwable)e);
            return null;
        }
    }

    public void createEndpointAdapters(List<EndpointAdapter> endpointAdapters) {
        EndpointAdapters.Builder adapters = new EndpointAdapters.Builder();
        for (EndpointAdapter adapter : endpointAdapters) {
            adapters.addEndpointAdapter(adapter);
        }
        EndpointAdapterToJsonConverter endpointAdapterConverter = new EndpointAdapterToJsonConverter(adapters.build());
        this.configurationModel.getRawConfigurationMap().put("inputs", endpointAdapterConverter.toInputDefinitions());
        this.configurationModel.getRawConfigurationMap().put("outputs", endpointAdapterConverter.toOutputDefinitions());
        List endpointAdapterConfiguration = endpointAdapterConverter.toEndpointAdapterDefinitions();
        try {
            String endpointAdaptersConfigurationString = new ObjectMapper().writeValueAsString((Object)endpointAdapterConfiguration);
            this.configurationModel.getRawConfigurationMap().put("endpointAdapters", endpointAdaptersConfigurationString);
        }
        catch (JsonProcessingException e) {
            LOG.error((Object)"Error creating endpoint adapters for workflow integration.", (Throwable)e);
        }
    }

    public List<EndpointAdapter> getPersistedEndpointAdapters() {
        try {
            List endpointAdapterDefinitions = this.getWorkflowConfigurationModel().getEndpointAdapters();
            return endpointAdapterDefinitions.stream().map(entry -> {
                if (((String)entry.get("type")).equals("INPUT")) {
                    return EndpointAdapter.inputAdapterBuilder().internalEndpointName((String)entry.get("internalName")).externalEndpointName((String)entry.get("externalName")).workflowNodeIdentifier((String)entry.get("identifier")).inputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)((String)entry.get("inputHandling")))).inputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)((String)entry.get("inputExecutionConstraint")))).build();
                }
                return EndpointAdapter.outputAdapterBuilder().internalEndpointName((String)entry.get("internalName")).externalEndpointName((String)entry.get("externalName")).workflowNodeIdentifier((String)entry.get("identifier")).build();
            }).collect(Collectors.toList());
        }
        catch (JsonProcessingException e) {
            LOG.error((Object)e.getStackTrace());
            return null;
        }
    }

    public boolean integrateWorkflow() {
        try {
            this.integrationService.integrateWorkflowFileAsComponent(this.getWorkflowDescription(), this.getConfigurationModel(), this.originalName);
        }
        catch (IOException e) {
            LOG.error((Object)"Error integrating component.", (Throwable)e);
            return false;
        }
        return true;
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    public void setWorkflowDescription(WorkflowDescription workflowDescription) {
        this.workflowDescription = workflowDescription;
    }

    public void setWorkflowDescriptionFromFile(File workflowFile) throws FileNotFoundException {
        WorkflowDescription workflowDec = this.loadWorkflowDescriptionFromFile(workflowFile);
        this.setWorkflowDescription(workflowDec);
        if (this.getWorkflowDescription().getName() == null) {
            this.getWorkflowDescription().setName(workflowFile.getName());
        }
    }

    public String getEditorTitle() {
        String workflowName = this.getWorkflowDescription().getName();
        String componentName = this.getConfigurationModel().getToolName();
        StringBuilder builder = new StringBuilder("Workflow Integration Editor");
        if (componentName != null && !componentName.isEmpty()) {
            builder.append(StringUtils.format((String)" - %s", (Object[])new Object[]{componentName}));
        } else if (workflowName != null && !workflowName.isEmpty()) {
            builder.append(StringUtils.format((String)" (%s)", (Object[])new Object[]{workflowName}));
        }
        return builder.toString();
    }

    public Optional<String> getOriginalName() {
        return this.originalName;
    }

    public static enum ConfigurationContext {
        LAUNCH_SETTINGS,
        COMMON_SETTINGS;

    }
}

