/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class EventLogEntryImpl
implements EventLogEntry {
    public static final int EXPECTED_HUMAN_READABLE_TIMESTAMP_LENGTH = 23;
    private static final DateTimeFormatter sharedHumanReadableTimestampFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS");
    private static final ObjectMapper sharedJsonMapper = new ObjectMapper();
    private final EventType eventType;
    private final Instant timestamp;
    private final Map<String, String> attributeData;

    public EventLogEntryImpl(EventType eventType) {
        this.eventType = Objects.requireNonNull(eventType);
        this.timestamp = Instant.now();
        this.attributeData = new HashMap<String, String>();
    }

    public EventLogEntryImpl(Instant timestamp, EventType eventType, Map<String, String> attributeData) {
        this.eventType = Objects.requireNonNull(eventType);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.attributeData = Objects.requireNonNull(attributeData);
    }

    @Override
    public EventLogEntry set(String key, String value) {
        this.attributeData.put(key, value);
        return this;
    }

    @Override
    public EventLogEntry set(String key, long value) {
        this.set(key, Long.toString(value));
        return this;
    }

    @Override
    public EventLogEntry set(String key, int value) {
        this.set(key, Integer.toString(value));
        return this;
    }

    @Override
    public EventLogEntry setAll(Map<String, String> dataMap) {
        this.attributeData.putAll(dataMap);
        return this;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public String getEventTypeId() {
        return this.eventType.getId();
    }

    @Override
    public String getEventTypeTitle() {
        return this.eventType.getTitle();
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, String> getAttributeData() {
        return this.attributeData;
    }

    public String getHumanReadableLocalTimestamp() {
        return EventLogEntryImpl.generateHumanReadableLocalTimestamp(this.timestamp);
    }

    public String getAttributeDataAsConpactJsonString() {
        return EventLogEntryImpl.generateCompactJsonString(this.attributeData);
    }

    public static String generateCompactJsonString(Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return "{}";
        }
        try {
            return sharedJsonMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected failure: JSON encoding of event data failed", e);
        }
    }

    public static String generateHumanReadableLocalTimestamp(Instant instant) {
        LocalDateTime localDateTime = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
        String formatted = localDateTime.format(sharedHumanReadableTimestampFormatter);
        int len = formatted.length();
        if (len == 23) {
            return formatted;
        }
        throw new IllegalStateException(Integer.toString(len));
    }
}

