/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.api;

import de.rcenvironment.core.datamodel.api.EndpointType;

public enum EndpointCharacter {
    SAME_LOOP("From same loop level", "To same loop level"),
    OUTER_LOOP("From upper loop level", "To upper loop level");

    public static final String VALUE_SAME_LOOP = "sameLoop";
    public static final String VALUE_OUTER_LOOP = "outerLoop";
    private final String displayNameInput;
    private final String displayNameOutput;

    private EndpointCharacter(String displayNameInput, String displayNameOutput) {
        this.displayNameInput = displayNameInput;
        this.displayNameOutput = displayNameOutput;
    }

    public static EndpointCharacter fromEndpointDefinitionValue(String valueName) {
        switch (valueName) {
            case "sameLoop": {
                return SAME_LOOP;
            }
            case "outerLoop": {
                return OUTER_LOOP;
            }
        }
        return null;
    }

    public String getDisplayName(EndpointType endpointType) {
        switch (endpointType) {
            case INPUT: {
                return this.displayNameInput;
            }
            case OUTPUT: {
                return this.displayNameOutput;
            }
        }
        throw new IllegalArgumentException("Endpint type unknown: " + (Object)((Object)endpointType));
    }
}

