/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.data.efs.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.datamanagement.backend.DataBackend;
import de.rcenvironment.core.datamanagement.backend.data.efs.internal.EFSDataBackendConfiguration;
import de.rcenvironment.core.datamanagement.backend.data.efs.internal.EncapsulatedEFSService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.BundleContext;

public class EFSDataBackend
implements DataBackend {
    public static final String SCHEMA_EFS = "efs";
    private static final String SCHEME_URI_COMPLETION = "://";
    private static final String SLASH = "/";
    private static final String ZIP_FILE_SUFFIX = ".gz";
    private static final String STORAGE_SUBDIRECTORY = "data";
    private static final String FAILED_TO_WRITE_FILE_FOR_URI = "Failed to write file for URI ";
    private static final int STREAM_BUFFER_SIZE = 262144;
    private static Pattern parentPattern;
    private static Pattern uriPattern;
    private static boolean useGZipCompression;
    private EFSDataBackendConfiguration configuration;
    private ConfigurationService configurationService;
    private EncapsulatedEFSService encapsulatedEFSService;
    private final Log log = LogFactory.getLog(this.getClass());

    static {
        useGZipCompression = false;
        parentPattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
        uriPattern = Pattern.compile("/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    }

    protected void activate(BundleContext context) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.configuration = new EFSDataBackendConfiguration();
        useGZipCompression = true;
        if (this.configuration.getEfsStorage().equals("")) {
            File efsSubDir = this.configurationService.initializeSubDirInConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_DATA_MANAGEMENT, STORAGE_SUBDIRECTORY);
            String efsPath = efsSubDir.getAbsolutePath();
            this.configuration.setEfsStorage(efsPath);
            this.log.debug((Object)("Initializing EFS storage in " + efsPath));
        } else {
            this.log.warn((Object)"Unexpected state: EFS storage path already defined");
        }
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    protected void bindEncapsulatedEFSService(EncapsulatedEFSService newEncapsulatedEFService) {
        this.encapsulatedEFSService = newEncapsulatedEFService;
    }

    public boolean delete(URI uri) {
        boolean deleted = false;
        if (!this.isURIValid(uri)) {
            throw new IllegalArgumentException("Given URI representing a file to delete is not valid: " + uri);
        }
        try {
            File fileToDelete = new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath());
            if (!fileToDelete.exists()) {
                fileToDelete = new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath() + ZIP_FILE_SUFFIX);
            }
            if (!fileToDelete.exists()) {
                this.log.debug((Object)("Given URI representing a file to delete could not be resolved to an existing path in the file store: " + fileToDelete.getAbsolutePath()));
            } else {
                IFileStore fileStore = this.encapsulatedEFSService.getStore(fileToDelete.toURI());
                fileStore.delete(0, null);
                deleted = true;
                IFileStore parent = fileStore.getParent();
                if (this.isParentValid(parent.getName()) && parent.childNames(0, null).length == 0) {
                    parent.delete(0, null);
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("File with given URI could not be deleted: " + uri + " (Message: " + e.getMessage() + ")", e.getCause());
        }
        return deleted;
    }

    public InputStream get(URI uri) {
        return this.get(uri, true);
    }

    public InputStream get(URI uri, boolean decompress) {
        IFileStore fileStore = null;
        if (!this.isURIValid(uri)) {
            throw new IllegalArgumentException("Given URI representing a file to get is not valid: " + uri);
        }
        try {
            boolean isZipped = false;
            File fileToGet = new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath());
            if (!fileToGet.exists()) {
                fileToGet = new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath() + ZIP_FILE_SUFFIX);
                isZipped = true;
            }
            fileStore = this.encapsulatedEFSService.getStore(fileToGet.toURI());
            BufferedInputStream storageInputStream = isZipped && decompress ? new BufferedInputStream((InputStream)new GzipCompressorInputStream(fileStore.openInputStream(0, null)), 262144) : new BufferedInputStream(fileStore.openInputStream(0, null), 262144);
            return storageInputStream;
        }
        catch (IOException | CoreException e) {
            throw new RuntimeException("File with given URI could not be found: " + uri, e);
        }
    }

    public URI suggestLocation(UUID guid) {
        URI newUri;
        try {
            newUri = new URI("efs:///" + guid.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Creating URI failed.", e);
        }
        return newUri;
    }

    public long put(URI uri, Object object) {
        return this.put(uri, object, false);
    }

    public long put(URI uri, Object object, boolean alreadyCompressed) {
        long writtenBytes;
        block23: {
            if (!this.isURIValid(uri)) {
                throw new IllegalArgumentException("Given URI representing the location to put a file to is not valid: " + uri);
            }
            writtenBytes = 0L;
            if (object instanceof InputStream) {
                IFileStore parent;
                InputStream inputStream = (InputStream)object;
                BufferedOutputStream storageOutputStream = null;
                IFileStore fileStore = null;
                try {
                    parent = null;
                    File fileToSave = useGZipCompression && !alreadyCompressed ? new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath() + ZIP_FILE_SUFFIX) : new File(String.valueOf(this.getFileStorageRoot().getAbsolutePath()) + new File(uri.getRawPath()).getPath());
                    fileStore = this.encapsulatedEFSService.getStore(fileToSave.toURI());
                    parent = fileStore.getParent();
                    if (parent != null && this.isParentValid(parent.getName())) {
                        parent.mkdir(0, null);
                    }
                    storageOutputStream = useGZipCompression && !alreadyCompressed ? new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream(fileStore.openOutputStream(0, null)), 262144) : new BufferedOutputStream(fileStore.openOutputStream(0, null), 262144);
                }
                catch (CoreException e) {
                    throw new RuntimeException(FAILED_TO_WRITE_FILE_FOR_URI + uri, e);
                }
                catch (IOException e) {
                    throw new RuntimeException(FAILED_TO_WRITE_FILE_FOR_URI + uri, e);
                }
                try {
                    try {
                        byte[] buffer = new byte[262144];
                        int n = 0;
                        while (-1 != (n = inputStream.read(buffer))) {
                            ((OutputStream)storageOutputStream).write(buffer, 0, n);
                            writtenBytes += (long)n;
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        try {
                            fileStore.delete(0, null);
                            parent = fileStore.getParent();
                            if (this.isParentValid(parent.getName()) && parent.childNames(0, null).length == 0) {
                                parent.delete(0, null);
                            }
                        }
                        catch (CoreException coreException) {
                            this.log.error((Object)("File with given URI for which writing failed could not be deleted: " + uri));
                        }
                        throw new RuntimeException(FAILED_TO_WRITE_FILE_FOR_URI + uri, e);
                    }
                }
                finally {
                    try {
                        ((OutputStream)storageOutputStream).close();
                    }
                    catch (IOException e2) {
                        this.log.error((Object)("EFS output stream for given URI could not be closed: " + uri), (Throwable)e2);
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        this.log.error((Object)("Input stream for given URI could not be closed: " + uri), (Throwable)e2);
                    }
                }
            }
            throw new IllegalArgumentException("Given object to put is not an instance of InputStream: " + object);
        }
        return writtenBytes;
    }

    private boolean isParentValid(String name) {
        String stringToTest = name;
        Matcher matcher = parentPattern.matcher(stringToTest);
        boolean isValue = matcher.matches();
        return isValue;
    }

    private boolean isURIValid(URI uri) {
        String stringToTest = uri.getPath();
        Matcher matcher = uriPattern.matcher(stringToTest);
        boolean isValue = matcher.matches();
        return isValue;
    }

    private File getFileStorageRoot() {
        return new File(this.configuration.getEfsStorage()).getAbsoluteFile();
    }
}

