/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration;

import de.rcenvironment.core.configuration.bootstrap.CommandStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CommandLineArguments {
    public static final String HEADLESS_MODE_TOKEN = "--headless";
    public static final String USE_DEFAULT_WORKSPACE_TOKEN = "--use-default-workspace";
    public static final String EXEC_OPTION_TOKEN = "--exec";
    public static final String DISABLE_COMPONENTS_TOKEN = "--disable-components";
    public static final String BATCH_OPTION_TOKEN = "--batch";
    public static final String CONFIGURATION_SHELL_TOKEN = "--configure";
    private static volatile CommandLineArguments configuration;
    private boolean showAdvancedTab;
    private boolean headlessModeRequested;
    private boolean useDefaultWorkspaceRequested;
    private boolean batchModeRequested;
    private boolean configurationShellRequested;
    private String[] execCommandTokens;
    private boolean doNotStartComponentsRequested;
    private boolean doNotStartNetworkRequested;
    private boolean isValid;

    private CommandLineArguments(String[] input) {
        CommandStack args = new CommandStack(input);
        while (args.hasNext()) {
            String cmdString;
            String option = args.getNext();
            if (option.equals(HEADLESS_MODE_TOKEN)) {
                this.setHeadlessModeRequested(true);
                continue;
            }
            if (option.equals(USE_DEFAULT_WORKSPACE_TOKEN)) {
                this.setUseDefaultWorkspaceRequested(true);
                continue;
            }
            if (option.equals(CONFIGURATION_SHELL_TOKEN)) {
                this.setConfigurationShellRequested(true);
                continue;
            }
            if (option.equals("--wf-run")) {
                this.assertNoExecCommandYet();
                String wfFile = args.getNext();
                this.parseExecCommandTokens("wf run " + wfFile + " ; stop");
                continue;
            }
            if (option.equals(DISABLE_COMPONENTS_TOKEN)) {
                this.setDoNotStartComponentsRequested(true);
                continue;
            }
            if (option.equals(EXEC_OPTION_TOKEN)) {
                this.assertNoExecCommandYet();
                cmdString = args.getNext();
                this.parseExecCommandTokens(cmdString);
                continue;
            }
            if (option.equals(BATCH_OPTION_TOKEN)) {
                this.assertNoExecCommandYet();
                cmdString = args.getNext();
                this.parseExecCommandTokens(cmdString);
                this.setBatchModeRequested(true);
                continue;
            }
            if (option.equals("--showAdvancedTab")) {
                this.setShowAdvancedTab(true);
                continue;
            }
            if (option.equals("-p") || option.equals("--profile")) {
                if (!args.hasNextIsValue()) continue;
                args.getNext();
                continue;
            }
            if (option.equals("-install") || option.equals("-testproperties")) {
                args.getNext();
                continue;
            }
            if (option.equals("--upgrade-profile")) continue;
            CommandLineArguments.getTemporaryLogger().warn((Object)("Ignoring unrecognized command-line argument '" + option + "' at position " + args.lastPos()));
        }
        this.isValid = true;
    }

    public static void initialize(String[] input) {
        configuration = new CommandLineArguments(input);
        CommandLineArguments.getTemporaryLogger().debug((Object)"Parsed command-line options");
    }

    public static boolean isHeadlessModeRequested() {
        return CommandLineArguments.getConfiguration().headlessModeRequested;
    }

    public static boolean isBatchModeRequested() {
        return CommandLineArguments.getConfiguration().batchModeRequested;
    }

    public static boolean isConfigurationShellRequested() {
        return CommandLineArguments.getConfiguration().configurationShellRequested;
    }

    public static boolean isNormalOperationRequested() {
        return !CommandLineArguments.getConfiguration().configurationShellRequested;
    }

    public static boolean isDoNotStartComponentsRequested() {
        return CommandLineArguments.getConfiguration().doNotStartComponentsRequested || CommandLineArguments.getConfiguration().configurationShellRequested;
    }

    public static boolean isDoNotStartNetworkRequested() {
        return CommandLineArguments.getConfiguration().doNotStartNetworkRequested || CommandLineArguments.getConfiguration().configurationShellRequested;
    }

    public static boolean isUseDefaultWorkspaceRequested() {
        return CommandLineArguments.getConfiguration().useDefaultWorkspaceRequested;
    }

    private static CommandLineArguments getConfiguration() {
        if (configuration == null) {
            throw new IllegalStateException("A configuration value was accessed before the configuration was parsed");
        }
        return configuration;
    }

    public static boolean isShowAdvancedTab() {
        return CommandLineArguments.getConfiguration().showAdvancedTab;
    }

    public static String[] getExecCommandTokens() {
        return CommandLineArguments.getConfiguration().execCommandTokens;
    }

    public static boolean hasConfigurationErrors() {
        return !CommandLineArguments.getConfiguration().isValid;
    }

    private void setHeadlessModeRequested(boolean value) {
        this.headlessModeRequested = value;
    }

    private void setUseDefaultWorkspaceRequested(boolean value) {
        this.useDefaultWorkspaceRequested = value;
    }

    private void setConfigurationShellRequested(boolean value) {
        this.configurationShellRequested = value;
        this.setHeadlessModeRequested(true);
        this.setDoNotStartComponentsRequested(true);
        this.setDoNotStartNetworkRequested(true);
    }

    private void setDoNotStartNetworkRequested(boolean value) {
        this.doNotStartNetworkRequested = value;
    }

    private void setDoNotStartComponentsRequested(boolean value) {
        this.doNotStartComponentsRequested = value;
    }

    private void setBatchModeRequested(boolean value) {
        this.batchModeRequested = value;
        this.setHeadlessModeRequested(true);
    }

    private void setShowAdvancedTab(boolean value) {
        this.showAdvancedTab = value;
    }

    private void assertNoExecCommandYet() {
        if (this.execCommandTokens != null) {
            throw new IllegalArgumentException("Only one of \"--exec\", \"--batch\" or \"--wf-run\" can be used at the same time");
        }
    }

    private void parseExecCommandTokens(String cmdString) {
        this.execCommandTokens = cmdString.trim().split("\\s+");
    }

    private static Log getTemporaryLogger() {
        return LogFactory.getLog(CommandLineArguments.class);
    }
}

