/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.internal.IconHelper;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegrationService;
import de.rcenvironment.core.component.integration.workflow.internal.WorkflowIntegrationContext;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapterToJsonConverter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowIntegrationServiceImpl
implements WorkflowIntegrationService {
    private static final String CONFIGURATION_FILENAME = "configuration.json";
    private static final String CONFIGURATION_TEMPLATE_FILENAME = "configuration.json";
    private final Log log = LogFactory.getLog(WorkflowIntegrationServiceImpl.class);
    private ConfigurationService configurationService;
    private WorkflowIntegrationContext integrationContext;
    private ToolIntegrationService toolIntegrationService;
    private IconHelper iconHelper;

    @Override
    public void integrateWorkflowFileAsComponent(WorkflowDescription workflowDescription, ConfigurationMap model, Optional<String> originalName) throws IOException {
        this.toolIntegrationService.setFileWatcherActive(false);
        String componentname = model.getToolName();
        this.toolIntegrationService.removeTool(componentname, (IntegrationContext)this.integrationContext);
        this.copyOriginalFilesToIntegrationDirectory(model, originalName, componentname);
        this.writeWorkflowFileToIntegrationDirectory(workflowDescription, componentname);
        File workflowConfigurationFile = this.createFile(this.getToolIntegrationDirectoryPath(componentname));
        this.iconHelper.prescaleAndCopyIcon(model, workflowConfigurationFile);
        this.toolIntegrationService.copyToolDocumentation(model, workflowConfigurationFile);
        this.writeConfigurationToIntegrationDirectory(componentname, model.getRawConfigurationMap());
        this.toolIntegrationService.integrateTool(model.getRawConfigurationMap(), (IntegrationContext)this.integrationContext);
        this.toolIntegrationService.setFileWatcherActive(true);
        this.toolIntegrationService.registerRecursive(componentname, (IntegrationContext)this.integrationContext);
    }

    @Override
    public void integrateWorkflowFileAsComponent(WorkflowDescription workflowDescription, String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        this.toolIntegrationService.setFileWatcherActive(false);
        this.writeWorkflowFileToIntegrationDirectory(workflowDescription, componentname);
        Map<String, Object> configurationMap = this.getConfigurationForWorkflowIntegration(componentname, endpointAdapterDefinitions);
        this.writeConfigurationToIntegrationDirectory(componentname, configurationMap);
        this.toolIntegrationService.setFileWatcherActive(true);
        this.toolIntegrationService.registerRecursive(componentname, (IntegrationContext)this.integrationContext);
    }

    private void writeWorkflowFileToIntegrationDirectory(WorkflowDescription workflowDescription, String componentname) throws IOException {
        File workflowFileTarget = this.createWorkflowFile(componentname);
        this.createParentDirectories(workflowFileTarget);
        this.writeWorkflowDescriptionToFile(workflowDescription, workflowFileTarget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeWorkflowDescriptionToFile(WorkflowDescription workflowDescription, File workflowFileTarget) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayOutputStream byteOutputStream = this.writeDescriptionToStream(workflowDescription);
            try {
                try (OutputStream fileOutputStream = this.createFileOutputStream(workflowFileTarget);){
                    byteOutputStream.writeTo(fileOutputStream);
                }
                if (byteOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (byteOutputStream == null) throw throwable;
                byteOutputStream.close();
                throw throwable;
            }
            byteOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected ByteArrayOutputStream writeDescriptionToStream(WorkflowDescription workflowDescription) throws IOException {
        WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
        return persistenceHandler.writeWorkflowDescriptionToStream(workflowDescription);
    }

    private void writeConfigurationToIntegrationDirectory(String componentname, Map<String, Object> configurationMap) throws IOException {
        OutputStream outputStream = this.constructOutputStreamForConfiguration(componentname);
        this.writeMapToJson(configurationMap, outputStream);
        this.toolIntegrationService.putToolNameToPath(componentname, new File(this.getToolIntegrationDirectoryPath(componentname)));
    }

    private OutputStream constructOutputStreamForConfiguration(String componentname) throws FileNotFoundException {
        File configurationFileTarget = this.createConfigurationFile(componentname);
        return this.createFileOutputStream(configurationFileTarget);
    }

    private void copyOriginalFilesToIntegrationDirectory(ConfigurationMap model, Optional<String> originalName, String componentname) throws IOException {
        if (originalName.isPresent() && !originalName.get().equals(componentname)) {
            this.copyOriginalIconToIntegrationDirectory(model, originalName.get(), componentname);
            this.copyOriginalDocumentationToIntegrationDirectory(model, originalName.get(), componentname);
            this.removeOriginalDirectory(originalName.get());
            this.toolIntegrationService.unregisterIntegration(originalName.get(), (IntegrationContext)this.integrationContext);
            this.toolIntegrationService.removeTool(originalName.get(), (IntegrationContext)this.integrationContext);
        }
    }

    private void copyOriginalDocumentationToIntegrationDirectory(ConfigurationMap model, String originalName, String componentname) {
        File doc;
        if (model.containsDocFilePath() && !(doc = new File(model.getDocFilePath())).isAbsolute()) {
            File originalDir = new File(this.createFile(this.getToolIntegrationDirectoryPath(originalName)), "docs");
            File newDir = new File(this.createFile(this.getToolIntegrationDirectoryPath(componentname)), "docs");
            File originalFile = new File(originalDir, model.getDocFilePath());
            File newFile = new File(newDir, model.getDocFilePath());
            try {
                FileUtils.copyFile((File)originalFile, (File)newFile);
            }
            catch (IOException e) {
                this.log.warn((Object)"Could not copy documentation into integration folder.", (Throwable)e);
            }
        }
    }

    private void copyOriginalIconToIntegrationDirectory(ConfigurationMap model, String originalName, String componentname) {
        File icon;
        if (model.getIconPath() != null && !model.getIconPath().isEmpty() && !(icon = new File(model.getIconPath())).isAbsolute()) {
            File originalFile = new File(this.createFile(this.getToolIntegrationDirectoryPath(originalName)), model.getIconPath());
            File newFile = new File(this.createFile(this.getToolIntegrationDirectoryPath(componentname)), model.getIconPath());
            try {
                FileUtils.copyFile((File)originalFile, (File)newFile);
            }
            catch (IOException e) {
                this.log.warn((Object)"Could not copy icon into integration folder.", (Throwable)e);
            }
        }
    }

    private void removeOriginalDirectory(String originalName) throws IOException {
        File remove = this.createFile(this.getToolIntegrationDirectoryPath(originalName));
        if (remove.isDirectory()) {
            FileUtils.forceDelete((File)remove);
        }
    }

    private String getPathToWorkflowIntegrationDirectory() {
        return String.join((CharSequence)File.separator, this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT).getAbsolutePath(), this.integrationContext.getNameOfToolIntegrationDirectory());
    }

    private Map<String, Object> getConfigurationForWorkflowIntegration(String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        InputStream configurationTemplateStream = this.createConfigurationTemplateStream();
        Map<String, Object> configurationTemplate = this.parseJson(configurationTemplateStream);
        return this.injectValuesIntoConfigurationTemplate(configurationTemplate, componentname, endpointAdapterDefinitions);
    }

    private Map<String, Object> injectValuesIntoConfigurationTemplate(Map<String, Object> configurationTemplate, String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        configurationTemplate.put("toolName", componentname);
        EndpointAdapterToJsonConverter endpointAdapterConverter = new EndpointAdapterToJsonConverter(endpointAdapterDefinitions);
        configurationTemplate.put("inputs", endpointAdapterConverter.toInputDefinitions());
        configurationTemplate.put("outputs", endpointAdapterConverter.toOutputDefinitions());
        List<Map<String, Object>> endpointAdapterConfiguration = endpointAdapterConverter.toEndpointAdapterDefinitions();
        try {
            String endpointAdapters = new ObjectMapper().writeValueAsString(endpointAdapterConfiguration);
            configurationTemplate.put("endpointAdapters", endpointAdapters);
        }
        catch (JsonProcessingException e) {
            throw new IOException("Could not unparse endpoint adapter definition to JSON", e);
        }
        return configurationTemplate;
    }

    protected InputStream createConfigurationTemplateStream() {
        return this.getClass().getClassLoader().getResourceAsStream("configuration.json");
    }

    protected Map<String, Object> parseJson(InputStream configurationTemplateStream) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        Map configurationTemplate = (Map)mapper.readValue(configurationTemplateStream, HashMap.class);
        return configurationTemplate;
    }

    @Override
    public synchronized Set<String> getActiveIntegratedWorkflowComponentIds() {
        HashSet<String> activeIds = new HashSet<String>();
        Map integratedConfigurations = this.toolIntegrationService.getIntegratedConfigurations();
        for (Map.Entry entry : integratedConfigurations.entrySet()) {
            Map configMap = (Map)entry.getValue();
            if (!configMap.get("integrationType").equals(IntegrationContextType.WORKFLOW.toString()) || configMap.get("isActive") != null && !((Boolean)configMap.get("isActive")).booleanValue()) continue;
            activeIds.add((String)entry.getKey());
        }
        return activeIds;
    }

    @Override
    public synchronized Set<String> getInactiveIntegratedWorkflowComponentIds() {
        HashSet<String> inactiveIds = new HashSet<String>();
        Map integratedConfigurations = this.toolIntegrationService.getIntegratedConfigurations();
        for (Map.Entry entry : integratedConfigurations.entrySet()) {
            Map configMap = (Map)entry.getValue();
            if (!configMap.get("integrationType").equals(IntegrationContextType.WORKFLOW.toString()) || !Boolean.FALSE.equals(configMap.get("isActive"))) continue;
            inactiveIds.add((String)entry.getKey());
        }
        return inactiveIds;
    }

    protected void writeMapToJson(Map<String, Object> configuration, OutputStream outputStream) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, configuration);
    }

    private File createConfigurationFile(String componentname) {
        String configurationFilePath = String.join((CharSequence)File.separator, this.getPathToWorkflowIntegrationDirectory(), String.valueOf(this.integrationContext.getToolDirectoryPrefix()) + componentname, "configuration.json");
        return this.createFile(configurationFilePath);
    }

    private File createWorkflowFile(String componentname) {
        String workflowFilePath = String.join((CharSequence)File.separator, this.getToolIntegrationDirectoryPath(componentname), "workflow.wf");
        return this.createFile(workflowFilePath);
    }

    private String getToolIntegrationDirectoryPath(String componentname) {
        return String.join((CharSequence)File.separator, this.getPathToWorkflowIntegrationDirectory(), String.valueOf(this.integrationContext.getToolDirectoryPrefix()) + componentname);
    }

    protected File createFile(String path) {
        return new File(path);
    }

    protected void createParentDirectories(File workflowFileTarget) {
        workflowFileTarget.getParentFile().mkdirs();
    }

    protected OutputStream createFileOutputStream(File workflowFileTarget) throws FileNotFoundException {
        return new FileOutputStream(workflowFileTarget);
    }

    @Reference
    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    @Reference
    public void bindToolIntegrationService(ToolIntegrationService service) {
        this.toolIntegrationService = service;
    }

    @Reference
    public void bindToolIntegrationServiceRegistry(ToolIntegrationContextRegistry registry) {
        this.integrationContext = (WorkflowIntegrationContext)registry.getToolIntegrationContextByType("workflow");
    }

    @Reference
    public void bindIconHelper(IconHelper helper) {
        this.iconHelper = helper;
    }
}

