/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.cpacs.internal;

import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.cpacs.CpacsToolIntegrationConstants;
import de.rcenvironment.core.component.integration.cpacs.CpacsToolIntegratorComponent;
import de.rcenvironment.core.configuration.ConfigurationService;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public final class CpacsToolIntegrationContext
implements IntegrationContext {
    private static ConfigurationService configService;

    public String getContextId() {
        return CpacsToolIntegrationConstants.CPACS_TOOL_INTEGRATION_CONTEXT_UID;
    }

    public String getRootPathToToolIntegrationDirectory() {
        return configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT).getAbsolutePath();
    }

    public File[] getReadOnlyPathsList() {
        return configService.getConfigurablePathList(ConfigurationService.ConfigurablePathListId.READABLE_INTEGRATION_DIRS);
    }

    public String getNameOfToolIntegrationDirectory() {
        return "tools" + File.separator + "cpacs";
    }

    public String getToolDirectoryPrefix() {
        return "";
    }

    public String getConfigurationFilename() {
        return "configuration.json";
    }

    public String getImplementingComponentClassName() {
        return CpacsToolIntegratorComponent.class.getCanonicalName();
    }

    public String getPrefixForComponentId() {
        return "de.rcenvironment.integration.cpacs.";
    }

    public String getDefaultComponentGroupId() {
        return "User Integrated Tools";
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, name="Configuration Service")
    protected void bindConfigurationService(ConfigurationService configServiceIn) {
        configService = configServiceIn;
    }

    public IntegrationContextType getContextType() {
        return IntegrationContextType.CPACS;
    }

    public String getContextTypeString() {
        return IntegrationContextType.CPACS.toString();
    }

    public String[] getDisabledIntegrationKeys() {
        return new String[]{"never", "setToolDirAsWorkingDir"};
    }

    public Optional<ConfigurationMap> parseConfigurationMap(Map<String, Object> rawConfigurationMap) {
        return Optional.ofNullable(ConfigurationMap.fromMap(rawConfigurationMap));
    }
}

