/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.utils;

import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.impl.NetworkContactPointImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;

public final class NetworkContactPointUtils {
    private static final Pattern NCP_DEFINITION_PATTERN = Pattern.compile("^\\s*([\\w\\-]+):([\\w.\\-]+):(\\d+)(?:\\s*\\((.*)\\))?\\s*$");
    private static final Pattern ATTRIBUTE_ENTRY_PATTERN = Pattern.compile("^([^=]+)=(.*)$");

    private NetworkContactPointUtils() {
    }

    public static NetworkContactPoint parseStringRepresentation(String contactPointDef) throws IllegalArgumentException {
        Map<String, String> newAttributes;
        Matcher m = NCP_DEFINITION_PATTERN.matcher(contactPointDef);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        String host = m.group(2);
        int port = Integer.parseInt(m.group(3));
        String transportId = m.group(1);
        NetworkContactPointImpl ncp = new NetworkContactPointImpl(host, port, transportId);
        String attributePart = m.group(4);
        if (attributePart != null && !(newAttributes = NetworkContactPointUtils.parseAttributePart(attributePart)).isEmpty()) {
            ncp.setAttributes(newAttributes);
        }
        return ncp;
    }

    public static Map<String, String> parseAttributePart(String attributePart) {
        String[] attributeEntries;
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        String[] stringArray = attributeEntries = attributePart.split(",");
        int n = attributeEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String trimmedEntry = entry.trim();
            if (!trimmedEntry.isEmpty()) {
                Matcher attrMatcher = ATTRIBUTE_ENTRY_PATTERN.matcher(trimmedEntry);
                if (!attrMatcher.matches()) {
                    LogFactory.getLog(NetworkContactPointUtils.class).warn((Object)("Invalid attribute entry: \"" + entry + "\""));
                } else {
                    String key = attrMatcher.group(1).trim();
                    String val = attrMatcher.group(2);
                    val = val != null ? val.trim() : "";
                    newAttributes.put(key, val);
                }
            }
            ++n2;
        }
        return newAttributes;
    }

    public static String toDefinitionString(NetworkContactPoint ncp) {
        String attributesSuffix = "";
        Map<String, String> attributes = ncp.getAttributes();
        if (attributes.size() != 0) {
            attributesSuffix = attributes.toString();
            attributesSuffix = "(" + attributesSuffix.substring(1, attributesSuffix.length() - 1) + ")";
        }
        return StringUtils.format((String)"%s:%s:%s%s", (Object[])new Object[]{ncp.getTransportId(), ncp.getHost(), ncp.getPort(), attributesSuffix});
    }
}

