/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.Assertions;

public class PlatformServiceImpl
implements PlatformService {
    private InitialNodeInformation localInitialNodeInformation;
    private InstanceNodeSessionId localInstanceSessionId;
    private LogicalNodeSessionId localDefaultLogicalNodeSessionId;
    private NodeConfigurationService nodeConfigurationService;
    private InstanceNodeId localInstanceId;
    private LogicalNodeId localDefaultLogicalNodeId;

    public void activate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.localInitialNodeInformation = this.nodeConfigurationService.getInitialNodeInformation();
        this.localInstanceSessionId = this.localInitialNodeInformation.getInstanceNodeSessionId();
        this.localInstanceId = this.localInstanceSessionId.convertToInstanceNodeId();
        this.localDefaultLogicalNodeId = this.localInstanceSessionId.convertToDefaultLogicalNodeId();
        this.localDefaultLogicalNodeSessionId = this.localInstanceSessionId.convertToDefaultLogicalNodeSessionId();
        NodeIdentifierService nodeIdentifierService = this.nodeConfigurationService.getNodeIdentifierService();
        nodeIdentifierService.setDefaultDisplayNameForLocalNode(this.localInstanceSessionId);
    }

    public void bindNodeConfigurationService(NodeConfigurationService newInstance) {
        this.nodeConfigurationService = newInstance;
    }

    @Override
    public InstanceNodeId getLocalInstanceNodeId() {
        return this.localInstanceId;
    }

    @Override
    @AllowRemoteAccess
    public InstanceNodeSessionId getLocalInstanceNodeSessionId() {
        return this.localInstanceSessionId;
    }

    @Override
    public LogicalNodeId getLocalDefaultLogicalNodeId() {
        return this.localDefaultLogicalNodeId;
    }

    @Override
    public LogicalNodeSessionId getLocalDefaultLogicalNodeSessionId() {
        return this.localDefaultLogicalNodeSessionId;
    }

    @Override
    public boolean matchesLocalInstance(ResolvableNodeId identifier) {
        Assertions.isDefined((Object)identifier, (String)"NodeIdentifier must not be null.");
        return this.localInitialNodeInformation.getInstanceNodeSessionId().isSameInstanceNodeAs(identifier);
    }
}

