/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class ExcelComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    private static final long serialVersionUID = -2017053187345233310L;
    private static final String EXCEL_FILE_PATH = "e";
    private String excelFilePath;

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public String getIdentifier() {
        return "de.rcenvironment.excel";
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(EXCEL_FILE_PATH, this.excelFilePath);
        return rootNode.toString();
    }

    public void setExcelFilePath(String excelFilePath) {
        this.excelFilePath = excelFilePath;
    }

    public String getExcelFilePath() {
        return this.excelFilePath;
    }

    public static ExcelComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer) throws IOException {
        ExcelComponentHistoryDataItem historyDataItem = new ExcelComponentHistoryDataItem();
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        ExcelComponentHistoryDataItem.readExcelFilePathFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readExcelFilePathFromString(String historyData, ExcelComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        historyDataItem.excelFilePath = ((ObjectNode)rootNode).get(EXCEL_FILE_PATH).textValue();
    }
}

