/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class PdfArrayIterator {
    public static final int TYPE_KEY_INTEGER = 1;
    public static final int TYPE_VALUE_INTEGER = 2;
    byte[][] rawData = null;
    boolean hasHexChars = false;
    int tokenCount = 0;
    int currentToken = 0;
    int spaceChar = -1;

    public PdfArrayIterator(byte[][] byArray) {
        this.rawData = byArray;
        if (byArray != null) {
            this.tokenCount = byArray.length;
        }
    }

    public PdfArrayIterator(String string) {
        byte[][] byArrayArray = new byte[][]{StringUtils.toBytes(string)};
        this.tokenCount = 1;
    }

    public boolean hasMoreTokens() {
        return this.currentToken < this.tokenCount;
    }

    public int getNextValueType() {
        if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
            return -1;
        }
        int n = this.rawData[this.currentToken].length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = this.rawData[this.currentToken][i];
            if (by >= 47 && by < 58) continue;
            i = n;
            bl = false;
        }
        if (bl) {
            if (this.rawData[this.currentToken][0] != 47) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public String getNextValueAsFontChar(int n, boolean bl, boolean bl2) {
        String string = "";
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            int n2 = this.rawData[this.currentToken].length - 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.rawData[this.currentToken], 1, byArray, 0, n2);
            string = new String(byArray);
            string = StandardFonts.convertNumberToGlyph(string, bl, bl2);
            char c = string.charAt(0);
            if (c == 'B' || c == 'c' || c == 'C' || c == 'G') {
                int n3 = 1;
                int n4 = string.length();
                while (!this.hasHexChars && n3 < n4) {
                    this.hasHexChars = Character.isLetter(string.charAt(n3++));
                }
            }
            if (byArray.length == 5 && byArray[0] == 115 && byArray[1] == 112 && byArray[2] == 97 && byArray[3] == 99 && byArray[4] == 101) {
                this.spaceChar = n;
            }
            ++this.currentToken;
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return string;
    }

    public float getNextValueAsFloat() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            ++this.currentToken;
            if (byArray[0] == 110 && byArray[1] == 117 && byArray[2] == 108 && byArray[2] == 108) {
                return 0.0f;
            }
            return NumberUtils.parseFloat(0, byArray.length, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getNextValueAsInteger() {
        return this.getNextValueAsInteger(true);
    }

    public int getNextValueAsInteger(boolean bl) {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            if (bl) {
                ++this.currentToken;
            }
            int n = 0;
            if (byArray[0] == 47) {
                ++n;
            }
            return NumberUtils.parseInt(n, byArray.length, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public float[] getNextValueAsFloatArray() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            ++this.currentToken;
            if (byArray[0] == 110 && byArray[1] == 117 && byArray[2] == 108 && byArray[2] == 108) {
                return new float[1];
            }
            int n = byArray.length;
            int n2 = 1;
            int n3 = 0;
            for (int i = 1; i < n; ++i) {
                if (byArray[i] != 32 && byArray[i] != 10 && byArray[i] != 13 || byArray[i - 1] == 32 || byArray[i - 1] != 10 || byArray[i - 1] != 13) continue;
                ++n2;
            }
            float[] fArray = new float[n2];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                while (i < n && (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13)) {
                    ++i;
                }
                n4 = i;
                while (i < n && byArray[i] != 32 && byArray[i] != 10 && byArray[i] != 13) {
                    ++i;
                }
                fArray[n3] = NumberUtils.parseFloat(n4, i, byArray);
                ++n3;
            }
            return fArray;
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getNextValueAsConstant(boolean bl) {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            if (bl) {
                ++this.currentToken;
            }
            return PdfDictionary.getIntKey(1, byArray.length - 1, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getSpaceChar() {
        return this.spaceChar;
    }

    public boolean hasHexChars() {
        return this.hasHexChars;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getNextValueAsString(boolean bl) {
        String string = "";
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null) {
                throw new RuntimeException("Null Value exception with PdfArrayIterator rawData=" + this.rawData);
            }
            byte[] byArray = this.rawData[this.currentToken];
            if (byArray != null) {
                string = new String(byArray);
            }
            if (bl) {
                ++this.currentToken;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return string;
    }

    public byte[] getNextValueAsByte(boolean bl) {
        byte[] byArray = null;
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null) {
                throw new RuntimeException("Null Value exception with PdfArrayIterator rawData=" + this.rawData);
            }
            byte[] byArray2 = this.rawData[this.currentToken];
            if (byArray2 != null) {
                int n = byArray2.length;
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, n);
            }
            if (bl) {
                ++this.currentToken;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return byArray;
    }

    public int getNextValueAsKey() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            ++this.currentToken;
            return PdfDictionary.getIntKey(0, byArray.length, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public boolean isNextValueRef() {
        boolean bl = false;
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                return false;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        byte[] byArray = this.rawData[this.currentToken];
        bl = byArray[byArray.length - 1] == 82;
        return bl;
    }

    public void resetToStart() {
        if (this.rawData != null) {
            this.tokenCount = this.rawData.length;
        }
        this.currentToken = 0;
    }
}

