/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jpedal.utils.LogWriter;

public class StatusBar {
    private static final int debug_level = 0;
    private int progress_size = 0;
    private String current = "";
    private static final int progress_max_size = 100;
    private JProgressBar status = null;
    private boolean showMessages = false;
    public float percentageDone = 0.0f;
    private Color masterColor = null;
    private boolean reset = false;

    public StatusBar() {
        this.initialiseStatus("");
    }

    public StatusBar(Color color) {
        this.masterColor = color;
        this.initialiseStatus("");
    }

    public final void initialiseStatus(String string) {
        this.progress_size = 0;
        this.status = new JProgressBar();
        if (this.masterColor != null) {
            this.status.setForeground(this.masterColor);
        }
        this.status.setStringPainted(true);
        this.status.setMaximum(100);
        this.status.setMinimum(0);
        this.updateStatus(string, 4);
    }

    public final void updateStatus(String string, int n) {
        this.current = string;
        if (this.showMessages) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setString(StatusBar.this.current);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
        if (0 > n && LogWriter.isOutput()) {
            LogWriter.writeLog(string);
        }
    }

    public final Component getStatusObject() {
        return this.status;
    }

    public final void setProgress(int n) {
        this.reset = false;
        if (this.status != null) {
            if (n == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < n) {
                this.progress_size = n;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void setProgress(final String string, int n) {
        this.reset = false;
        if (this.status != null) {
            if (n == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < n) {
                this.progress_size = n;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setString(string);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void resetStatus(String string) {
        this.reset = true;
        this.progress_size = 0;
        this.updateStatus(string, 4);
    }

    public final void setClientDisplay() {
        this.showMessages = true;
    }

    public void setVisible(boolean bl) {
        this.status.setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        this.status.setEnabled(bl);
    }

    public boolean isVisible() {
        return this.status.isVisible();
    }

    public boolean isEnabled() {
        return this.status.isEnabled();
    }

    public boolean isDone() {
        return this.reset || this.progress_size >= 100;
    }
}

