/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public abstract class AbstractStepDefinitionBase {
    protected final TestScenarioExecutionContext executionContext;
    protected final TextOutputReceiver outputReceiver;
    protected final Log log = LogFactory.getLog(this.getClass());

    public AbstractStepDefinitionBase(TestScenarioExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.outputReceiver = executionContext.getOutputReceiver();
    }

    protected final void assertPropertyOfTextOutput(ManagedInstance instance, String negationFlag, String useRegexpMarker, String substring, String output, String outputType) {
        boolean useRegexp;
        boolean expectedPresence = negationFlag == null;
        boolean bl = useRegexp = useRegexpMarker != null;
        if (!useRegexp) {
            useRegexpMarker = "";
        }
        boolean found = useRegexp ? Pattern.compile(substring, 8).matcher(output).find() : output.contains(substring);
        if (expectedPresence && !found) {
            Assert.fail((String)StringUtils.format((String)"The %s of instance \"%s\" did not contain %s\"%s\";\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (!expectedPresence && found) {
            Assert.fail((String)StringUtils.format((String)"The %s of instance \"%s\" contained %s\"%s\" although it should not;\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (expectedPresence) {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" contained the expected text \"%s\"", (Object[])new Object[]{outputType, instance, substring}));
        } else {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" did not contain text \"%s\" (as expected)", (Object[])new Object[]{outputType, instance, substring}));
        }
    }

    protected List<String> listOfSingleStringElement(String element) {
        ArrayList<String> singleInstanceList = new ArrayList<String>();
        singleInstanceList.add(element);
        return singleInstanceList;
    }

    protected final List<String> parseCommaSeparatedList(String commaSeparatedList) {
        if (commaSeparatedList == null) {
            return new LinkedList<String>();
        }
        return Arrays.asList(commaSeparatedList.trim().split("\\s*,\\s*"));
    }

    protected final void printToCommandConsole(String text) {
        this.outputReceiver.addOutput(text);
    }

    protected final boolean stringContainsOrContainsNot(String string, String substring, boolean shouldContain, boolean useRegex) {
        boolean found = useRegex ? Pattern.compile(substring, 8).matcher(string).find() : string.contains(substring);
        return shouldContain == found;
    }

    protected final String writeOutputToTempFile(String output) {
        try {
            File tempFile = File.createTempFile("bdd_test_failure_data", ".txt");
            FileUtils.write((File)tempFile, (CharSequence)output);
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected error writing temp file: " + e.toString()));
            return null;
        }
    }

    protected PrefixingTextOutForwarder getTextoutReceiverForIMOperations() {
        return new PrefixingTextOutForwarder("  (IM output) ", this.outputReceiver);
    }
}

