/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.TeeInputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static boolean isLocked(File file) {
        return !file.renameTo(file);
    }

    public static InputStream setUpStreamDuplicationToOutputFile(InputStream inputStream, File logFile) throws IOException {
        return FileUtils.setUpStreamDuplicationToOutputFile(inputStream, logFile, true, false);
    }

    public static InputStream setUpStreamDuplicationToOutputFile(InputStream inputStream, File logFile, boolean useBufferedWriting, boolean appendIfLogFileExists) throws IOException {
        OutputStream logFileStream = new FileOutputStream(logFile, appendIfLogFileExists);
        if (useBufferedWriting) {
            logFileStream = new BufferedOutputStream(logFileStream);
        }
        return new TeeInputStream(inputStream, logFileStream, true);
    }
}

