/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.workflow.view.timeline.Messages;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentRow;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineFilterTreeNode;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class TimelineFilterDialog
extends Dialog
implements ICheckStateListener,
ModifyListener {
    private static final int SHELL_SIZE = 500;
    private static final int DIALOG_WINDOW_OFFSET_Y = 100;
    private static final int DIALOG_WINDOW_OFFSET_X = 150;
    public String initialFilterText = "";
    private CheckboxTreeViewer viewer;
    private TreeContentProvider contentProvider;
    private Tree tree;
    private ComponentViewerFilter filter;
    private TimelineFilterTreeNode rootNode = null;

    public TimelineFilterDialog(Shell parentShell, String[] currentFilter, TimelineComponentRow[] componentRows) {
        super(parentShell);
        this.setShellStyle(33808);
        if (componentRows == null || componentRows.length == 0) {
            return;
        }
        this.rootNode = new TimelineFilterTreeNode();
        TimelineComponentRow[] timelineComponentRowArray = componentRows;
        int n = componentRows.length;
        int n2 = 0;
        while (n2 < n) {
            TimelineComponentRow current = timelineComponentRowArray[n2];
            TimelineFilterTreeNode parentNode = this.rootNode.hasChildWithComponentID(current.getComponentID());
            if (parentNode == null) {
                parentNode = new TimelineFilterTreeNode();
                parentNode.setComponentID(current.getComponentID());
                parentNode.setParent(this.rootNode);
                this.rootNode.addChild(parentNode);
            }
            TimelineFilterTreeNode n3 = new TimelineFilterTreeNode();
            n3.setRow(current);
            n3.setChecked(this.isAllowedComponentName(currentFilter, current.getName()));
            parentNode.addChild(n3);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        TreeContentProvider contentprovider;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        Group sourceGroup = new Group(container, 0);
        sourceGroup.setText(Messages.selectComponents);
        GridData gridData1 = new GridData(4, 4, true, true, 1, 1);
        gridData1.widthHint = 1;
        sourceGroup.setLayoutData((Object)gridData1);
        GridLayout gridLayout1 = new GridLayout(1, false);
        gridLayout1.marginTop = 5;
        gridLayout1.marginWidth = 0;
        gridLayout1.verticalSpacing = 0;
        gridLayout1.marginHeight = 0;
        gridLayout1.horizontalSpacing = 0;
        sourceGroup.setLayout((Layout)gridLayout1);
        this.viewer = new CheckboxTreeViewer((Composite)sourceGroup, 0);
        this.tree = this.viewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setLinesVisible(true);
        this.filter = new ComponentViewerFilter(this.initialFilterText);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setUseHashlookup(true);
        this.contentProvider = contentprovider = new TreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        GridData gridData31 = new GridData();
        gridData31.grabExcessHorizontalSpace = true;
        gridData31.horizontalAlignment = 4;
        Text sourceFilterText = new Text((Composite)sourceGroup, 2048);
        sourceFilterText.setMessage(Messages.filterDialogFilterDefault);
        sourceFilterText.setToolTipText(Messages.filterDialogToolTipText);
        sourceFilterText.setLayoutData((Object)gridData31);
        sourceFilterText.setText(this.initialFilterText);
        sourceFilterText.addModifyListener((ModifyListener)this);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.filterDialogTitle);
        newShell.setSize(500, 500);
        newShell.setLocation(newShell.getParent().getLocation().x + newShell.getParent().getSize().x / 2 - 150, newShell.getParent().getLocation().y + newShell.getParent().getSize().y / 2 - 100);
    }

    public void updateContent() {
        this.viewer.setInput((Object)this.rootNode);
        this.viewer.refresh();
        this.viewer.expandAll();
        Object[] e = this.getCheckedNodeElements();
        this.viewer.setCheckedElements(e);
        Object[] objectArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentNode = objectArray[n2];
            this.updateTree(currentNode, this.getCheckedElements(), true);
            ++n2;
        }
    }

    private TimelineFilterTreeNode[] getCheckedNodeElements() {
        ArrayList<TimelineFilterTreeNode> checkedElements = new ArrayList<TimelineFilterTreeNode>();
        for (TimelineFilterTreeNode cat : this.rootNode.getChildren()) {
            for (TimelineFilterTreeNode ele : cat.getChildren()) {
                if (!ele.isChecked()) continue;
                checkedElements.add(ele);
            }
        }
        return checkedElements.toArray(new TimelineFilterTreeNode[checkedElements.size()]);
    }

    private boolean isAllowedComponentName(String[] currentFilter, String name) {
        if (currentFilter == null) {
            return true;
        }
        String[] stringArray = currentFilter;
        int n = currentFilter.length;
        int n2 = 0;
        while (n2 < n) {
            String currentFilterString = stringArray[n2];
            if (name.equals(currentFilterString)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        TimelineFilterTreeNode node = (TimelineFilterTreeNode)event.getElement();
        node.setChecked(event.getChecked());
        if (this.viewer.getGrayed((Object)node)) {
            this.viewer.setGrayChecked((Object)node, false);
        }
        List<Object> checkedElements = this.getCheckedElements();
        this.updateTree(node, checkedElements, event.getChecked());
    }

    public String[] getFilteredNames() {
        ArrayList<String> checkedElements = new ArrayList<String>();
        for (TimelineFilterTreeNode cat : this.rootNode.getChildren()) {
            for (TimelineFilterTreeNode ele : cat.getChildren()) {
                if (!ele.isChecked()) continue;
                checkedElements.add(ele.getDisplayName());
            }
        }
        return checkedElements.toArray(new String[checkedElements.size()]);
    }

    private void updateTree(Object node, List<Object> checkedElements, boolean checked) {
        List<Object> descendants = this.getDescendants(node);
        HashSet<Object> checkedSet = new HashSet<Object>(checkedElements);
        for (Object n : descendants) {
            this.viewer.setGrayChecked(n, false);
            this.viewer.setChecked(n, checked);
            if (checked) {
                checkedSet.add(n);
                continue;
            }
            checkedSet.remove(n);
        }
        this.updateAncestors(node, checkedSet);
    }

    private void updateAncestors(Object child, Set<Object> checkedElements) {
        boolean isGreyed;
        Object parent = this.contentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean bl = isGreyed = this.viewer.getChecked(child) && this.viewer.getGrayed(child);
        if (isGreyed) {
            this.viewer.setGrayChecked(parent, true);
        } else {
            Object[] children = this.contentProvider.getChildren(parent);
            ArrayList<Object> cloned = new ArrayList<Object>();
            cloned.addAll(Arrays.asList(children));
            cloned.removeAll(checkedElements);
            if (cloned.isEmpty()) {
                this.viewer.setGrayed(parent, false);
                this.viewer.setChecked(parent, true);
                checkedElements.add(parent);
            } else {
                if (this.viewer.getChecked(parent) && !this.viewer.getGrayed(parent)) {
                    checkedElements.remove(parent);
                }
                this.viewer.setGrayChecked(parent, false);
                if (cloned.size() < children.length) {
                    this.viewer.setGrayChecked(parent, true);
                }
            }
        }
        this.updateAncestors(parent, checkedElements);
    }

    private List<Object> getDescendants(Object node) {
        ArrayList<Object> desc = new ArrayList<Object>();
        this.getDescendantsHelper(desc, node);
        return desc;
    }

    private void getDescendantsHelper(List<Object> descendants, Object node) {
        Object[] children = this.contentProvider.getChildren(node);
        if (children == null || children.length == 0) {
            return;
        }
        descendants.addAll(Arrays.asList(children));
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.getDescendantsHelper(descendants, child);
            ++n2;
        }
    }

    public List<Object> getCheckedElements() {
        ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(this.viewer.getCheckedElements()));
        checkedElements.removeAll(this.getGrayedElements());
        return checkedElements;
    }

    public List<Object> getGrayedElements() {
        return Arrays.asList(this.viewer.getGrayedElements());
    }

    public void modifyText(ModifyEvent arg0) {
        Text sourceText = (Text)arg0.getSource();
        this.filter.setFilterString(sourceText.getText());
        this.updateContent();
    }

    public class ComponentViewerFilter
    extends ViewerFilter {
        private String filterString = "";

        public ComponentViewerFilter(String initialText) {
            this.filterString = initialText;
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (arg2 instanceof TimelineFilterTreeNode) {
                TimelineFilterTreeNode item = (TimelineFilterTreeNode)arg2;
                if (item.getDisplayName() != null && item.getDisplayName().toLowerCase().toString().contains(this.filterString.toLowerCase())) {
                    return true;
                }
                if (item.getParent() != null && item.getParent().getDisplayName() != null && item.getParent().getDisplayName().toLowerCase().toString().contains(this.filterString.toLowerCase())) {
                    return true;
                }
                if (item.getChildren() != null && !item.getChildren().isEmpty()) {
                    for (TimelineFilterTreeNode current : item.getChildren()) {
                        if (!current.getDisplayName().toLowerCase().toString().contains(this.filterString.toLowerCase())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public void setFilterString(String filterString) {
            this.filterString = filterString;
        }
    }

    public class TreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            return ((TimelineFilterTreeNode)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((TimelineFilterTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !((TimelineFilterTreeNode)element).getChildren().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    public class TreeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof TimelineFilterTreeNode) {
                TimelineFilterTreeNode current = (TimelineFilterTreeNode)element;
                if (current.getDisplayName() == null) {
                    return "<unknown>";
                }
                return current.getDisplayName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof TimelineFilterTreeNode) {
                TimelineFilterTreeNode current = (TimelineFilterTreeNode)element;
                if (current.hasRow()) {
                    return current.getRow().getIcon();
                }
                return TimelineView.getImageIconFromId(current.getComponentID(), (Object)this);
            }
            return null;
        }
    }
}

