/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.common.endpoint.EndpointHelper;
import de.rcenvironment.core.gui.utils.incubator.TableColumnMinimalWidthControlListener;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.EndpointHandlingHelper;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EndpointSelectionPane
implements Refreshable {
    public static final int NOTHING_READ_ONLY = 1;
    public static final int NAME_AND_TYPE_READ_ONLY = 2;
    public static final int ALL_READ_ONLY = 4;
    private static final String NO_DATA_STRING = "-";
    protected EndpointType endpointType;
    protected String paneTitle;
    protected Section section;
    protected Composite client;
    protected ComponentInstanceProperties configuration;
    protected Table table;
    protected Button buttonAdd;
    protected Button buttonEdit;
    protected Button buttonRemove;
    protected MenuItem itemAdd;
    protected MenuItem itemEdit;
    protected MenuItem itemRemove;
    protected SelectionAdapter buttonListener;
    protected EndpointDescriptionsManager endpointManager;
    protected Image icon;
    protected String dynEndpointIdToManage;
    protected String dynEndpointIdToManagePassed;
    protected List<String> dynEndpointIdsToShow;
    protected List<String> statEndpointNamesToShow;
    protected boolean showEndpointCharacter;
    protected TableColumnLayout tableLayout;
    protected final WorkflowNodeCommand.Executor executor;
    private Map<String, Integer> guiKeyToColumnNumberMap;
    private boolean tableBuilt = false;
    private Map<String, String> metaDataInput = new HashMap<String, String>();
    private boolean refreshDynEndpointIdsToShow = false;
    private boolean refreshStatEndpointNamesToShow = false;
    private int readOnlyType = 0;

    public EndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, String[] dynEndpointIdsToShow, String[] statEndpointNamesToShow, WorkflowNodeCommand.Executor executor) {
        this(title, direction, dynEndpointIdToManage, dynEndpointIdsToShow, statEndpointNamesToShow, executor, false);
    }

    public EndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, String[] dynEndpointIdsToShow, String[] statEndpointNamesToShow, WorkflowNodeCommand.Executor executor, boolean readOnly) {
        this(title, direction, dynEndpointIdToManage, dynEndpointIdsToShow, statEndpointNamesToShow, executor, readOnly, false);
    }

    public EndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, String[] dynEndpointIdsToShow, String[] statEndpointNamesToShow, WorkflowNodeCommand.Executor executor, boolean readOnly, boolean showCharacter) {
        this(title, direction, dynEndpointIdToManage, dynEndpointIdsToShow, statEndpointNamesToShow, executor, EndpointSelectionPane.getButtons(readOnly), showCharacter);
    }

    public EndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, String[] dynEndpointIdsToShow, String[] statEndpointNamesToShow, WorkflowNodeCommand.Executor executor, int readOnlyType, boolean showCharacter) {
        this.paneTitle = title;
        this.endpointType = direction;
        this.dynEndpointIdToManagePassed = dynEndpointIdToManage;
        this.showEndpointCharacter = showCharacter;
        if (dynEndpointIdsToShow == null) {
            this.refreshDynEndpointIdsToShow = true;
        } else {
            this.dynEndpointIdsToShow = new ArrayList<String>(Arrays.asList(dynEndpointIdsToShow));
            if (dynEndpointIdToManage != null) {
                this.dynEndpointIdsToShow.add(dynEndpointIdToManage);
            }
        }
        if (statEndpointNamesToShow == null) {
            this.refreshStatEndpointNamesToShow = true;
        } else {
            this.statEndpointNamesToShow = Arrays.asList(statEndpointNamesToShow);
        }
        this.executor = executor;
        this.readOnlyType = readOnlyType;
        this.icon = Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.icon.16");
    }

    private static int getButtons(boolean readOnly) {
        int buttons = 4;
        if (!readOnly) {
            buttons = 1;
        }
        return buttons;
    }

    public void updateDynamicEndpointIdToManage(String newDynEndpointIdToManage) {
        this.dynEndpointIdToManage = newDynEndpointIdToManage;
        this.dynEndpointIdToManagePassed = newDynEndpointIdToManage;
    }

    protected void execute(WorkflowNodeCommand command) {
        if (this.executor == null) {
            throw new RuntimeException("No executor set for execution of workflow node commands");
        }
        if (command != null) {
            this.executor.execute(command);
        }
    }

    public Control createControl(Composite parent, String title, FormToolkit toolkit) {
        this.section = toolkit.createSection(parent, 320);
        this.section.setText(title);
        this.client = toolkit.createComposite((Composite)this.section);
        this.client.setLayout((Layout)new GridLayout(2, false));
        this.client.setSize(1, 1);
        Composite tableComposite = toolkit.createComposite(this.client);
        this.tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.tableLayout);
        this.table = toolkit.createTable(tableComposite, 68354);
        this.table.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 5);
        tableLayoutData.heightHint = 140;
        tableComposite.setLayoutData((Object)tableLayoutData);
        Listener tableListener = this.getTableListener();
        this.table.addListener(12, tableListener);
        this.table.addListener(1, tableListener);
        this.table.addListener(5, tableListener);
        this.table.addListener(32, tableListener);
        this.table.addListener(8, tableListener);
        this.addColumn(0, Messages.name);
        this.addColumn(1, Messages.dataType);
        if (this.endpointType == EndpointType.INPUT) {
            this.addColumn(2, "Handling");
            this.addColumn(3, "Constraint");
        }
        this.tableBuilt = false;
        if ((this.readOnlyType & 4) != 1) {
            this.buttonListener = this.getButtonListener();
        }
        if ((this.readOnlyType & 1) == 1) {
            this.buttonAdd = toolkit.createButton(this.client, EndpointActionType.ADD.getButtonText(), 0x800000);
            this.buttonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
            this.buttonAdd.addSelectionListener((SelectionListener)this.buttonListener);
        }
        if ((this.readOnlyType & 3) != 0) {
            this.buttonEdit = toolkit.createButton(this.client, EndpointActionType.EDIT.getButtonText(), 0x800000);
            this.buttonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
            this.buttonEdit.addSelectionListener((SelectionListener)this.buttonListener);
        }
        if ((this.readOnlyType & 1) == 1) {
            this.buttonRemove = toolkit.createButton(this.client, EndpointActionType.REMOVE.getButtonText(), 0x800000);
            this.buttonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
            this.buttonRemove.addSelectionListener((SelectionListener)this.buttonListener);
            this.table.addKeyListener((KeyListener)new DeleteKeyListener());
        }
        if ((this.readOnlyType & 4) != 1) {
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EndpointSelectionPane.this.updateButtonActivation();
                }
            });
            this.fillContextMenu(this.table);
        }
        this.section.setClient((Control)this.client);
        toolkit.paintBordersFor(this.client);
        this.section.setExpanded(true);
        return this.section;
    }

    private void fillContextMenu(Table tab) {
        Menu menu = new Menu((Control)tab);
        if (this.buttonAdd != null) {
            this.itemAdd = new MenuItem(menu, 8);
            this.itemAdd.setText(EndpointActionType.ADD.toString());
            this.itemAdd.addSelectionListener((SelectionListener)this.buttonListener);
        }
        if (this.buttonEdit != null) {
            this.itemEdit = new MenuItem(menu, 8);
            this.itemEdit.setText(EndpointActionType.EDIT.toString());
            this.itemEdit.addSelectionListener((SelectionListener)this.buttonListener);
        }
        if (this.buttonRemove != null) {
            this.itemRemove = new MenuItem(menu, 8);
            this.itemRemove.setText(EndpointActionType.REMOVE.toString());
            this.itemRemove.addSelectionListener((SelectionListener)this.buttonListener);
        }
        tab.setMenu(menu);
    }

    protected SelectionAdapter getButtonListener() {
        return new ButtonSelectionAdapter();
    }

    public void setConfiguration(ComponentInstanceProperties compInstProps) {
        this.configuration = compInstProps;
        this.endpointManager = this.endpointType == EndpointType.INPUT ? compInstProps.getInputDescriptionsManager() : compInstProps.getOutputDescriptionsManager();
        if (this.refreshDynEndpointIdsToShow) {
            this.dynEndpointIdsToShow = EndpointHelper.getAllDynamicEndpointIds((EndpointType)this.endpointType, (ComponentInstanceProperties)compInstProps);
        }
        if (this.refreshStatEndpointNamesToShow) {
            this.statEndpointNamesToShow = EndpointHelper.getAllStaticEndpointNames((EndpointType)this.endpointType, (ComponentInstanceProperties)compInstProps);
        }
        this.dynEndpointIdToManage = EndpointHelper.getAllDynamicEndpointIds((EndpointType)this.endpointType, (ComponentInstanceProperties)compInstProps).isEmpty() ? null : this.dynEndpointIdToManagePassed;
        this.updateTable();
    }

    protected ComponentInstanceProperties getConfiguration() {
        return this.configuration;
    }

    private Listener getTableListener() {
        return event -> {
            switch (event.type) {
                case 1: 
                case 5: 
                case 12: {
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    if (this.buttonEdit == null || !this.buttonEdit.isEnabled() || event.button != 1) break;
                    this.onEditClicked();
                    break;
                }
            }
        };
    }

    protected void fillTable() {
        if (this.client.getSize().x != 0) {
            this.table.removeAll();
            this.guiKeyToColumnNumberMap = new HashMap<String, Integer>();
            List shownMetaData = EndpointHelper.getMetaDataNamesForTable((EndpointType)this.endpointType, this.dynEndpointIdsToShow, this.statEndpointNamesToShow, (ComponentInstanceProperties)this.getConfiguration());
            int i = 2;
            if (this.endpointType == EndpointType.INPUT) {
                i = 4;
            }
            for (String key : shownMetaData) {
                this.guiKeyToColumnNumberMap.put(key, i++);
            }
            if (!this.tableBuilt) {
                for (String key : shownMetaData) {
                    this.addColumn(this.guiKeyToColumnNumberMap.get(key), key);
                }
                if (this.showEndpointCharacter) {
                    this.addColumn(i, "Loop level");
                }
            }
            List<String> dynEndpointNames = this.getDynamicEndpointNames(this.dynEndpointIdsToShow);
            Collections.sort(dynEndpointNames);
            this.fillCells(dynEndpointNames, false);
            this.fillCells(this.statEndpointNamesToShow, true);
        }
        int col = 0;
        while (col < this.table.getColumnCount()) {
            this.tableLayout.setColumnData((Widget)this.table.getColumn(col), (ColumnLayoutData)new ColumnWeightData(20, true));
            ++col;
        }
    }

    private void addColumn(int index, String title) {
        this.tableBuilt = true;
        TableColumn col = null;
        try {
            col = new TableColumn(this.table, 0, index);
            col.addControlListener((ControlListener)new TableColumnMinimalWidthControlListener());
            this.decorateColumn(title, col);
        }
        catch (AssertionFailedException e) {
            if (e.getMessage().contains("assertion failed: Unknown column layout data")) {
                this.decorateColumn(title, this.table.getColumn(index));
            }
            throw e;
        }
    }

    private void decorateColumn(String key, TableColumn col) {
        this.tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(20, true));
        col.setText(key);
    }

    private List<String> getDynamicEndpointNames(List<String> endpointIds) {
        LinkedList<String> result = new LinkedList<String>();
        for (EndpointDescription e : this.endpointManager.getDynamicEndpointDescriptions()) {
            if (!endpointIds.contains(e.getEndpointDefinition().getIdentifier())) continue;
            result.add(e.getName());
        }
        return result;
    }

    private void fillCells(List<String> endpointNames, boolean staticEndpoints) {
        for (String name : endpointNames) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)name);
            item.setText(0, name);
            Display display = Display.getCurrent();
            if (this.readOnlyType != 1 || this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isReadOnly()) {
                item.setForeground(display.getSystemColor(16));
            }
            if (this.endpointType == EndpointType.INPUT) {
                item.setImage(0, Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.gui.workflow.editor.input"));
            } else {
                item.setImage(0, Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.gui.workflow.editor.output"));
            }
            if (staticEndpoints) {
                item.setForeground(0, display.getSystemColor(16));
            } else if (this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isNameReadOnly()) {
                item.setForeground(0, display.getSystemColor(16));
            }
            item.setText(1, this.endpointManager.getEndpointDescription(name).getDataType().getDisplayName());
            if (this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getPossibleDataTypes().size() < 2) {
                item.setForeground(1, display.getSystemColor(16));
            }
            int lastIndex = 1;
            if (this.endpointType == EndpointType.INPUT) {
                if (this.getMetaData(name).containsKey("inputHandling_73b1056e")) {
                    item.setText(2, EndpointDefinition.InputDatumHandling.valueOf((String)this.getMetaData(name).get("inputHandling_73b1056e")).getDisplayName());
                } else {
                    item.setText(2, this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getDefaultInputDatumHandling().getDisplayName());
                }
                if (this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getInputDatumOptions().size() < 2) {
                    item.setForeground(2, display.getSystemColor(16));
                } else {
                    item.setForeground(2, display.getSystemColor(2));
                }
                if (this.getMetaData(name).containsKey("inputExecutionConstraint_4aae3eea")) {
                    item.setText(3, EndpointDefinition.InputExecutionContraint.valueOf((String)this.getMetaData(name).get("inputExecutionConstraint_4aae3eea")).getDisplayName());
                } else {
                    item.setText(3, this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getDefaultInputExecutionConstraint().getDisplayName());
                }
                if (this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getInputExecutionConstraintOptions().size() < 2) {
                    item.setForeground(3, display.getSystemColor(16));
                } else {
                    item.setForeground(3, display.getSystemColor(2));
                }
                lastIndex = 3;
            }
            Set metaDataKeys = this.getMetaDataDescription(name).getMetaDataKeys();
            for (String key : metaDataKeys) {
                if (this.getMetaDataDescription(name).getVisibility(key) != EndpointMetaDataConstants.Visibility.shown || !EndpointHelper.checkMetadataFilter((Map)this.getMetaDataDescription(name).getGuiVisibilityFilter(key), this.getMetaData(name), (ConfigurationDescription)this.configuration.getConfigurationDescription())) continue;
                lastIndex = Math.max(lastIndex, this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)));
                if (this.getMetaData(name).get(key) != null && !this.getMetaData(name).get(key).isEmpty() && !this.getMetaData(name).get(key).matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
                    if (EndpointHelper.checkMetadataFilter((Map)this.getMetaDataDescription(name).getGuiActivationFilter(key), this.getMetaData(name), (ConfigurationDescription)this.configuration.getConfigurationDescription()) && this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)) != null) {
                        item.setText(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), this.getMetaDataWithGuiNames(name).get(key));
                        if (this.isValueEditable(name, key)) continue;
                        item.setForeground(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), display.getSystemColor(16));
                        continue;
                    }
                    item.setText(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), NO_DATA_STRING);
                    item.setForeground(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), display.getSystemColor(16));
                    continue;
                }
                if (this.getMetaData(name).get(key).isEmpty() || this.getMetaData(name).get(key).matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
                    item.setText(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), NO_DATA_STRING);
                    item.setForeground(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), display.getSystemColor(16));
                    continue;
                }
                if (this.getMetaDataDescription(name) == null || this.getMetaDataDescription(name).getDefaultValue(key) == null) continue;
                item.setText(this.guiKeyToColumnNumberMap.get(this.getMetaDataDescription(name).getGuiName(key)).intValue(), this.getMetaDataDescription(name).getDefaultValue(key));
            }
            for (String key : this.guiKeyToColumnNumberMap.keySet()) {
                if (item.getText(this.guiKeyToColumnNumberMap.get(key).intValue()) != null && !item.getText(this.guiKeyToColumnNumberMap.get(key).intValue()).isEmpty()) continue;
                lastIndex = Math.max(lastIndex, this.guiKeyToColumnNumberMap.get(key));
                item.setText(this.guiKeyToColumnNumberMap.get(key).intValue(), NO_DATA_STRING);
                item.setForeground(this.guiKeyToColumnNumberMap.get(key).intValue(), display.getSystemColor(16));
            }
            item.setText(++lastIndex, this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getEndpointCharacter().getDisplayName(this.endpointType));
            item.setForeground(lastIndex, display.getSystemColor(16));
        }
    }

    private boolean isValueEditable(String name, String key) {
        return this.getMetaDataDescription(name).getPossibleValues(key) == null || this.getMetaDataDescription(name).getPossibleValues(key).size() >= 2 || this.getMetaDataDescription(name).getPossibleValues(key).contains("*");
    }

    protected void updateButtonActivation() {
        TableItem[] selection = this.table.getSelection();
        boolean hasSelection = selection.length != 0;
        boolean addible = this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage) != null;
        boolean editable = false;
        boolean removable = false;
        if (hasSelection) {
            boolean containsStaticOrReadOnly = this.selectionContainsStaticOrReadOnly(Arrays.asList(selection));
            editable = selection.length == 1 && !containsStaticOrReadOnly;
            boolean bl = removable = !containsStaticOrReadOnly;
            if (selection.length == 1) {
                EndpointDefinition definition = this.endpointManager.getEndpointDescription(selection[0].getText()).getEndpointDefinition();
                editable = definition.getPossibleDataTypes().size() > 1 && this.readOnlyType == 1 || definition.getInputDatumOptions().size() > 1 || definition.getInputExecutionConstraintOptions().size() > 1;
                EndpointMetaDataDefinition metaDescription = definition.getMetaDataDefinition();
                if (metaDescription != null && !metaDescription.getMetaDataKeys().isEmpty()) {
                    for (String key : metaDescription.getMetaDataKeys()) {
                        editable |= this.isValueEditable(selection[0].getText(), key);
                    }
                }
            }
        }
        if (this.buttonAdd != null) {
            this.buttonAdd.setEnabled(addible);
            this.itemAdd.setEnabled(addible);
        }
        if (this.buttonEdit != null) {
            this.buttonEdit.setEnabled(editable);
            this.itemEdit.setEnabled(editable);
        }
        if (this.buttonRemove != null) {
            this.buttonRemove.setEnabled(removable);
            this.itemRemove.setEnabled(removable);
        }
    }

    private boolean selectionContainsStaticOrReadOnly(List<TableItem> tableItems) {
        for (TableItem item : tableItems) {
            if (!this.endpointManager.getEndpointDescription(item.getText()).getEndpointDefinition().isReadOnly() && !this.endpointManager.getEndpointDescription(item.getText()).getEndpointDefinition().isStatic()) continue;
            return true;
        }
        return false;
    }

    public Control getControl() {
        return this.section;
    }

    protected void updateTable() {
        if (!this.getControl().isDisposed()) {
            this.fillTable();
            if (this.readOnlyType == 1 || this.readOnlyType == 2) {
                this.updateButtonActivation();
            }
        }
    }

    protected DataType getType(String name) {
        return this.endpointManager.getEndpointDescription(name).getDataType();
    }

    protected Map<String, String> getMetaData(String name) {
        return this.endpointManager.getEndpointDescription(name).getMetaData();
    }

    protected Map<String, String> getMetaDataWithGuiNames(String name) {
        Map metaData = this.endpointManager.getEndpointDescription(name).getMetaData();
        HashMap<String, String> metaDataWithGuiNames = new HashMap<String, String>();
        String dynId = this.endpointManager.getEndpointDescription(name).getDynamicEndpointIdentifier();
        EndpointDefinition endpointDefinition = dynId != null ? this.endpointManager.getDynamicEndpointDefinition(dynId) : this.endpointManager.getStaticEndpointDefinition(name);
        if (endpointDefinition == null) {
            return metaData;
        }
        for (String key : endpointDefinition.getMetaDataDefinition().getMetaDataKeys()) {
            List possibleValues = endpointDefinition.getMetaDataDefinition().getPossibleValues(key);
            if (possibleValues != null && !possibleValues.isEmpty()) {
                List guiNamesOfPossibleValues = endpointDefinition.getMetaDataDefinition().getGuiNamesOfPossibleValues(key);
                if (possibleValues.indexOf(metaData.get(key)) >= 0) {
                    metaDataWithGuiNames.put(key, (String)guiNamesOfPossibleValues.get(possibleValues.indexOf(metaData.get(key))));
                    continue;
                }
                metaDataWithGuiNames.put(key, (String)metaData.get(key));
                continue;
            }
            metaDataWithGuiNames.put(key, (String)metaData.get(key));
        }
        return metaDataWithGuiNames;
    }

    protected EndpointMetaDataDefinition getMetaDataDescription(String name) {
        return this.endpointManager.getEndpointDescription(name).getEndpointDefinition().getMetaDataDefinition();
    }

    protected void onAddClicked(EndpointEditDialog dialog) {
        if (dialog.open() == 0) {
            String name = dialog.getChosenName();
            DataType type = dialog.getChosenDataType();
            Map<String, String> metaData = dialog.getMetadataValues();
            metaData.putAll(this.metaDataInput);
            this.executeAddCommand(name, type, metaData);
        }
    }

    protected void onAddClicked() {
        EndpointEditDialog dialog = new EndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>());
        this.onAddClicked(dialog);
    }

    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        AddDynamicEndpointCommand command = new AddDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, name, type, metaData, this);
        this.execute(command);
    }

    protected void onEditClicked(String name, EndpointEditDialog dialog) {
        Map<String, String> newMetaData;
        DataType newType;
        String newName;
        EndpointDescription oldDesc;
        dialog.initializeValues(name);
        if (dialog.open() == 0 && this.isEndpointChanged(oldDesc = this.endpointManager.getEndpointDescription(name), newName = dialog.getChosenName(), newType = dialog.getChosenDataType(), newMetaData = dialog.getMetadataValues()) && EndpointHandlingHelper.editEndpointDataType(this.endpointType, oldDesc, newType)) {
            this.editEndpoint(oldDesc, newName, newType, newMetaData);
        }
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map<String, String> newMetaData = this.cloneMetaData(endpoint.getMetaData());
        EndpointEditDialog dialog = new EndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.endpointManager.getEndpointDescription(name).getDynamicEndpointIdentifier(), isStaticEndpoint, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData, this.readOnlyType);
        this.onEditClicked(name, dialog);
    }

    protected void editEndpoint(EndpointDescription oldDesc, String newName, DataType newType, Map<String, String> newMetaData) {
        EndpointDescription newDesc = this.endpointManager.getEndpointDescription(oldDesc.getName());
        if (!newName.equals(oldDesc.getName())) {
            newDesc.setName(newName);
        }
        newDesc.setDataType(newType);
        newDesc.setMetaData(newMetaData);
        this.executeEditCommand(oldDesc, newDesc);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        EditDynamicEndpointCommand command = new EditDynamicEndpointCommand(this.endpointType, oldDescription, newDescription, this);
        this.execute(command);
    }

    protected void onRemovedClicked() {
        TableItem[] selection = this.table.getSelection();
        LinkedList<String> names = new LinkedList<String>();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem element = tableItemArray[n2];
            names.add((String)element.getData());
            ++n2;
        }
        this.executeRemoveCommand(names);
    }

    protected void executeRemoveCommand(List<String> names) {
        RemoveDynamicEndpointCommand command = new RemoveDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, names, this);
        this.execute(command);
    }

    protected boolean isEndpointChanged(EndpointDescription oldDesc, String newName, DataType newType, Map<String, String> newMetaData) {
        if (oldDesc.getName().equals(newName) && oldDesc.getDataType().equals((Object)newType)) {
            for (String key : newMetaData.keySet()) {
                if (oldDesc.getMetaData().containsKey(key) && oldDesc.getMetaDataValue(key).equals(newMetaData.get(key))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected Map<String, String> cloneMetaData(Map<String, String> original) {
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map.Entry<String, String> e : original.entrySet()) {
            copy.put(e.getKey(), e.getValue());
        }
        return copy;
    }

    public void setMetaDataInput(Map<String, String> metaDataInput) {
        this.metaDataInput = metaDataInput;
    }

    @Override
    public void refresh() {
        this.updateTable();
    }

    public void setEndpointIdToManage(String endpointIdToManage) {
        this.dynEndpointIdToManage = endpointIdToManage;
    }

    public void setTableBuilt(boolean tableBuilt) {
        this.tableBuilt = tableBuilt;
    }

    private class ButtonSelectionAdapter
    extends SelectionAdapter {
        private ButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == EndpointSelectionPane.this.buttonAdd || e.widget == EndpointSelectionPane.this.itemAdd) {
                EndpointSelectionPane.this.onAddClicked();
            } else if (e.widget == EndpointSelectionPane.this.buttonEdit || e.widget == EndpointSelectionPane.this.itemEdit) {
                EndpointSelectionPane.this.onEditClicked();
            } else if (e.widget == EndpointSelectionPane.this.buttonRemove || e.widget == EndpointSelectionPane.this.itemRemove) {
                EndpointSelectionPane.this.onRemovedClicked();
            }
        }
    }

    private class DeleteKeyListener
    implements KeyListener {
        private DeleteKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 127 && EndpointSelectionPane.this.buttonRemove.isEnabled()) {
                EndpointSelectionPane.this.onRemovedClicked();
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }
}

