/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationMetaDataDefinition;
import de.rcenvironment.core.component.model.configuration.api.ReadOnlyConfiguration;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.integration.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertiesSection
extends ValidatingWorkflowNodePropertySection {
    private static final int COLUMN_WEIGHT = 8;
    private static final int COLUMN_WEIGHT_PLACEHOLDER = 6;
    private static final int COLUMN_WEIGHT_COMMENT = 20;
    private static final int LIST_WIDTH = 150;
    private static final int MIN_TABLE_WIDTH = 400;
    private List propGroupList;
    private Table propertyTable;
    private int groupSelection;
    private Map<String, String> previousValues;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        Section propertiesSection = this.getWidgetFactory().createSection(composite, 256);
        propertiesSection.setText(Messages.propertyConfiguration);
        propertiesSection.setLayoutData((Object)new GridData(1808));
        Composite propertiesComposite = this.getWidgetFactory().createFlatFormComposite((Composite)propertiesSection);
        propertiesComposite.setLayout((Layout)new GridLayout(2, false));
        propertiesComposite.setLayoutData((Object)new GridData(1808));
        new Label(propertiesComposite, 0).setText(Messages.propGroupsLabel);
        new Label(propertiesComposite, 0).setText(Messages.properties);
        this.propGroupList = new List(propertiesComposite, 2564);
        GridData groupsListGridData = new GridData(1040);
        groupsListGridData.widthHint = 150;
        this.propGroupList.setLayoutData((Object)groupsListGridData);
        this.propGroupList.addSelectionListener((SelectionListener)new PropertyGroupTableListener(this.propGroupList));
        Composite tableComposite = new Composite(propertiesComposite, 0);
        GridData tableGridData = new GridData(1808);
        tableGridData.minimumWidth = 400;
        tableGridData.grabExcessHorizontalSpace = true;
        tableComposite.setLayoutData((Object)tableGridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this.propertyTable = new Table(tableComposite, 34816);
        this.propertyTable.setHeaderVisible(true);
        this.propertyTable.setLayoutData((Object)new GridData(1808));
        this.propertyTable.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(this.propertyTable, 0);
        nameColumn.setText(Messages.name);
        TableColumn valueColumn = new TableColumn(this.propertyTable, 0);
        valueColumn.setText(Messages.value);
        valueColumn.setAlignment(0x1000000);
        TableColumn placeholderColumn = new TableColumn(this.propertyTable, 0);
        placeholderColumn.setText("Define at workflow start");
        placeholderColumn.setAlignment(0x1000000);
        TableColumn commentColumn = new TableColumn(this.propertyTable, 0);
        commentColumn.setText("Comment");
        tableLayout.setColumnData((Widget)this.propertyTable.getColumn(0), (ColumnLayoutData)new ColumnWeightData(8));
        tableLayout.setColumnData((Widget)this.propertyTable.getColumn(1), (ColumnLayoutData)new ColumnWeightData(8));
        tableLayout.setColumnData((Widget)this.propertyTable.getColumn(2), (ColumnLayoutData)new ColumnWeightData(6));
        tableLayout.setColumnData((Widget)this.propertyTable.getColumn(3), (ColumnLayoutData)new ColumnWeightData(20));
        TableItem nullItem = new TableItem(this.propertyTable, 0);
        nullItem.setText("");
        TableEditor editor = new TableEditor(this.propertyTable);
        Text nullText = new Text((Composite)this.propertyTable, 0);
        editor.setEditor((Control)nullText, nullItem, 1);
        propertiesSection.setClient((Control)propertiesComposite);
    }

    private void updateSelection() {
        Control[] controlArray = this.propertyTable.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.propertyTable.removeAll();
        if (this.propGroupList.getItemCount() > this.groupSelection) {
            String group = this.propGroupList.getItem(this.groupSelection);
            Map config = this.getConfiguration().getConfigurationDescription().getConfiguration();
            ConfigurationMetaDataDefinition metadata = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getConfigurationMetaDataDefinition();
            LinkedList<String> groupKeys = new LinkedList<String>();
            for (String configKey : config.keySet()) {
                if (!metadata.getGuiGroupName(configKey).equals(group)) continue;
                groupKeys.add(configKey);
            }
            Collections.sort(groupKeys);
            this.previousValues = new HashMap<String, String>();
            for (String groupKey : groupKeys) {
                this.addSinglePropertyLine(config, groupKey, metadata.getMetaDataValue(groupKey, "comment"), metadata.getGuiName(groupKey));
            }
        }
    }

    protected void addSinglePropertyLine(Map<String, String> config, String defaultValuePropertyKey, String commentString, String displayName) {
        TableItem configItem = new TableItem(this.propertyTable, 1);
        configItem.setText(0, displayName);
        if (commentString != null) {
            configItem.setText(3, commentString);
        }
        TableEditor editor = new TableEditor(this.propertyTable);
        Text textField = new Text((Composite)this.propertyTable, 0);
        textField.setData("property.control", (Object)defaultValuePropertyKey);
        Button checkBox = new Button((Composite)this.propertyTable, 0x1000020);
        checkBox.setData("property.control", (Object)defaultValuePropertyKey);
        textField.setText(config.get(defaultValuePropertyKey));
        if (!config.get(defaultValuePropertyKey).matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
            textField.setEnabled(true);
            checkBox.setSelection(false);
            this.previousValues.put(defaultValuePropertyKey, config.get(defaultValuePropertyKey));
        } else {
            textField.setEnabled(false);
            checkBox.setSelection(true);
            this.previousValues.put(defaultValuePropertyKey, config.get(defaultValuePropertyKey));
        }
        textField.addFocusListener((FocusListener)new PropertyTableFocusListener(defaultValuePropertyKey));
        editor.grabHorizontal = true;
        editor.setEditor((Control)textField, configItem, 1);
        TableEditor boxEditor = new TableEditor(this.propertyTable);
        checkBox.pack();
        boxEditor.minimumWidth = checkBox.getSize().x;
        boxEditor.horizontalAlignment = 0x1000000;
        checkBox.addSelectionListener((SelectionListener)new PropertyTableCheckboxSelectionListener(defaultValuePropertyKey, checkBox));
        boxEditor.horizontalAlignment = 0x1000000;
        boxEditor.setEditor((Control)checkBox, configItem, 2);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.propGroupList.removeAll();
        ConfigurationDefinition config = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition();
        TreeSet<String> groupNames = new TreeSet<String>();
        for (String key : config.getConfigurationKeys()) {
            String group;
            if (key.equals("storeComponentHistoryData") || groupNames.contains(group = config.getConfigurationMetaDataDefinition().getGuiGroupName(key))) continue;
            groupNames.add(group);
        }
        for (String group : groupNames) {
            this.propGroupList.add(group);
        }
        if (this.propGroupList.getItemCount() > 0) {
            this.propGroupList.select(0);
            this.groupSelection = 0;
        } else {
            TableItem nullItem = new TableItem(this.propertyTable, 0);
            nullItem.setText("");
            TableEditor editor = new TableEditor(this.propertyTable);
            Text nullText = new Text((Composite)this.propertyTable, 0);
            editor.grabHorizontal = true;
            editor.setEditor((Control)nullText, nullItem, 1);
        }
        this.updateSelection();
        ReadOnlyConfiguration readOnlyconfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        String chosen = this.getProperty("chosenDeleteTempDirBehavior");
        if (chosen == null) {
            boolean deleteOnceActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterWorkflowExecution"));
            boolean deleteAlwaysActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterIteration"));
            if (deleteOnceActive) {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterWorkflowExecution");
            } else if (deleteAlwaysActive) {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterIteration");
            } else {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesNever");
            }
        }
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }

    protected PropertiesSectionUpdater createUpdater() {
        return new PropertiesSectionUpdater();
    }

    protected class PropertiesSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected PropertiesSectionUpdater() {
            super((WorkflowNodePropertySection)PropertiesSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            PropertiesSection.this.propertyTable.setRedraw(false);
            if (control instanceof Button) {
                Control[] controlArray = control.getParent().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof Text && c.getData("property.control").equals(control.getData("property.control"))) {
                        if (newValue == null || newValue.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
                            ((Text)c).setEnabled(false);
                            ((Button)control).setSelection(true);
                        } else {
                            ((Text)c).setEnabled(true);
                            ((Button)control).setSelection(false);
                        }
                    }
                    ++n2;
                }
            }
            if (control instanceof Text) {
                if (newValue == null) {
                    ((Text)control).setText("${placeholder." + propertyName + "}");
                } else {
                    ((Text)control).setText(newValue);
                }
            }
            PropertiesSection.this.propertyTable.setRedraw(true);
        }
    }

    private final class PropertyGroupTableListener
    implements SelectionListener {
        private final List tabsList;

        private PropertyGroupTableListener(List tabsList) {
            this.tabsList = tabsList;
        }

        public void widgetSelected(SelectionEvent event) {
            int[] selectedItems = this.tabsList.getSelectionIndices();
            if (selectedItems.length == 1) {
                PropertiesSection.this.groupSelection = selectedItems[0];
            }
            PropertiesSection.this.updateSelection();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class PropertyTableCheckboxSelectionListener
    implements SelectionListener {
        private final String defaultValuePropertyKey;
        private final Button checkBox;

        private PropertyTableCheckboxSelectionListener(String defaultValuePropertyKey, Button checkBox) {
            this.defaultValuePropertyKey = defaultValuePropertyKey;
            this.checkBox = checkBox;
        }

        public void widgetSelected(SelectionEvent evt) {
            if (this.checkBox.getSelection()) {
                this.onCheckboxChecked(this.defaultValuePropertyKey);
            } else {
                this.onCheckboxUnchecked(this.defaultValuePropertyKey);
            }
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        protected void onCheckboxChecked(String groupKey) {
            PropertiesSection.this.setProperty(groupKey, "${property." + groupKey + "}");
        }

        protected void onCheckboxUnchecked(String groupKey) {
            if (((String)PropertiesSection.this.previousValues.get(groupKey)).matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
                PropertiesSection.this.setProperty(groupKey, "");
            } else {
                PropertiesSection.this.setProperty(groupKey, (String)PropertiesSection.this.previousValues.get(groupKey));
            }
        }
    }

    private final class PropertyTableFocusListener
    implements FocusListener {
        private final String defaultValuePropertyKey;

        private PropertyTableFocusListener(String defaultValuePropertyKey) {
            this.defaultValuePropertyKey = defaultValuePropertyKey;
        }

        public void focusLost(FocusEvent arg0) {
            this.getPreviousValues().put(this.defaultValuePropertyKey, ((Text)arg0.getSource()).getText());
            PropertiesSection.this.setProperty(this.defaultValuePropertyKey, ((Text)arg0.getSource()).getText());
        }

        public void focusGained(FocusEvent arg0) {
        }

        private Map<String, String> getPreviousValues() {
            return PropertiesSection.this.previousValues;
        }
    }
}

