/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette;

import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.DistributedComponentEntryType;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collection;
import java.util.stream.Collectors;

class DistributedComponentKnowledgeSanitizer {
    DistributedComponentKnowledgeSanitizer() {
    }

    public Collection<DistributedComponentEntry> sanitizeComponentKnowledge(DistributedComponentKnowledge newState) {
        return newState.getAllInstallations().stream().filter(this::isValid).collect(Collectors.toSet());
    }

    private boolean isValid(DistributedComponentEntry entry) {
        if (entry.getDisplayName() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received %s with unexpected display name: null.", (Object[])new Object[]{entry.getClass().getCanonicalName()}));
        }
        if (entry.getComponentInstallation().getInstallationId() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received tool \"%s\" with unexpected installation id: null.", (Object[])new Object[]{entry.getDisplayName()}));
        }
        if (entry.getType() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received tool \"%s\" with unexpected %s: null.", (Object[])new Object[]{entry.getDisplayName(), DistributedComponentEntryType.class.getCanonicalName()}));
        }
        if (entry.getComponentInstallation().getComponentInterface() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received tool \"%s\" with unexpected %s: null.", (Object[])new Object[]{entry.getDisplayName(), ComponentInterface.class.getCanonicalName()}));
        }
        ComponentInterface componentInterface = entry.getComponentInstallation().getComponentInterface();
        if (componentInterface.getVersion() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received %s with unexpected version: null.", (Object[])new Object[]{ComponentInterface.class.getCanonicalName()}));
        }
        if (componentInterface.getIcon16() == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Received %s with unexpected icon: null.", (Object[])new Object[]{ComponentInterface.class.getCanonicalName()}));
        }
        return true;
    }
}

