/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.log.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.gui.log.LogListener;
import de.rcenvironment.core.gui.log.internal.Messages;
import de.rcenvironment.core.log.DistributedLogReaderService;
import de.rcenvironment.core.log.SerializableLogEntry;
import de.rcenvironment.core.log.SerializableLogListener;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class LogModel {
    private static final int LOG_POOL_SIZE = 7000;
    private static LogModel instance;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private Set<InstanceNodeSessionId> currentWorkflowHostsAndSelf;
    private InstanceNodeSessionId selectedLogSource;
    private Map<InstanceNodeSessionId, Map<Integer, SortedSet<SerializableLogEntry>>> allLogEntries;
    private final WorkflowHostService workflowHostService;
    private final PlatformService platformService;
    private final DistributedLogReaderService logReaderService;

    private LogModel() {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        this.workflowHostService = (WorkflowHostService)registryAccess.getService(WorkflowHostService.class);
        this.platformService = (PlatformService)registryAccess.getService(PlatformService.class);
        this.logReaderService = (DistributedLogReaderService)registryAccess.getService(DistributedLogReaderService.class);
        this.allLogEntries = new ConcurrentHashMap<InstanceNodeSessionId, Map<Integer, SortedSet<SerializableLogEntry>>>();
        this.currentWorkflowHostsAndSelf = this.workflowHostService.getWorkflowHostNodesAndSelf();
    }

    public static synchronized LogModel getInstance() {
        if (instance == null) {
            instance = new LogModel();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<SerializableLogEntry> getLogEntries() {
        TreeSet<SerializableLogEntry> entries = new TreeSet<SerializableLogEntry>();
        Map<InstanceNodeSessionId, Map<Integer, SortedSet<SerializableLogEntry>>> map = this.allLogEntries;
        synchronized (map) {
            if (this.selectedLogSource != null && !this.allLogEntries.containsKey(this.selectedLogSource)) {
                this.allLogEntries.put(this.selectedLogSource, new HashMap());
                this.subscribeForNewLogEntriesAndRetrieveOldOnes(this.selectedLogSource);
            } else {
                for (Integer level : this.allLogEntries.get(this.selectedLogSource).keySet()) {
                    SortedSet<SerializableLogEntry> levelEntries;
                    if (level == 4) continue;
                    Map<Integer, SortedSet<SerializableLogEntry>> platformEntries = this.allLogEntries.get(this.selectedLogSource);
                    SortedSet<SerializableLogEntry> sortedSet = levelEntries = platformEntries.get(level);
                    synchronized (sortedSet) {
                        entries.addAll(levelEntries);
                    }
                }
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEntry(SerializableLogEntry logEntry) {
        InstanceNodeSessionId nodeId = logEntry.getPlatformIdentifer();
        Map<InstanceNodeSessionId, Map<Integer, SortedSet<SerializableLogEntry>>> map = this.allLogEntries;
        synchronized (map) {
            if (this.allLogEntries.get(nodeId) == null) {
                return;
            }
            if (!this.allLogEntries.get(nodeId).containsKey(logEntry.getLevel())) {
                this.allLogEntries.get(nodeId).put(logEntry.getLevel(), Collections.synchronizedSortedSet(new TreeSet()));
            }
            SortedSet<SerializableLogEntry> logEntries = this.allLogEntries.get(nodeId).get(logEntry.getLevel());
            while (logEntries.size() >= 7000) {
                SerializableLogEntry logEntryToRemove = logEntries.first();
                logEntries.remove(logEntryToRemove);
                for (Listener listener : this.listeners) {
                    listener.handleLogEntryRemoved(logEntryToRemove);
                }
            }
            if (logEntries.add(logEntry)) {
                for (Listener listener : this.listeners) {
                    listener.handleLogEntryAdded(logEntry);
                }
            }
        }
    }

    public synchronized void setSelectedLogSource(InstanceNodeSessionId nodeId) {
        this.selectedLogSource = nodeId;
    }

    public synchronized InstanceNodeSessionId getCurrentLogSource() {
        return this.selectedLogSource;
    }

    public synchronized List<InstanceNodeSessionId> updateListOfLogSources() {
        Set newWorkflowHostNodesAndSelf = this.workflowHostService.getWorkflowHostNodesAndSelf();
        HashSet<InstanceNodeSessionId> nodeIdsRemoved = new HashSet<InstanceNodeSessionId>(this.currentWorkflowHostsAndSelf);
        nodeIdsRemoved.removeAll(newWorkflowHostNodesAndSelf);
        for (InstanceNodeSessionId nodeIdRemoved : nodeIdsRemoved) {
            this.allLogEntries.remove(nodeIdRemoved);
        }
        this.currentWorkflowHostsAndSelf = newWorkflowHostNodesAndSelf;
        ArrayList<InstanceNodeSessionId> logSources = new ArrayList<InstanceNodeSessionId>();
        InstanceNodeSessionId localNodeId = null;
        for (InstanceNodeSessionId nodeId : this.currentWorkflowHostsAndSelf) {
            if (this.platformService.matchesLocalInstance((ResolvableNodeId)nodeId)) {
                localNodeId = nodeId;
                continue;
            }
            logSources.add(nodeId);
        }
        Collections.sort(logSources, new Comparator<InstanceNodeSessionId>(){

            @Override
            public int compare(InstanceNodeSessionId o1, InstanceNodeSessionId o2) {
                return o1.getAssociatedDisplayName().compareTo(o2.getAssociatedDisplayName());
            }
        });
        if (localNodeId != null) {
            logSources.add(0, localNodeId);
        }
        return logSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<InstanceNodeSessionId, Map<Integer, SortedSet<SerializableLogEntry>>> map = this.allLogEntries;
        synchronized (map) {
            if (this.selectedLogSource == null) {
                for (InstanceNodeSessionId pi : this.allLogEntries.keySet()) {
                    this.allLogEntries.get(pi).clear();
                }
            } else {
                this.allLogEntries.get(this.selectedLogSource).clear();
            }
        }
    }

    private synchronized void subscribeForNewLogEntriesAndRetrieveOldOnes(final InstanceNodeSessionId node) {
        Job job = new Job("Fetching log"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.fetchingLogs, 7);
                    monitor.worked(1);
                    LogListener logListener = new LogListener(LogModel.this.selectedLogSource);
                    LogModel.this.logReaderService.addLogListener((SerializableLogListener)logListener, LogModel.this.selectedLogSource);
                    monitor.worked(1);
                    List retrievedLogEntries = LogModel.this.logReaderService.getLog(node);
                    monitor.worked(2);
                    ConcurrentHashMap logEntries = new ConcurrentHashMap();
                    for (SerializableLogEntry retrievedLogEntry : retrievedLogEntries) {
                        if (!logEntries.containsKey(retrievedLogEntry.getLevel())) {
                            logEntries.put(retrievedLogEntry.getLevel(), Collections.synchronizedSortedSet(new TreeSet()));
                        }
                        retrievedLogEntry.setPlatformIdentifer(node);
                        ((SortedSet)logEntries.get(retrievedLogEntry.getLevel())).add(retrievedLogEntry);
                    }
                    monitor.worked(1);
                    monitor.worked(1);
                    for (Set entries : logEntries.values()) {
                        for (SerializableLogEntry entry : entries) {
                            LogModel.this.addLogEntry(entry);
                        }
                    }
                    monitor.worked(1);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static interface Listener {
        public void handleLogEntryAdded(SerializableLogEntry var1);

        public void handleLogEntryRemoved(SerializableLogEntry var1);
    }
}

