/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.internal.ScpCommandWrapper;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshCommandHandler;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.embedded.ssh.internal.SshUplinkCommandHandler;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.shell.ShellFactory;

public class CustomSshCommandFactory
implements CommandFactory,
ShellFactory {
    private CommandExecutionService commandExecutionService;
    private SshAuthenticationManager authenticationManager;
    private ScpContextManager scpContextManager;
    private ServerSideUplinkSessionService uplinkSessionService;
    private SshConfiguration sshConfiguration;

    public CustomSshCommandFactory(SshAuthenticationManager authenticationManager, ScpContextManager scpContextManager, CommandExecutionService commandExecutionService, ServerSideUplinkSessionService uplinkSessionService, SshConfiguration sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
        this.authenticationManager = authenticationManager;
        this.scpContextManager = scpContextManager;
        this.uplinkSessionService = uplinkSessionService;
        this.commandExecutionService = commandExecutionService;
    }

    public Command createShell(ChannelSession channelSession) {
        return this.createCommand(null, null);
    }

    public Command createCommand(ChannelSession channelSession, String command) {
        Object result = null;
        result = command != null && command.trim().startsWith("scp") ? new ScpCommandWrapper(command, this.scpContextManager) : ("ra uplink".equals(command) ? new SshUplinkCommandHandler(this.uplinkSessionService, this.authenticationManager) : new SshCommandHandler(command, this.authenticationManager, this.commandExecutionService, this.sshConfiguration));
        return result;
    }
}

