/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.command.api;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.FileParameter;
import de.rcenvironment.core.command.spi.IntegerParameter;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.MultiStateParameter;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedFileParameter;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.ParsedListParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.WorkflowGraph;
import de.rcenvironment.core.component.workflow.api.WorkflowConstants;
import de.rcenvironment.core.component.workflow.command.api.WorkflowExecutionDisplayService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationResults;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationService;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class WfCommandPlugin
implements CommandPlugin {
    private static final String WF_DETAILS_OUTPUT_TEXT = "        Execution Count: %s,  Average Time: %s msec, Max Time: %s msec, Total Time: %s msec";
    private static final String SELF_TEST_CASES_FILE_ENDING = ".cases";
    private static final String SELF_TEST_CASES_DIR = "cases/";
    private static final String SELF_TEST_WORKFLOW_DIR = "workflows/";
    private static final String SLASH = "/";
    private static final String ESCAPED_BACKSLASH = "\\\\";
    private static final String ASTERISK = "*";
    private static final String DELETE_COMMAND = "delete";
    private static final String DISPOSE_COMMAND = "dispose";
    private static final int PARSING_WORKFLOW_FILE_RETRY_INTERVAL = 2000;
    private static final int MAXIMUM_WORKFLOW_PARSE_RETRIES = 5;
    private static final String BASEDIR_OPTION = "--basedir";
    private static final String INCLUDEDIRS_OPTION = "--includedirs";
    private static final String STRING_DOT = ".";
    private static final int WORKFLOW_SUFFIX_NUMBER_MODULO = 100;
    private static final String WRONG_STATE_ERROR = "%s workflow not possible in current workflow state: %s";
    private static final String WORKFLOW_ID = "<id>";
    private static final String WF = "wf";
    private static final String DELETE = "--delete";
    private static final String DISPOSE = "--dispose";
    private static final String ONFINISHED = "onfinished";
    private static final String PR = "--pr";
    private static final String SR = "--sr";
    private static final String JSON_FILE = "-p";
    private static final String PYTHON = "--python";
    private static final String CASES = "--cases";
    private static final FileParameter WORKFLOW_FILE_PARAMETER = new FileParameter("workflow file", "path to the workflow file");
    private static final StringParameter WORKFLOW_FILE_BASEDIR_PARAMETER = new StringParameter("workflow file", "path to the workflow file", null);
    private static final FileParameter JSON_FILE_PARAMETER = new FileParameter("JSON placholder file", "path to the JSON placeholder file");
    private static final FileParameter BASEDIR_PARAMETER = new FileParameter("base directory", "path to base directory");
    private static final FileParameter INCLUDEDIR_PARAMETER = new FileParameter("include directory", "path to directory to include workflow files");
    private static final FileParameter PYTHON_FILE_PARAMETER = new FileParameter("python exe path", "path to python exe");
    private static final IntegerParameter PR_PARAMETER = new IntegerParameter(Integer.valueOf(1), "parallel runs", "number of parallel runs");
    private static final IntegerParameter SR_PARAMETER = new IntegerParameter(Integer.valueOf(1), "sequential runs", "number of sequential runs");
    private static final StringParameter ID_PARAMETER = new StringParameter(null, "id", "id of the workflow");
    private static final StringParameter CASES_PARAMETER = new StringParameter("", "cases", "parameter for the cases");
    private static final ListCommandParameter WORKFLOW_LIST_PARAMETER = new ListCommandParameter((AbstractCommandParameter)WORKFLOW_FILE_PARAMETER, "workflows", "list of workflow files");
    private static final ListCommandParameter WORKFLOW_LIST_BASEDIR_PARAMETER = new ListCommandParameter((AbstractCommandParameter)WORKFLOW_FILE_BASEDIR_PARAMETER, "workflows", "list of workflow files");
    private static final ListCommandParameter CASES_LIST_PARAMETER = new ListCommandParameter((AbstractCommandParameter)CASES_PARAMETER, "cases", "cases");
    private static final ListCommandParameter INCLUDEDIR_LIST_PARAMETER = new ListCommandParameter((AbstractCommandParameter)INCLUDEDIR_PARAMETER, "include directory", "path to directory to include workflow files");
    private static final MultiStateParameter DISPOSE_DELETE_PARAMETR = new MultiStateParameter("dispose/delete", "", new String[]{"onfinished", "never", "always"});
    private static final NamedParameter NAMED_JSON_FILE_PARAMETER = new NamedSingleParameter("-p", "JSON placeholder file", (AbstractCommandParameter)JSON_FILE_PARAMETER);
    private static final NamedParameter NAMED_BASEDIR_PARAMETER = new NamedSingleParameter("--basedir", "optional base directory", (AbstractCommandParameter)BASEDIR_PARAMETER);
    private static final NamedParameter NAMED_INCLUDEDIR_LIST_PARAMETER = new NamedSingleParameter("--includedirs", "optional include directorys", (AbstractCommandParameter)INCLUDEDIR_LIST_PARAMETER);
    private static final NamedParameter NAMED_PYTHON_PARAMETER = new NamedSingleParameter("--python", "path to python.exe", (AbstractCommandParameter)PYTHON_FILE_PARAMETER);
    private static final NamedParameter DISPOSE_PARAMETER = new NamedSingleParameter("--dispose", "dispose behaviour", (AbstractCommandParameter)DISPOSE_DELETE_PARAMETR);
    private static final NamedParameter DELETE_PARAMETER = new NamedSingleParameter("--delete", "deletion behaviour", (AbstractCommandParameter)DISPOSE_DELETE_PARAMETR);
    private static final NamedParameter NAMED_PR_PARAMETER = new NamedSingleParameter("--pr", "number of parallel runs", (AbstractCommandParameter)PR_PARAMETER);
    private static final NamedParameter NAMED_SR_PARAMETER = new NamedSingleParameter("--sr", "number of sequential runs", (AbstractCommandParameter)SR_PARAMETER);
    private static final NamedParameter NAMED_CASES_PARAMETER = new NamedSingleParameter("--cases", "parameter for the cases", (AbstractCommandParameter)CASES_LIST_PARAMETER);
    private static final String FAILURE_DIR_NAME = "failure";
    private static final AtomicInteger GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER = new AtomicInteger();
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private WorkflowExecutionDisplayService workflowExecutionDisplayService;
    private WorkflowVerificationService workflowVerificationService;
    private MetaDataService metaDataService;
    private Bundle bundle;
    private final Log log = LogFactory.getLog(this.getClass());

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(WF, "manage workflows", "alias for \"wf list\"", this::performWfList, new SubCommandDescription[]{new SubCommandDescription("run", "starts a workflow from the given file and waits for its completion", this::performWfRun, new CommandModifierInfo(new AbstractCommandParameter[]{WORKFLOW_FILE_PARAMETER}, new CommandFlag[]{new CommandFlag("-c", "--compact-output")}, new NamedParameter[]{DELETE_PARAMETER, DISPOSE_PARAMETER, NAMED_JSON_FILE_PARAMETER})), new SubCommandDescription("start", "starts a workflow from the given file and returns its workflow id if validation passed", this::performWfStart, new CommandModifierInfo(new AbstractCommandParameter[]{WORKFLOW_FILE_PARAMETER}, new CommandFlag[]{new CommandFlag("-c", "--compact-output")}, new NamedParameter[]{DELETE_PARAMETER, DISPOSE_PARAMETER, NAMED_JSON_FILE_PARAMETER})), new SubCommandDescription("verify", "batch test the specified workflow files", this::performWfVerify, new CommandModifierInfo(new AbstractCommandParameter[]{WORKFLOW_LIST_BASEDIR_PARAMETER}, new NamedParameter[]{DELETE_PARAMETER, DISPOSE_PARAMETER, NAMED_PR_PARAMETER, NAMED_SR_PARAMETER, NAMED_JSON_FILE_PARAMETER, NAMED_BASEDIR_PARAMETER, NAMED_INCLUDEDIR_LIST_PARAMETER})), new SubCommandDescription("list", "show workflow list", this::performWfList), new SubCommandDescription("details", "show details of a workflow", this::performWfShowDetails, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("open", "open a runtime viewer of a workflow. Requires GUI.", this::performWfOpen, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("pause", "pause a running workflow", this::performWfPause, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("resume", "resume a paused workflow", this::performWfResume, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("cancel", "cancel a running or paused workflow", this::performWfCancel, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription(DELETE_COMMAND, "delete and dispose a finished, cancelled or failed workflow", this::performWfDelete, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription(DISPOSE_COMMAND, "disposes a finished, cancelled or failed workflow", this::performWfDispose, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("self-test", "batch test workflow files of the test workflow files bundle", this::performWfSelfTest, new CommandModifierInfo(new NamedParameter[]{DISPOSE_PARAMETER, DELETE_PARAMETER, NAMED_PR_PARAMETER, NAMED_SR_PARAMETER, NAMED_PYTHON_PARAMETER, NAMED_CASES_PARAMETER}), true), new SubCommandDescription("list-self-test-cases", "list available test cases for wf self-test", this::performWfListSelfTestCases, true), new SubCommandDescription("check-self-test-cases", "check if all test workflows are part of at least one test case", this::performWfCheckSelfTestCases, true), new SubCommandDescription("graph", "prints .dot string representation of a workflow (can be used to create graph visualization with Graphviz)", this::performWfGraph, new CommandModifierInfo(new AbstractCommandParameter[]{WORKFLOW_FILE_PARAMETER}), true)});
        return new MainCommandDescription[]{commands};
    }

    @Activate
    public void activate(ComponentContext context) {
        this.bundle = context.getBundleContext().getBundle();
    }

    @Reference
    public void bindWorkflowExecutionService(HeadlessWorkflowExecutionService newInstance) {
        this.workflowExecutionService = newInstance;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void bindWorkflowExecutionDisplayService(WorkflowExecutionDisplayService newInstance) {
        this.workflowExecutionDisplayService = newInstance;
    }

    public void unbindWorkflowExecutionDisplayService(WorkflowExecutionDisplayService oldInstance) {
        this.workflowExecutionDisplayService = null;
    }

    @Reference
    public void bindMetaDataService(MetaDataService newInstance) {
        this.metaDataService = newInstance;
    }

    @Reference
    public void bindWorkflowVerificationService(WorkflowVerificationService service) {
        this.workflowVerificationService = service;
    }

    private void performWfRun(CommandContext cmdCtx) throws CommandException {
        this.performWfRunOrStart(cmdCtx, true);
    }

    private void performWfStart(CommandContext cmdCtx) throws CommandException {
        this.performWfRunOrStart(cmdCtx, false);
    }

    private void performWfRunOrStart(CommandContext cmdCtx, boolean waitForTermination) throws CommandException {
        ParsedCommandModifiers modifiers = cmdCtx.getParsedModifiers();
        ParsedStringParameter disposeParameter = (ParsedStringParameter)modifiers.getCommandParameter(DISPOSE);
        ParsedStringParameter deleteParameter = (ParsedStringParameter)modifiers.getCommandParameter(DELETE);
        ParsedFileParameter placeholdersParameter = (ParsedFileParameter)modifiers.getCommandParameter(JSON_FILE);
        ParsedFileParameter fileParameter = (ParsedFileParameter)modifiers.getPositionalCommandParameter(0);
        boolean hasCompactFlag = modifiers.hasCommandFlag("-c");
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.toDisposal(disposeParameter.getResult(), cmdCtx);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.toDeletion(deleteParameter.getResult(), cmdCtx);
        if (this.workflowVerificationService.preValidateWorkflow(cmdCtx.getOutputReceiver(), fileParameter.getResult(), true)) {
            try {
                HeadlessWorkflowExecutionContextBuilder exeContextBuilder = new HeadlessWorkflowExecutionContextBuilder(fileParameter.getResult()).setLogDirectory(this.setupLogDirectoryForWfFile(fileParameter.getResult()));
                exeContextBuilder.setPlaceholdersFile(placeholdersParameter.getResult());
                exeContextBuilder.setTextOutputReceiver(cmdCtx.getOutputReceiver(), hasCompactFlag);
                exeContextBuilder.setDisposalBehavior(dispose);
                exeContextBuilder.setDeletionBehavior(delete);
                if (waitForTermination) {
                    this.workflowExecutionService.executeWorkflow(exeContextBuilder.buildExtended());
                }
                WorkflowExecutionInformation execInfo = this.workflowExecutionService.startHeadlessWorkflowExecution((HeadlessWorkflowExecutionContext)exeContextBuilder.buildExtended());
                cmdCtx.println((Object)("Workflow Id: " + execInfo.getWorkflowExecutionHandle().getIdentifier()));
            }
            catch (WorkflowExecutionException | IOException e) {
                this.log.error((Object)("Exception while executing workflow: " + fileParameter.getResult().getAbsolutePath()), e);
                throw CommandException.executionError((String)ComponentUtils.createErrorLogMessage((Throwable)e), (CommandContext)cmdCtx);
            }
            catch (InvalidFilenameException e) {
                throw CommandException.executionError((String)ComponentUtils.createErrorLogMessage((Throwable)e), (CommandContext)cmdCtx);
            }
        } else {
            cmdCtx.getOutputReceiver().addOutput(StringUtils.format((String)"'%s' not executed due to validation errors (see log file for details) (full path: %s)", (Object[])new Object[]{fileParameter.getResult().getName(), fileParameter.getResult().getAbsolutePath()}));
        }
    }

    private HeadlessWorkflowExecutionService.DisposalBehavior toDisposal(String token, CommandContext context) throws CommandException {
        if (HeadlessWorkflowExecutionService.DisposalBehavior.Always.name().equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DisposalBehavior.Always;
        }
        if (HeadlessWorkflowExecutionService.DisposalBehavior.Never.name().equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DisposalBehavior.Never;
        }
        if (ONFINISHED.equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected;
        }
        throw CommandException.syntaxError((String)("Invalid disposal behavior: " + token), (CommandContext)context);
    }

    private HeadlessWorkflowExecutionService.DeletionBehavior toDeletion(String token, CommandContext context) throws CommandException {
        if (HeadlessWorkflowExecutionService.DeletionBehavior.Always.name().equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DeletionBehavior.Always;
        }
        if (HeadlessWorkflowExecutionService.DeletionBehavior.Never.name().equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DeletionBehavior.Never;
        }
        if (ONFINISHED.equalsIgnoreCase(token)) {
            return HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected;
        }
        throw CommandException.syntaxError((String)("Invalid delete behavior: " + token), (CommandContext)context);
    }

    private void performWfVerify(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedListParameter workflowListParameter = (ParsedListParameter)modifiers.getPositionalCommandParameter(0);
        ParsedFileParameter basedirParameter = (ParsedFileParameter)modifiers.getCommandParameter(BASEDIR_OPTION);
        ParsedListParameter includedirsListParameter = (ParsedListParameter)modifiers.getCommandParameter(INCLUDEDIRS_OPTION);
        ParsedStringParameter disposeParameter = (ParsedStringParameter)modifiers.getCommandParameter(DISPOSE);
        ParsedStringParameter deleteParameter = (ParsedStringParameter)modifiers.getCommandParameter(DELETE);
        ParsedIntegerParameter parallelRunsParameter = (ParsedIntegerParameter)modifiers.getCommandParameter(PR);
        ParsedIntegerParameter sequentialRunsParameter = (ParsedIntegerParameter)modifiers.getCommandParameter(SR);
        ParsedFileParameter placeholderFileParameter = (ParsedFileParameter)modifiers.getCommandParameter(JSON_FILE);
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.toDisposal(disposeParameter.getResult(), context);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.toDeletion(deleteParameter.getResult(), context);
        List<String> workflowList = workflowListParameter.getResult().stream().map(parameter -> ((ParsedStringParameter)parameter).getResult()).collect(Collectors.toList());
        List<File> includedirsList = includedirsListParameter.getResult().stream().map(parameter -> ((ParsedFileParameter)parameter).getResult()).collect(Collectors.toList());
        List<File> wfFiles = this.collectFiles(context, workflowList, basedirParameter.getResult(), includedirsList);
        Map<Boolean, List<File>> partitionedWfFiles = wfFiles.stream().collect(Collectors.partitioningBy(file -> !file.getParentFile().getName().equals(FAILURE_DIR_NAME)));
        File rootFolder = !partitionedWfFiles.get(true).isEmpty() ? partitionedWfFiles.get(true).get(0).getParentFile() : partitionedWfFiles.get(false).get(0).getParentFile().getParentFile();
        try {
            WorkflowVerificationResults wfVerifyResultVerification = this.workflowVerificationService.getVerificationBuilder().outputReceiver(context.getOutputReceiver()).workflowRootFile(rootFolder).addWorkflowsExpectedToSucceed((Collection)partitionedWfFiles.get(true)).addWorkflowsExpectedToFail((Collection)partitionedWfFiles.get(false)).placeholdersFile(placeholderFileParameter.getResult()).logFileFactory(this::setupLogDirectoryForWfFile).numberOfParallelRuns(parallelRunsParameter.getResult().intValue()).numberOfSequentialRuns(sequentialRunsParameter.getResult().intValue()).disposalBehavior(dispose).deletionBehavior(delete).verify();
            context.println((Object)wfVerifyResultVerification.getVerificationReport());
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Failed to initialze expected workflow behavior: " + e.getMessage()), (CommandContext)context);
        }
    }

    private List<File> collectFiles(CommandContext context, List<String> workflowList, File basedir, List<File> includeList) throws CommandException {
        ArrayList<File> wfFiles = new ArrayList();
        if (basedir == null) {
            wfFiles.addAll(workflowList.stream().map(File::new).collect(Collectors.toList()));
        } else {
            wfFiles = workflowList.stream().map(filename -> new File(basedir, (String)filename)).collect(Collectors.toList());
        }
        for (File includeDir : includeList) {
            if (includeDir.isDirectory()) {
                String[] stringArray = includeDir.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename2 = stringArray[n2];
                    if (filename2.endsWith(".wf") && !filename2.endsWith("_backup.wf")) {
                        File wfFile = new File(includeDir, filename2);
                        this.checkWfFileExists(context, wfFile);
                        wfFiles.add(wfFile);
                    }
                    ++n2;
                }
                continue;
            }
            throw CommandException.syntaxError((String)("includedir " + includeDir + " is not a directory"), (CommandContext)context);
        }
        return wfFiles;
    }

    private void performWfPause(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionInformation wfExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wfExecInf != null) {
            try {
                if (wfExecInf.getWorkflowState().equals((Object)WorkflowState.RUNNING)) {
                    this.workflowExecutionService.pause(wfExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Pausing", wfExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to pause workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfResume(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (wExecInf.getWorkflowState().equals((Object)WorkflowState.PAUSED)) {
                    this.workflowExecutionService.resume(wExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Resuming", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to resume workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfCancel(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (wExecInf.getWorkflowState().equals((Object)WorkflowState.RUNNING) || wExecInf.getWorkflowState().equals((Object)WorkflowState.PAUSED)) {
                    this.workflowExecutionService.cancel(wExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Canceling", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to cancel workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfDispose(CommandContext context) {
        this.performWfDisposeOrDelete(context, true);
    }

    private void performWfDelete(CommandContext context) {
        this.performWfDisposeOrDelete(context, false);
    }

    private void performWfDisposeOrDelete(CommandContext context, boolean delete) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (WorkflowConstants.FINAL_WORKFLOW_STATES.contains(wExecInf.getWorkflowState())) {
                    if (!delete) {
                        this.workflowExecutionService.deleteFromDataManagement(wExecInf.getWorkflowExecutionHandle());
                    }
                    this.workflowExecutionService.dispose(wExecInf.getWorkflowExecutionHandle());
                } else if (delete) {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Deleting", wExecInf.getWorkflowState()}));
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Disposing", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to dispose workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfList(CommandContext context) {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        outputReceiver.addOutput("Fetching workflows...");
        ArrayList wfInfos = new ArrayList(this.workflowExecutionService.getWorkflowExecutionInformations(true));
        Collections.sort(wfInfos);
        StringBuilder outputBuilder = new StringBuilder();
        int total = 0;
        int running = 0;
        int paused = 0;
        int finished = 0;
        int cancelled = 0;
        int failed = 0;
        int resultsRejected = 0;
        int other = 0;
        for (WorkflowExecutionInformation wfInfo : wfInfos) {
            WorkflowState state = wfInfo.getWorkflowState();
            outputBuilder.append(StringUtils.format((String)" '%s' - %s [%s]\n", (Object[])new Object[]{wfInfo.getInstanceName(), state, wfInfo.getExecutionIdentifier()}));
            ++total;
            switch (state) {
                case RUNNING: {
                    ++running;
                    break;
                }
                case PAUSED: {
                    ++paused;
                    break;
                }
                case FINISHED: {
                    ++finished;
                    break;
                }
                case CANCELLED: {
                    ++cancelled;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
                case RESULTS_REJECTED: {
                    ++resultsRejected;
                    break;
                }
                default: {
                    ++other;
                }
            }
        }
        outputBuilder.append(StringUtils.format((String)" -- TOTAL COUNT: %d workflow(s): %d running, %d paused, %d finished, %d cancelled, %d failed, %d verification failed, %d other -- ", (Object[])new Object[]{total, running, paused, finished, cancelled, failed, resultsRejected, other}));
        outputReceiver.addOutput(outputBuilder.toString());
    }

    private void performWfShowDetails(CommandContext context) throws CommandException {
        WorkflowRun workflowRunData;
        TextOutputReceiver outputReceiver;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver = context.getOutputReceiver());
        if (wExecInf == null) {
            return;
        }
        Long wfDataManagementId = wExecInf.getWorkflowDataManagementId();
        LogicalNodeId wfControllerNodeId = wExecInf.getNodeId();
        ArrayList compExecInfos = new ArrayList(wExecInf.getComponentExecutionInformations());
        Collections.sort(compExecInfos, (p1, p2) -> p1.getInstanceName().compareTo(p2.getInstanceName()));
        try {
            workflowRunData = this.metaDataService.getWorkflowRun(wfDataManagementId, (NetworkDestination)wfControllerNodeId);
        }
        catch (CommunicationException communicationException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Failed to fetch run data of workflow #%s from %s", (Object[])new Object[]{wfDataManagementId, wfControllerNodeId}), (CommandContext)context);
        }
        if (workflowRunData == null) {
            throw CommandException.executionError((String)StringUtils.format((String)"No run data found for workflow #%s from %s. Maybe data have been already deleted.", (Object[])new Object[]{wfDataManagementId, wfControllerNodeId}), (CommandContext)context);
        }
        Map componentRunsByComponentInstance = workflowRunData.getComponentRuns();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd  HH:mm:ss");
        if (wExecInf != null) {
            outputReceiver.addOutput("Name: " + wExecInf.getInstanceName());
            outputReceiver.addOutput("Status: " + wExecInf.getWorkflowState());
            outputReceiver.addOutput("Controller: " + wExecInf.getWorkflowDescription().getControllerNode().getAssociatedDisplayName());
            outputReceiver.addOutput("Start: " + df.format(wExecInf.getStartTime()));
            outputReceiver.addOutput("Started from: " + wExecInf.getNodeIdStartedExecution().getAssociatedDisplayName());
            String additional = wExecInf.getAdditionalInformationProvidedAtStart();
            if (additional != null) {
                outputReceiver.addOutput("Additional Information: ");
                outputReceiver.addOutput(additional);
            }
            outputReceiver.addOutput("Components: ");
            for (ComponentExecutionInformation compExecInfo : compExecInfos) {
                Map.Entry<ComponentInstance, Set<ComponentRun>> entry = this.getComponentRuns(compExecInfo, componentRunsByComponentInstance);
                if (entry == null) {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: No run yet. Execution Count: 0", (Object[])new Object[]{compExecInfo.getInstanceName()}));
                    continue;
                }
                ComponentInstance componentInstance = entry.getKey();
                TreeSet componentRuns = new TreeSet(entry.getValue());
                if (((ComponentRun)componentRuns.first()).getRunCounter() == 0) {
                    componentRuns.remove(componentRuns.first());
                }
                if (((ComponentRun)componentRuns.last()).getRunCounter() == -1) {
                    componentRuns.remove(componentRuns.last());
                }
                if (componentRuns.isEmpty()) {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: No run yet. Execution Count: 0", (Object[])new Object[]{compExecInfo.getInstanceName()}));
                    continue;
                }
                long sum = 0L;
                long max = 0L;
                for (ComponentRun cRun : componentRuns) {
                    if (((ComponentRun)componentRuns.last()).getEndTime() == null) continue;
                    long diff = cRun.getEndTime() - cRun.getStartTime();
                    sum += diff;
                    if (diff <= max) continue;
                    max = diff;
                }
                int average = (int)(sum / (long)componentRuns.size());
                String componentInstanceName = componentInstance.getComponentInstanceName();
                if (((ComponentRun)componentRuns.last()).getEndTime() != null) {
                    String endTime = df.format(((ComponentRun)componentRuns.last()).getEndTime());
                    String message = componentInstance.getFinalState() == null ? StringUtils.format((String)"    %s: Waiting for Input since %s", (Object[])new Object[]{componentInstanceName, endTime}) : StringUtils.format((String)"    %s: %s at %s", (Object[])new Object[]{componentInstanceName, componentInstance.getFinalState(), endTime});
                    outputReceiver.addOutput(message);
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: started at %s", (Object[])new Object[]{componentInstanceName, df.format(((ComponentRun)componentRuns.first()).getStartTime())}));
                    outputReceiver.addOutput(StringUtils.format((String)"        Current Execution started at %s", (Object[])new Object[]{df.format(((ComponentRun)componentRuns.last()).getStartTime())}));
                }
                outputReceiver.addOutput(StringUtils.format((String)WF_DETAILS_OUTPUT_TEXT, (Object[])new Object[]{((ComponentRun)componentRuns.last()).getRunCounter(), average, max, sum}));
            }
        }
    }

    private Map.Entry<ComponentInstance, Set<ComponentRun>> getComponentRuns(ComponentExecutionInformation compExecInfo, Map<ComponentInstance, Set<ComponentRun>> componentRunsByComponentInstance) {
        for (Map.Entry<ComponentInstance, Set<ComponentRun>> entry : componentRunsByComponentInstance.entrySet()) {
            ComponentInstance componentInstance = entry.getKey();
            if (!componentInstance.getComponentInstanceName().equals(compExecInfo.getInstanceName())) continue;
            return entry;
        }
        return null;
    }

    private void performWfOpen(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        WorkflowExecutionDisplayService displayService = this.workflowExecutionDisplayService;
        if (displayService == null || !displayService.hasGui()) {
            outputReceiver.addOutput("Could not display workflow execution, as no GUI is present.");
            return;
        }
        WorkflowExecutionInformation wfExecInfo = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wfExecInfo == null) {
            return;
        }
        displayService.displayWorkflowExecution(wfExecInfo);
    }

    private String getSelfTestDirPath() {
        String path = "/src/main/resources/";
        if (this.bundle.findEntries(path, ASTERISK, false) == null) {
            path = SLASH;
        }
        return path;
    }

    private void performWfListSelfTestCases(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        for (String testCaseFileName : this.getTestCaseFileNamesWithoutEnding()) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream caseFileInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + testCaseFileName + SELF_TEST_CASES_FILE_ENDING);){
                    outputReceiver.addOutput(StringUtils.format((String)"%s [%d]", (Object[])new Object[]{testCaseFileName, IOUtils.readLines((InputStream)caseFileInputStream).size()}));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw CommandException.executionError((String)("Failed to read test case file: " + testCaseFileName), (CommandContext)context);
            }
        }
    }

    private void performWfCheckSelfTestCases(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        ArrayList<String> wfFileNamesWithoutEnding = new ArrayList<String>();
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR, "*.wf", true);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            wfFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(".wf", ""));
        }
        Enumeration selfTestFailureFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR + FAILURE_DIR_NAME, "*.wf", true);
        while (selfTestFailureFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFailureFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            wfFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(".wf", ""));
        }
        HashSet wfPartOfTestCase = new HashSet();
        for (String testCaseFileName : this.getTestCaseFileNamesWithoutEnding()) {
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (InputStream caseFileInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + testCaseFileName + SELF_TEST_CASES_FILE_ENDING);){
                    wfPartOfTestCase.addAll(IOUtils.readLines((InputStream)caseFileInputStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw CommandException.executionError((String)("Failed to read test case file: " + testCaseFileName), (CommandContext)context);
            }
        }
        wfFileNamesWithoutEnding.removeAll(wfPartOfTestCase);
        if (wfFileNamesWithoutEnding.isEmpty()) {
            outputReceiver.addOutput("Ok: Every workflow file is considered by at least one test case");
        } else {
            outputReceiver.addOutput("Failed: Workflow file(s) are not considered by at least one test case: " + wfFileNamesWithoutEnding);
        }
    }

    private List<String> getTestCaseFileNamesWithoutEnding() {
        ArrayList<String> testCaseFileNamesWithoutEnding = new ArrayList<String>();
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR, "*.cases", false);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            testCaseFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(SELF_TEST_CASES_FILE_ENDING, ""));
        }
        return testCaseFileNamesWithoutEnding;
    }

    private void performWfSelfTest(CommandContext context) throws CommandException {
        List<File> workflowFiles;
        String message;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter disposeParameter = (ParsedStringParameter)modifiers.getCommandParameter(DISPOSE);
        ParsedStringParameter deleteParameter = (ParsedStringParameter)modifiers.getCommandParameter(DELETE);
        ParsedIntegerParameter parallelRunsParameter = (ParsedIntegerParameter)modifiers.getCommandParameter(PR);
        ParsedIntegerParameter sequentialRunsParameter = (ParsedIntegerParameter)modifiers.getCommandParameter(SR);
        ParsedListParameter casesParameter = (ParsedListParameter)modifiers.getCommandParameter(CASES);
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.toDisposal(disposeParameter.getResult(), context);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.toDeletion(deleteParameter.getResult(), context);
        int parallelRuns = parallelRunsParameter.getResult();
        int sequentialRuns = sequentialRunsParameter.getResult();
        List<Object> cases = casesParameter.getResult().stream().map(parameter -> ((ParsedStringParameter)parameter).getResult()).collect(Collectors.toList());
        if (cases.isEmpty()) {
            cases = Collections.singletonList("core");
        }
        String pythonPath = null;
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        File tempSelfTestWorkflowDir = null;
        File tempSelfTestWorkflowFailureDir = null;
        File tempPlaceholdersStuffDir = null;
        File placeholdersFile = null;
        try {
            tempSelfTestWorkflowDir = tempFileService.createManagedTempDir();
            tempSelfTestWorkflowFailureDir = new File(tempSelfTestWorkflowDir, FAILURE_DIR_NAME);
            tempPlaceholdersStuffDir = tempFileService.createManagedTempDir();
        }
        catch (IOException e) {
            message = "Failed to create temp directory required for self-test workflow execution";
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        if (cases.contains("with-python")) {
            try {
                pythonPath = this.getAndCheckPythonPath(context, tempSelfTestWorkflowDir);
            }
            catch (IOException e) {
                message = "Failed to check command to be used to invoke Python";
                this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
            }
        }
        try {
            this.copyWorkflowsForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempSelfTestWorkflowFailureDir, cases);
        }
        catch (IOException e) {
            message = "Failed to copy workflow files from self-test folder to temp directory: " + e.getMessage();
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        try {
            placeholdersFile = this.generatePlaceholdersRelatedFiles(tempPlaceholdersStuffDir, pythonPath);
        }
        catch (IOException e) {
            message = "Failed to create placeholders-related files required for self-test workflow execution";
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        ArrayList<File> includedirs = new ArrayList<File>();
        includedirs.add(tempSelfTestWorkflowDir);
        if (tempSelfTestWorkflowFailureDir.exists()) {
            includedirs.add(tempSelfTestWorkflowFailureDir);
        }
        if ((workflowFiles = this.collectFiles(context, Collections.emptyList(), null, includedirs)).isEmpty()) {
            throw CommandException.syntaxError((String)"at least one workflow file must be specified", (CommandContext)context);
        }
        Map<Boolean, List<File>> partitionedWfFiles = workflowFiles.stream().collect(Collectors.partitioningBy(file -> !file.getParentFile().getName().equals(FAILURE_DIR_NAME)));
        File rootFolder = !partitionedWfFiles.get(true).isEmpty() ? partitionedWfFiles.get(true).get(0).getParentFile() : partitionedWfFiles.get(false).get(0).getParentFile().getParentFile();
        try {
            WorkflowVerificationResults wfVerifyResultVerification = this.workflowVerificationService.getVerificationBuilder().outputReceiver(context.getOutputReceiver()).workflowRootFile(rootFolder).addWorkflowsExpectedToSucceed((Collection)partitionedWfFiles.get(true)).addWorkflowsExpectedToFail((Collection)partitionedWfFiles.get(false)).placeholdersFile(placeholdersFile).logFileFactory(this::setupLogDirectoryForWfFile).numberOfParallelRuns(parallelRuns).numberOfSequentialRuns(sequentialRuns).disposalBehavior(dispose).deletionBehavior(delete).verify();
            context.println((Object)wfVerifyResultVerification.getVerificationReport());
            if (!delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.Never) && (wfVerifyResultVerification.isVerified() || delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.Always))) {
                this.disposeTempDirsCreatedForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir);
            } else if (delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected)) {
                for (File file2 : wfVerifyResultVerification.getWorkflowRelatedFilesToDelete()) {
                    try {
                        tempFileService.disposeManagedTempDirOrFile(file2);
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Failed to delete workflow file after execution: " + file2), (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Failed to initialze expected workflow behavior: " + e.getMessage()), (CommandContext)context);
        }
    }

    private String getAndCheckPythonPath(CommandContext context, File workDir) throws CommandException, IOException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedFileParameter pythonPathParameter = (ParsedFileParameter)modifiers.getCommandParameter(PYTHON);
        String pythonPath = null;
        pythonPath = pythonPathParameter.getResult() != null ? pythonPathParameter.getResult().getAbsolutePath() : "python";
        LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(workDir);
        executor.start(String.valueOf(pythonPath) + " --version");
        try {
            if (executor.waitForTermination() != 0) {
                throw CommandException.executionError((String)("Command to invoke Python invalid: " + pythonPath), (CommandContext)context);
            }
        }
        catch (InterruptedException e) {
            throw CommandException.executionError((String)("Interupted when checking command to invoke Python: " + e.getMessage()), (CommandContext)context);
        }
        Throwable throwable = null;
        Object var8_10 = null;
        try (InputStream stdErrStream = executor.getStderr();){
            context.getOutputReceiver().addOutput("Using: " + IOUtils.toString((InputStream)stdErrStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pythonPath;
    }

    private void handleWfSelfTestExecutionError(CommandContext context, TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempPlaceholdersStuffDir, IOException e, String message) throws CommandException {
        this.log.error((Object)message, (Throwable)e);
        this.disposeTempDirsCreatedForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir);
        throw CommandException.executionError((String)message, (CommandContext)context);
    }

    private void disposeTempDirsCreatedForSelfTest(TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempPlaceholdersStuffDir) {
        if (tempSelfTestWorkflowDir != null) {
            try {
                tempFileService.disposeManagedTempDirOrFile(tempSelfTestWorkflowDir);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to dispose temp directory created for self-test workflow execution: " + tempSelfTestWorkflowDir), (Throwable)e);
            }
        }
        if (tempPlaceholdersStuffDir != null) {
            try {
                tempFileService.disposeManagedTempDirOrFile(tempPlaceholdersStuffDir);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to dispose temp directory created for self-test workflow execution: " + tempPlaceholdersStuffDir), (Throwable)e);
            }
        }
    }

    private List<String> getWorkflowsForSelfTest(List<String> cases) throws IOException {
        ArrayList<String> wfs = new ArrayList<String>();
        for (String caseName : cases) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream caseInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + caseName + SELF_TEST_CASES_FILE_ENDING);){
                if (caseInputStream == null) {
                    throw new IOException("Case unknown: " + caseName);
                }
                wfs.addAll(IOUtils.readLines((InputStream)caseInputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return wfs;
    }

    private void copyWorkflowsForSelfTest(TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempSelfTestWorkflowFailureDir, List<String> cases) throws IOException {
        tempSelfTestWorkflowFailureDir.mkdir();
        List<String> wfsForSelfTest = this.getWorkflowsForSelfTest(cases);
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR, ASTERISK, true);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String entryRawPath = entryURL.getPath();
            if (entryRawPath.endsWith(SLASH)) {
                if (entryRawPath.endsWith("failure/")) continue;
                throw new IOException("Unexpected directory in self-test directory: " + entryRawPath);
            }
            String[] pathParts = entryRawPath.split(SLASH);
            String selfTestFileName = pathParts[pathParts.length - 1];
            this.validateFileInSelfTestDirectory(selfTestFileName);
            String selfTestFileNameWithoutEnding = selfTestFileName.replace(".wf", "");
            if (selfTestFileName.endsWith(".wf") && !wfsForSelfTest.contains(selfTestFileNameWithoutEnding)) continue;
            wfsForSelfTest.remove(selfTestFileNameWithoutEnding);
            File targetFile = pathParts.length > 1 && pathParts[pathParts.length - 2].equals(FAILURE_DIR_NAME) ? new File(tempSelfTestWorkflowFailureDir, selfTestFileName) : new File(tempSelfTestWorkflowDir, selfTestFileName);
            Throwable throwable = null;
            Object var14_15 = null;
            try {
                InputStream entryInputStream = entryURL.openStream();
                try {
                    try (FileWriter targetTempFileWriter = new FileWriter(targetFile);){
                        IOUtils.copy((InputStream)entryInputStream, (Writer)targetTempFileWriter, (Charset)StandardCharsets.UTF_8);
                    }
                    if (entryInputStream == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    throw throwable;
                }
                entryInputStream.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.validateSelfTestData(wfsForSelfTest, tempSelfTestWorkflowFailureDir);
    }

    private void validateFileInSelfTestDirectory(String selfTestFileName) throws IOException {
        if (!(selfTestFileName.endsWith(".wf") || selfTestFileName.endsWith(".log.expected") || selfTestFileName.endsWith(".log.prohibited"))) {
            throw new IOException("Unexpected file in self-test directory: " + selfTestFileName);
        }
    }

    private void validateSelfTestData(List<String> wfsForSelfTestNotUsed, File tempSelfTestWorkflowFailureDir) throws IOException {
        if (!wfsForSelfTestNotUsed.isEmpty()) {
            throw new IOException("A test case contains workflow file(s) that do(es)n't exist: " + wfsForSelfTestNotUsed);
        }
        this.validateExpectedLogExistsForWorkflowsExpectedToFail(tempSelfTestWorkflowFailureDir);
    }

    private void validateExpectedLogExistsForWorkflowsExpectedToFail(File tempSelfTestWorkflowFailureDir) throws IOException {
        File[] fileArray = tempSelfTestWorkflowFailureDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".wf") && !new File(tempSelfTestWorkflowFailureDir, String.valueOf(file.getName().replaceAll(".wf", "")) + ".log.expected").exists()) {
                throw new IOException("File with expected log is missing for workflow expected to fail: " + file);
            }
            ++n2;
        }
    }

    private File generatePlaceholdersRelatedFiles(File tempPlaceholdersStuffDir, String pythonPath) throws IOException {
        InputStream placeholdersTemplateInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + "placeholders/placeholders_template.json");
        Random radom = new Random();
        File placeholdersFile = new File(tempPlaceholdersStuffDir, "placeholders.json");
        File testInputFile = new File(tempPlaceholdersStuffDir, "test-input.text");
        FileUtils.write((File)testInputFile, (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        File testInputDir = new File(tempPlaceholdersStuffDir, "test-input-dir");
        testInputDir.mkdir();
        FileUtils.write((File)new File(testInputDir, "test-file-1"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        FileUtils.write((File)new File(testInputDir, "test-file-2"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        FileUtils.write((File)new File(testInputDir, "test-file-3"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        File testTargetRootDir = new File(tempPlaceholdersStuffDir, "test-target-dir");
        testTargetRootDir.mkdir();
        File testMemFile1 = new File(tempPlaceholdersStuffDir, "test-mem-1");
        File testMemFile2 = new File(tempPlaceholdersStuffDir, "test-mem-2");
        File testMemFile3 = new File(tempPlaceholdersStuffDir, "test-mem-3");
        FileUtils.write((File)placeholdersFile, (CharSequence)StringUtils.format((String)IOUtils.toString((InputStream)placeholdersTemplateInputStream), (Object[])new Object[]{pythonPath, testInputFile.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testInputDir.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testTargetRootDir.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile1.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile2.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile3.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH)}));
        return placeholdersFile;
    }

    private void checkWfFileExists(CommandContext context, File wfFile) throws CommandException {
        if (!wfFile.isFile()) {
            throw CommandException.executionError((String)("Specified workflow file does not exist: " + wfFile.getAbsolutePath()), (CommandContext)context);
        }
    }

    private File setupLogDirectoryForWfFile(File wfFile) throws IOException {
        if (!wfFile.isFile()) {
            throw new IOException("The workflow file \"" + wfFile.getAbsolutePath() + "\" does not exist or it cannot be opened");
        }
        File parentDir = wfFile.getParentFile();
        if (!parentDir.isDirectory()) {
            throw new IOException("Consistency error: parent directory is not a directory: " + parentDir.getAbsolutePath());
        }
        long millis = new GregorianCalendar().getTimeInMillis();
        String folderName = wfFile.getName();
        if (folderName.contains(STRING_DOT)) {
            folderName = folderName.substring(0, folderName.lastIndexOf(STRING_DOT));
        }
        int suffixNumber = GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER.incrementAndGet() % 100;
        Timestamp ts = new Timestamp(millis);
        folderName = "logs/" + folderName + "_" + ts.toString().replace('.', '-').replace(' ', '_').replace(':', '-') + "_" + suffixNumber;
        File logDir = new File(parentDir, folderName);
        logDir.mkdirs();
        if (!logDir.isDirectory()) {
            throw new IOException("Failed to create log directory" + logDir.getAbsolutePath());
        }
        return logDir;
    }

    private WorkflowExecutionInformation getWfExecInfFromExecutionId(String executionId, TextOutputReceiver outputReceiver) {
        WorkflowExecutionInformation wExecInf = null;
        Set wis = this.workflowExecutionService.getWorkflowExecutionInformations();
        for (WorkflowExecutionInformation workflow : wis) {
            if (!workflow.getExecutionIdentifier().equals(executionId)) continue;
            wExecInf = workflow;
            break;
        }
        if (wExecInf == null) {
            outputReceiver.addOutput("Workflow with id '" + executionId + "' not found");
        }
        return wExecInf;
    }

    private void performWfGraph(final CommandContext cmdCtx) throws CommandException {
        WorkflowDescription wfDesc;
        ParsedCommandModifiers modifiers = cmdCtx.getParsedModifiers();
        File wfFile = ((ParsedFileParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        try {
            wfDesc = this.workflowExecutionService.loadWorkflowDescriptionFromFile(wfFile, new WorkflowDescriptionLoaderCallback(){

                public void onWorkflowFileParsingPartlyFailed(String backupFilename) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow partly invalid, some parts are removed; backup file: " + backupFilename);
                }

                public void onSilentWorkflowFileUpdated(String message) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow updated (silent update): " + message);
                }

                public void onNonSilentWorkflowFileUpdated(String message, String backupFilename) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow updated: " + message + "; backup file: " + backupFilename);
                }

                public boolean arePartlyParsedWorkflowConsiderValid() {
                    return false;
                }
            });
        }
        catch (WorkflowFileException e) {
            throw CommandException.executionError((String)("Failed to load workflow: " + e.getMessage()), (CommandContext)cmdCtx);
        }
        if (WorkflowExecutionUtils.hasMissingWorkflowNode((List)wfDesc.getWorkflowNodes())) {
            throw CommandException.executionError((String)"Workflow has missing components", (CommandContext)cmdCtx);
        }
        try {
            WorkflowGraph workflowGraph = this.createWorkflowGraph(wfDesc);
            if (workflowGraph == null) {
                throw CommandException.executionError((String)("The wf graph command is not implemented yet. See " + this.getClass().getTypeName() + " for more informations."), (CommandContext)cmdCtx);
            }
            cmdCtx.getOutputReceiver().addOutput(workflowGraph.toDotScript());
        }
        catch (WorkflowExecutionException e) {
            throw CommandException.executionError((String)("Failed to create workflow graph: " + e.getMessage()), (CommandContext)cmdCtx);
        }
    }

    private WorkflowGraph createWorkflowGraph(WorkflowDescription workflowDescription) throws WorkflowExecutionException {
        return null;
    }
}

