/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import de.rcenvironment.core.datamodel.api.TypedDatum;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class WorkflowFunctionResult {
    private final boolean success;
    private final Map<String, TypedDatum> results = new HashMap<String, TypedDatum>();

    WorkflowFunctionResult(boolean success) {
        this.success = success;
    }

    public static Builder successBuilder() {
        return new Builder();
    }

    public static WorkflowFunctionResult buildFailure() {
        return new WorkflowFunctionResult(false);
    }

    public boolean isFailure() {
        return !this.success;
    }

    public Map<String, TypedDatum> toMap() {
        return new HashMap<String, TypedDatum>(this.results);
    }

    public Collection<String> getResultIdentifiers() {
        return new HashSet<String>(this.results.keySet());
    }

    public Optional<TypedDatum> getResultByIdentifier(String identifier) {
        return Optional.ofNullable(this.results.get(identifier));
    }

    public static final class Builder {
        private final WorkflowFunctionResult product = new WorkflowFunctionResult(true);

        private Builder() {
        }

        public Builder addResult(String name, TypedDatum value) {
            this.product.results.put(name, value);
            return this;
        }

        public WorkflowFunctionResult build() {
            return this.product;
        }
    }
}

