/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.internal;

import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegratorComponent;
import de.rcenvironment.core.configuration.ConfigurationService;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public final class WorkflowIntegrationContext
implements IntegrationContext {
    private ConfigurationService configService;

    public String getContextId() {
        return String.valueOf(UUID.randomUUID().toString()) + "_WORKFLOW";
    }

    public IntegrationContextType getContextType() {
        return IntegrationContextType.WORKFLOW;
    }

    public String getContextTypeString() {
        return IntegrationContextType.WORKFLOW.toString();
    }

    public String getRootPathToToolIntegrationDirectory() {
        return this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT).getAbsolutePath();
    }

    public String getNameOfToolIntegrationDirectory() {
        return String.join((CharSequence)File.separator, "tools", "workflow");
    }

    public String getToolDirectoryPrefix() {
        return "";
    }

    public String getConfigurationFilename() {
        return "configuration.json";
    }

    public String getImplementingComponentClassName() {
        return WorkflowIntegratorComponent.class.getCanonicalName();
    }

    public String getPrefixForComponentId() {
        return "de.rcenvironment.integration.workflow.";
    }

    public String getDefaultComponentGroupId() {
        return "User Integrated Workflows";
    }

    public String[] getDisabledIntegrationKeys() {
        return new String[0];
    }

    public File[] getReadOnlyPathsList() {
        return this.configService.getConfigurablePathList(ConfigurationService.ConfigurablePathListId.READABLE_INTEGRATION_DIRS);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void bindConfigurationService(ConfigurationService service) {
        this.configService = service;
    }

    public Optional<ConfigurationMap> parseConfigurationMap(Map<String, Object> rawConfigurationMap) {
        return Optional.ofNullable(ConfigurationMap.fromMap(rawConfigurationMap));
    }
}

