/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.UncompletedJobsShutdownListener;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorHelpContextProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowScalableFreeformRootEditPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowRunEditorEditPartFactory;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditorContextMenuProvider;
import de.rcenvironment.core.gui.workflow.view.outline.OutlineView;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.PanningSelectionTool;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkflowRunEditor
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor,
SingleWorkflowStateChangeListener {
    private static final Log LOG = LogFactory.getLog(WorkflowRunEditor.class);
    private final DistributedNotificationService notificationService;
    private WorkflowStateNotificationSubscriber workflowStateChangeSubscriber;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private GraphicalViewer viewer;
    private WorkflowExecutionInformation wfExeInfo;
    private AtomicBoolean initialWorkflowStateSet = new AtomicBoolean(false);
    private WorkflowState currentEditorWorkflowState = WorkflowState.UNKNOWN;

    public WorkflowRunEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.registerWorkbenchListener();
        this.notificationService = (DistributedNotificationService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(DistributedNotificationService.class);
    }

    private void registerWorkbenchListener() {
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean arg1) {
                WorkflowRunEditor.this.getSite().getPage().closeEditor((IEditorPart)WorkflowRunEditor.this, false);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public boolean isWorkflowExecutionInformationSet() {
        return this.wfExeInfo != null;
    }

    public WorkflowExecutionInformation getWorkflowExecutionInformation() {
        return this.wfExeInfo;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new WorkflowRunEditorEditPartFactory());
        this.getGraphicalViewer().getControl().setBackground(Display.getDefault().getSystemColor(15));
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null || this.tabbedPropertySheetPage.getControl() == null || this.tabbedPropertySheetPage.getControl().isDisposed()) {
                this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.tabbedPropertySheetPage;
        }
        if (type == IContextProvider.class) {
            return new WorkflowEditorHelpContextProvider(this.viewer);
        }
        if (type == IContentOutlinePage.class) {
            return new OutlineView(this.getGraphicalViewer());
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    private void updateTitle(String title) {
        this.setPartName(title);
    }

    public void updateTitle(WorkflowState workflowState) {
        this.updateTitle(String.valueOf(this.wfExeInfo.getInstanceName()) + ": " + workflowState.getDisplayName());
    }

    public void updateTabIcon(WorkflowState state) {
        Image stateImage = Activator.getInstance().getImageRegistry().get(state.name());
        if (stateImage != null) {
            this.setTitleImage(stateImage);
        } else {
            this.setTitleImage(Activator.getInstance().getImageRegistry().get(WorkflowState.UNKNOWN.name()));
        }
    }

    public void setWorkflowExecutionInformation(WorkflowExecutionInformation wei) {
        this.wfExeInfo = wei;
        if (!this.wfExeInfo.getWorkflowDescription().getConnections().isEmpty() && ((Connection)this.wfExeInfo.getWorkflowDescription().getConnections().get(0)).getBendpoints() == null || !this.wfExeInfo.getWorkflowDescription().getWorkflowLabels().isEmpty() && ((WorkflowLabel)this.wfExeInfo.getWorkflowDescription().getWorkflowLabels().get(0)).getLabelPosition() == null) {
            this.wfExeInfo.getWorkflowDescription().setWorkflowLabels(new ArrayList());
            for (Connection connection : this.wfExeInfo.getWorkflowDescription().getConnections()) {
                connection.setBendpoints(new ArrayList());
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Labels/custom connection paths", (String)"Labels and/or custom connection paths cannot be displayed, as the controller was executed on an RCE instance <= 6.1, which neither supports labels nor custom connection paths.");
        }
        this.viewer.setContents((Object)wei);
        this.workflowStateChangeSubscriber = new WorkflowStateNotificationSubscriber((SingleWorkflowStateChangeListener)this, wei.getExecutionIdentifier());
        Job job = new Job(StringUtils.format((String)"Initializing state of workflow '%s'", (Object[])new Object[]{wei.getInstanceName()})){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    WorkflowRunEditor.this.notificationService.subscribe("rce.component.workflow.state:" + WorkflowRunEditor.this.wfExeInfo.getExecutionIdentifier(), (NotificationSubscriber)WorkflowRunEditor.this.workflowStateChangeSubscriber, (ResolvableNodeId)WorkflowRunEditor.this.wfExeInfo.getNodeId());
                }
                catch (RemoteOperationException e1) {
                    LOG.error((Object)("Failed to subscribe for workflow state changes: " + e1.getMessage()));
                    return Status.CANCEL_STATUS;
                }
                if (!WorkflowRunEditor.this.initialWorkflowStateSet.get()) {
                    WorkflowExecutionService wfExecutionService = (WorkflowExecutionService)ServiceRegistry.createAccessFor((Object)((Object)WorkflowRunEditor.this)).getService(WorkflowExecutionService.class);
                    try {
                        WorkflowState workflowState = wfExecutionService.getWorkflowState(WorkflowRunEditor.this.wfExeInfo.getWorkflowExecutionHandle());
                        WorkflowRunEditor workflowRunEditor = WorkflowRunEditor.this;
                        synchronized (workflowRunEditor) {
                            if (!WorkflowRunEditor.this.initialWorkflowStateSet.get()) {
                                WorkflowRunEditor.this.onWorkflowStateChanged(workflowState);
                            }
                        }
                    }
                    catch (ExecutionControllerException | RemoteOperationException e) {
                        LOG.error((Object)("Failed to subscribe for workflow state changes: " + e.getMessage()));
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void dispose() {
        Job job = new Job("Unsubscribing from workflow host"){

            protected IStatus run(IProgressMonitor monitor) {
                if (WorkflowRunEditor.this.wfExeInfo != null) {
                    try {
                        WorkflowRunEditor.this.notificationService.unsubscribe("rce.component.workflow.state:" + WorkflowRunEditor.this.wfExeInfo.getExecutionIdentifier(), (NotificationSubscriber)WorkflowRunEditor.this.workflowStateChangeSubscriber, (ResolvableNodeId)WorkflowRunEditor.this.wfExeInfo.getNodeId());
                    }
                    catch (RemoteOperationException e) {
                        LOG.error((Object)("Failed to unsubscribe workflow execution view from workflow host: " + e.getMessage()));
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == UncompletedJobsShutdownListener.MUST_BE_COMPLETED_ON_SHUTDOWN_JOB_FAMILY;
            }
        };
        job.setSystem(true);
        job.schedule();
        super.dispose();
    }

    protected void initializeGraphicalViewer() {
        this.viewer = this.getGraphicalViewer();
        WorkflowScalableFreeformRootEditPart rootEditPart = new WorkflowScalableFreeformRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)rootEditPart);
        WorkflowRunEditorContextMenuProvider cmProvider = new WorkflowRunEditorContextMenuProvider(this.viewer);
        this.viewer.setContextMenu((MenuManager)cmProvider);
        this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(zoomManager));
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.viewer.getEditDomain().setDefaultTool((Tool)new PanningSelectionTool());
        this.viewer.getEditDomain().loadDefaultTool();
        this.setTitleImage(Activator.getInstance().getImageRegistry().get(WorkflowState.UNKNOWN.name()));
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return "";
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public synchronized void onWorkflowStateChanged(final WorkflowState newState) {
        this.initialWorkflowStateSet.set(true);
        this.currentEditorWorkflowState = newState;
        if (newState == WorkflowState.DISPOSING || newState == WorkflowState.DISPOSED) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkflowRunEditor.this.getSite().getPage().closeEditor((IEditorPart)WorkflowRunEditor.this, false);
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkflowRunEditor.this.updateTitle(newState);
                    WorkflowRunEditor.this.updateTabIcon(newState);
                    WorkflowRunEditor.this.updateButtonActivation();
                }
            });
        }
    }

    protected void updateButtonActivation() {
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        service.requestEvaluation("de.rcenvironment.runtimeEditorPropertyTester.enableResume");
        service.requestEvaluation("de.rcenvironment.runtimeEditorPropertyTester.enablePause");
        service.requestEvaluation("de.rcenvironment.runtimeEditorPropertyTester.enableCancel");
    }

    public void onWorkflowNotAliveAnymore(String errorMessage) {
        this.onWorkflowStateChanged(WorkflowState.UNKNOWN);
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public WorkflowState getCurrentEditorWorkflowState() {
        return this.currentEditorWorkflowState;
    }
}

