/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;

public class RemoveDynamicInputCommand
extends WorkflowNodeCommand {
    protected String endpointId;
    protected String name;
    protected Refreshable[] refreshable;
    private EndpointDescription oldDesc = null;
    private boolean executable = true;
    private boolean undoable = false;

    public RemoveDynamicInputCommand(String endpointId, String name, Refreshable ... refreshable) {
        this.endpointId = endpointId;
        this.name = name;
        this.refreshable = refreshable;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        if (this.executable) {
            this.oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(this.name);
            if (this.oldDesc != null) {
                EndpointDescriptionsManager inputManager = this.getProperties().getInputDescriptionsManager();
                inputManager.removeDynamicEndpointDescription(this.name);
            }
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        if (this.undoable) {
            if (this.oldDesc != null) {
                EndpointDescriptionsManager inputManager = this.getProperties().getInputDescriptionsManager();
                inputManager.addDynamicEndpointDescription(this.endpointId, this.name, this.oldDesc.getDataType(), this.oldDesc.getMetaData(), this.oldDesc.getIdentifier(), this.oldDesc.getParentGroupName(), true);
            }
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

