/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.common;

import de.rcenvironment.core.component.api.ComponentGroupPathRules;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.IntegrationConstants;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.utils.common.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public final class ComponentDescriptionValidator {
    public static final String ICON_INVALID = "Icon path or file format is invalid. The default icon will be used.";
    private static final String TOOLNAME_INVALID = "The chosen component name is not valid. \n %s";
    private static final String TOOL_NAME_EXISTS = "An integrated component with the name '%s' is already configured within the current RCE profile.\n Note that component names are not case sensitive.";
    private static final String ICON_INVALID_SPACES = "Icon path is invalid. Spaces are allowed, but cannot be the first or last character.";
    private static final String GROUPNAME_INVALID = "The chosen group name is not valid.\n %s";
    private static final String DOC_EXTENSION_NOT_VALID = "Documentation extension not valid. Valid extensions: ";
    private static final String VALID_EXTENSION_SEPERATOR = ", ";
    private static final String DOC_DOES_NOT_EXIST = "Documentation path is invalid.";
    private static final String LIMITATION_INVALID = "Limitation value for parallel executions is invalid.";
    private static final String LIMITATION_MAXIMUM_REACHED = "The maximum limitation value for parallel executions has been reached.";

    public Optional<String> validateName(Text toolNameText, Optional<String> nameOrigin, Collection<? extends String> usedToolnames) {
        Optional validationResult = ComponentIdRules.validateComponentIdRules((String)toolNameText.getText());
        if (validationResult.isPresent()) {
            return Optional.of(StringUtils.format((String)TOOLNAME_INVALID, (Object[])new Object[]{validationResult.get()}));
        }
        String name = toolNameText.getText().trim();
        if (nameOrigin.isPresent() && name.equalsIgnoreCase(nameOrigin.get())) {
            return Optional.empty();
        }
        TreeSet<? extends String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.addAll(usedToolnames);
        if (set.contains(name)) {
            set.removeIf(s -> !s.trim().equalsIgnoreCase(name));
            return Optional.of(StringUtils.format((String)TOOL_NAME_EXISTS, (Object[])new Object[]{set.iterator().next()}));
        }
        return Optional.empty();
    }

    public Optional<String> validateIcon(Text iconText, IntegrationContext context, String componentName) {
        if (iconText.getText() != null && !iconText.getText().isEmpty()) {
            if (iconText.getText().endsWith(" ") || iconText.getText().startsWith(" ")) {
                return Optional.of(ICON_INVALID_SPACES);
            }
            try {
                BufferedImage image;
                File icon = new File(iconText.getText());
                if (!(icon.exists() || icon.isAbsolute() || componentName == null || componentName.isEmpty())) {
                    icon = new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), componentName), iconText.getText());
                }
                if ((image = ImageIO.read(icon)) == null) {
                    return Optional.of(ICON_INVALID);
                }
            }
            catch (IOException iOException) {
                return Optional.of(ICON_INVALID);
            }
        }
        return Optional.empty();
    }

    public Optional<String> validateGroupPath(Text groupPathText) {
        Optional validationResult = ComponentGroupPathRules.validateComponentGroupPathRules((String)groupPathText.getText());
        if (!groupPathText.getText().isEmpty() && validationResult.isPresent()) {
            return Optional.of(StringUtils.format((String)GROUPNAME_INVALID, (Object[])new Object[]{validationResult.get()}));
        }
        return Optional.empty();
    }

    public Optional<String> validateDoc(Text documentationText, IntegrationContext context, String componentName) {
        if (documentationText.getText() != null && !documentationText.getText().isEmpty()) {
            File doc = new File(documentationText.getText());
            if (!(doc.exists() || doc.isAbsolute() || componentName == null || componentName.isEmpty())) {
                doc = new File(new File(new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), componentName), "docs"), documentationText.getText());
            }
            if (doc.exists()) {
                String extension = FilenameUtils.getExtension((String)doc.getAbsolutePath());
                if (!ArrayUtils.contains((Object[])IntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS, (Object)extension.toLowerCase())) {
                    StringBuilder allowedExt = new StringBuilder(DOC_EXTENSION_NOT_VALID);
                    String[] stringArray = IntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS;
                    int n = IntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String current = stringArray[n2];
                        allowedExt.append(String.valueOf(current) + VALID_EXTENSION_SEPERATOR);
                        ++n2;
                    }
                    return Optional.of(allowedExt.toString().substring(0, allowedExt.length() - VALID_EXTENSION_SEPERATOR.length()));
                }
            } else {
                return Optional.of(DOC_DOES_NOT_EXIST);
            }
        }
        return Optional.empty();
    }

    public Optional<String> validateParallelExecution(Text limitExecutionText, Button limitExecutionsButton) {
        if (limitExecutionsButton.getSelection()) {
            if (!limitExecutionText.getText().matches("\\d+")) {
                return Optional.of(LIMITATION_INVALID);
            }
            try {
                Integer.parseInt(limitExecutionText.getText());
                return Optional.empty();
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.of(LIMITATION_MAXIMUM_REACHED);
            }
        }
        return Optional.empty();
    }
}

