/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.impl;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowDescriptionValidationResult;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationBuilder;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationService;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowVerification;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowVerificationServiceImpl
implements WorkflowVerificationService {
    private static final int MAXIMUM_WORKFLOW_PARSE_RETRIES = 5;
    private static final int PARSING_WORKFLOW_FILE_RETRY_INTERVAL = 2000;
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public boolean preValidateWorkflow(TextOutputReceiver outputReceiver, File wfFile, boolean printNonErrorProgressMessages) {
        int retries = 0;
        while (true) {
            WorkflowDescriptionValidationResult validationResult;
            WorkflowDescription workflowDescription;
            try {
                workflowDescription = this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, new HeadlessWorkflowDescriptionLoaderCallback(outputReceiver));
            }
            catch (WorkflowFileException e) {
                this.log.error((Object)("Exception while parsing the workflow file " + wfFile.getAbsolutePath()), (Throwable)e);
                outputReceiver.addOutput(StringUtils.format((String)"Error when parsing '%s': %s (full path: %s)", (Object[])new Object[]{wfFile.getName(), e.getMessage(), wfFile.getAbsolutePath()}));
                return false;
            }
            if (WorkflowExecutionUtils.hasMissingWorkflowNode(workflowDescription.getWorkflowNodes())) {
                if (retries >= 5) {
                    this.log.debug((Object)StringUtils.format((String)"Maximum number of retries (%d) reached while validating the workflow file '%s'", (Object[])new Object[]{5, wfFile.getAbsolutePath()}));
                    outputReceiver.addOutput(StringUtils.format((String)"Workflow component(s) of '%s' unknown (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()}));
                    return false;
                }
                retries = this.waitForWorkflowValidationRetry(retries);
                continue;
            }
            if (printNonErrorProgressMessages) {
                outputReceiver.addOutput(StringUtils.format((String)"Validating target instances of '%s' (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()}));
            }
            if ((validationResult = this.workflowExecutionService.validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(workflowDescription)).isSucceeded()) {
                if (!printNonErrorProgressMessages) break;
                outputReceiver.addOutput(StringUtils.format((String)"Target instance(s) of '%s' validated successfully (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()}));
                break;
            }
            if (retries >= 5) {
                this.log.debug((Object)StringUtils.format((String)"Maximum number of retries (%d) reached while validating the target instances of workflow file '%s'", (Object[])new Object[]{5, wfFile.getAbsolutePath()}));
                outputReceiver.addOutput(StringUtils.format((String)"Some target instance(s) of '%s' unknown: %s (full path: %s)", (Object[])new Object[]{wfFile.getName(), validationResult.toString(), wfFile.getAbsolutePath()}));
                return false;
            }
            retries = this.waitForWorkflowValidationRetry(retries);
        }
        return true;
    }

    private int waitForWorkflowValidationRetry(int retries) {
        this.log.debug((Object)"Retrying workflow validation in a few seconds");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Interrupted while waiting for parsing retry", (Throwable)e);
        }
        return ++retries;
    }

    @Override
    public WorkflowVerificationBuilder getVerificationBuilder() {
        return new WorkflowVerification.Builder().workflowVerificationService(this).workflowExecutionService(this.workflowExecutionService);
    }

    @Reference
    public void bindWorkflowExecutionService(HeadlessWorkflowExecutionService service) {
        this.workflowExecutionService = service;
    }
}

