/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.routing.internal.TopologyLink;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public final class LinkStateAdvertisement
implements Serializable,
Cloneable {
    public static final String REASON_STARTUP = "startup";
    public static final String REASON_SHUTDOWN = "shutdown";
    public static final String REASON_UPDATE = "update";
    private static final long serialVersionUID = -6872824009925812913L;
    private final Collection<TopologyLink> links;
    private final InstanceNodeSessionId owner;
    private String displayName;
    private boolean isWorkflowHost;
    private final long sequenceNumber;
    private final int graphHashCode;
    private final boolean routing;
    private final String reason;

    public LinkStateAdvertisement(InstanceNodeSessionId theOwner, String displayName, boolean isWorkflowHost, long sequenceNumber, int graphChecksum, boolean routing, String reason, Collection<TopologyLink> links) {
        this.owner = theOwner;
        this.displayName = displayName;
        this.isWorkflowHost = isWorkflowHost;
        this.sequenceNumber = sequenceNumber;
        this.links = new HashSet<TopologyLink>(links);
        this.graphHashCode = graphChecksum;
        this.routing = routing;
        this.reason = reason;
    }

    public static LinkStateAdvertisement createUpdateLsa(InstanceNodeSessionId theOwner, String displayName, boolean isWorkflowHost, long sequenceNumber, int graphChecksum, boolean routing, Collection<TopologyLink> links) {
        return new LinkStateAdvertisement(theOwner, displayName, isWorkflowHost, sequenceNumber, graphChecksum, routing, REASON_UPDATE, links);
    }

    public static LinkStateAdvertisement createStartUpLsa(InstanceNodeSessionId theOwner, String displayName, boolean isWorkflowHost, long sequenceNumber, boolean routing, Collection<TopologyLink> links) {
        return new LinkStateAdvertisement(theOwner, displayName, isWorkflowHost, 1L, 0, routing, REASON_STARTUP, links);
    }

    public static LinkStateAdvertisement createShutDownLsa(InstanceNodeSessionId theOwner, String displayName, boolean isWorkflowHost, long sequenceNumber) {
        return new LinkStateAdvertisement(theOwner, displayName, isWorkflowHost, sequenceNumber, 0, false, REASON_SHUTDOWN, new ArrayList<TopologyLink>());
    }

    public LinkStateAdvertisement clone() {
        ArrayList<TopologyLink> copiedLinks = new ArrayList<TopologyLink>();
        for (TopologyLink link : this.links) {
            copiedLinks.add(link.clone());
        }
        LinkStateAdvertisement clone = new LinkStateAdvertisement(this.owner, this.displayName, this.isWorkflowHost, this.sequenceNumber, this.graphHashCode, this.routing, this.reason, copiedLinks);
        return clone;
    }

    public String toString() {
        String result = StringUtils.format((String)"LinkStateAdvertisement(%s): %s [", (Object[])new Object[]{this.getSequenceNumber(), this.getOwner()});
        for (TopologyLink link : this.links) {
            result = StringUtils.format((String)"%s, %s", (Object[])new Object[]{result, link});
        }
        return StringUtils.format((String)"%s]", (Object[])new Object[]{result});
    }

    public Collection<TopologyLink> getLinks() {
        return this.links;
    }

    public InstanceNodeSessionId getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getIsWorkflowHost() {
        return this.isWorkflowHost;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getGraphHashCode() {
        return this.graphHashCode;
    }

    public boolean isRouting() {
        return this.routing;
    }

    public String getReason() {
        return this.reason;
    }
}

