/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerAddDynamicEndpointCommand;
import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerEditDynamicEndpointCommand;
import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerRemoveDynamicEndpointCommand;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.common.configuration.VariableNameVerifyListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class OptimizerEndpointSelectionPane
extends EndpointSelectionPane {
    private EndpointSelectionPane[] allPanes;

    public OptimizerEndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, WorkflowNodeCommand.Executor executor, boolean readOnly) {
        super(title, direction, dynEndpointIdToManage, new String[0], new String[0], executor, readOnly, true);
    }

    protected void fillTable() {
        super.fillTable();
        Display display = Display.getCurrent();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            if (i.getText(0).contains("\u2202")) {
                i.setForeground(display.getSystemColor(16));
            }
            if (i.getText(0).contains("_optimal")) {
                i.setForeground(display.getSystemColor(16));
            }
            ++n2;
        }
    }

    protected void updateButtonActivation() {
        super.updateButtonActivation();
        TableItem[] selection = this.table.getSelection();
        if (selection.length > 0 && (selection[0].getText(0).contains("\u2202") || selection[0].getText(0).contains("_optimal"))) {
            if (this.buttonEdit != null) {
                this.buttonEdit.setEnabled(false);
            }
            if (this.buttonRemove != null) {
                this.buttonRemove.setEnabled(false);
            }
        }
    }

    protected void onAddClicked() {
        OptimizerEndpointEditDialog dialog = new OptimizerEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>());
        super.onAddClicked((EndpointEditDialog)dialog);
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        OptimizerEndpointEditDialog dialog = new OptimizerEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, isStaticEndpoint, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData);
        super.onEditClicked(name, (EndpointEditDialog)dialog);
    }

    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        OptimizerAddDynamicEndpointCommand command = new OptimizerAddDynamicEndpointCommand(this.endpointType, name, this.dynEndpointIdToManage, type, metaData, (Refreshable[])this.allPanes);
        this.execute((WorkflowNodeCommand)command);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        OptimizerEditDynamicEndpointCommand command = new OptimizerEditDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, oldDescription, newDescription, true, true, (Refreshable[])this.allPanes);
        this.execute((WorkflowNodeCommand)command);
    }

    protected void executeRemoveCommand(List<String> names) {
        OptimizerRemoveDynamicEndpointCommand command = new OptimizerRemoveDynamicEndpointCommand(this.endpointType, names, this.dynEndpointIdToManage, (Refreshable[])this.allPanes);
        this.execute((WorkflowNodeCommand)command);
    }

    public EndpointSelectionPane[] getAllPanes() {
        return this.allPanes;
    }

    public void setAllPanes(EndpointSelectionPane[] allPanes) {
        this.allPanes = allPanes;
    }

    protected void removeMetaDataColumns() {
        int i = 2;
        if (this.endpointType == EndpointType.INPUT) {
            i = 4;
        }
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(this.table.getColumnCount() - 1).dispose();
        }
    }

    private class OptimizerEndpointEditDialog
    extends EndpointEditDialog {
        private static final int DIALOG_WIDTH = 325;
        private static final int DIALOG_HEIGHT = 480;

        OptimizerEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
            super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
        }

        protected void createEndpointSettings(Composite parent) {
            super.createEndpointSettings(parent);
            this.textfieldName.addListener(25, (Listener)new VariableNameVerifyListener(2, this.textfieldName));
        }

        protected Point getInitialSize() {
            return new Point(325, 480);
        }

        protected void validateInput() {
            super.validateInput();
            String text = this.textfieldName.getText();
            boolean isValid = this.getButton(0).isEnabled() && text != null && !text.isEmpty() && !text.contains("_");
            this.getButton(0).setEnabled(isValid);
        }
    }
}

