/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.dakota.execution.internal;

import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.dakota.execution.internal.DakotaConstants;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class DakotaAlgorithm
extends OptimizerAlgorithmExecutor {
    private static final String NAN = "NaN";
    private static final String APOSTROPHE = "'";
    private static final String INPUT_ARGUMENT = " -input ";
    private static final String RESTART_FILE_ARGUMENT = " -read_restart ";
    private static final Object LOCK_OBJECT = new Object();
    private static final double RESULT_EPS = 1.0E-9;
    private File dakotaExecutablePath = null;
    private Map<String, TypedDatum> outputValues;
    private Collection<String> input;
    private Map<String, MethodDescription> methodConfigurations;
    private String algorithm;
    private String[] variableOrderForWholeExecution;
    private int currentActiveSetVectorNumber = 0;
    private String[] constraintOrder;
    private Map<String, Double> upperMap;
    private Map<String, Double> lowerMap;
    private File dakotaInputFile;
    private FileReferenceTD dakotaInputFileReference;
    private Map<String, Double> stepValues;

    public DakotaAlgorithm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DakotaAlgorithm(Map<String, MethodDescription> methodConfigurations, Map<String, TypedDatum> outputValues, Collection<String> input2, ComponentContext compContext, Map<String, Double> upperMap, Map<String, Double> lowerMap, Map<String, Double> stepValues) throws ComponentException {
        super(compContext, "dakotaInput.in", "results.out");
        this.typedDatumFactory = ((TypedDatumService)compContext.getService(TypedDatumService.class)).getFactory();
        ConfigurationService confService = (ConfigurationService)compContext.getService(ConfigurationService.class);
        this.algorithm = compContext.getConfigurationValue("algorithm");
        this.outputValues = outputValues;
        this.input = input2;
        this.methodConfigurations = methodConfigurations;
        this.upperMap = upperMap;
        this.lowerMap = lowerMap;
        this.stepValues = stepValues;
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (Boolean.parseBoolean(compContext.getConfigurationValue("CustomDakotaPath"))) {
                this.dakotaExecutablePath = new File(compContext.getConfigurationValue("dakotaExecPath"));
                if (!(this.dakotaExecutablePath.exists() && this.dakotaExecutablePath.isFile() && this.dakotaExecutablePath.canExecute())) {
                    this.dakotaExecutablePath = null;
                    compContext.getLog().componentInfo("Dakota binary not found at user specified location. Switching to default location");
                }
            }
            if (this.dakotaExecutablePath == null) {
                try {
                    this.dakotaExecutablePath = confService.getUnpackedFilesLocation("dakota");
                    if (OS.isFamilyWindows()) {
                        this.dakotaExecutablePath = new File(this.dakotaExecutablePath, "dakota.exe");
                    } else if (OS.isFamilyUnix()) {
                        this.dakotaExecutablePath = new File(this.dakotaExecutablePath, "dakota");
                    }
                    this.dakotaExecutablePath.setExecutable(true);
                }
                catch (ConfigurationException e) {
                    LOGGER.error((Object)("Exception getting dakota executable path: " + e.toString()));
                    throw new ComponentException("Could not find dakota binaries.");
                }
            }
        }
        this.workingDir.setExecutable(true);
        LOGGER.debug((Object)("Dakota executable path: " + this.dakotaExecutablePath));
    }

    protected void prepareProblem() throws ComponentException {
        this.createScript();
        this.createDakotaInputFile();
    }

    protected void writeInputFileforExternalProgram(Map<String, Double> functionVariables, Map<String, Double> functionVariablesGradients, Map<String, Double> constraintVariables, String outputFileName) throws IOException {
        File fo = new File(String.valueOf(this.messageFromClient.getCurrentWorkingDir()) + File.separatorChar + outputFileName);
        fo.createNewFile();
        FileWriter fw2 = new FileWriter(fo);
        LinkedList<String> keyQueue = new LinkedList<String>();
        for (String key : functionVariables.keySet()) {
            if ((this.currentActiveSetVectorNumber & 1) != 0) {
                String variableName = key;
                if (variableName.indexOf("_") > -1 && this.compContext.getInputs().contains(variableName.substring(0, variableName.indexOf("_")))) {
                    variableName = variableName.substring(0, variableName.indexOf("_"));
                }
                fw2.append("       ");
                if (this.compContext.getInputMetaDataValue(variableName, "goal").equals("Maximize")) {
                    fw2.append("-");
                }
                if (functionVariables.get(key).isNaN()) {
                    fw2.append(NAN);
                } else {
                    fw2.append(functionVariables.get(key) + " ");
                }
                fw2.append(IOUtils.LINE_SEPARATOR);
            }
            keyQueue.offer(key);
        }
        if (this.constraintOrder != null) {
            String[] stringArray = this.constraintOrder;
            int n = this.constraintOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if ((this.currentActiveSetVectorNumber & 1) != 0) {
                    if (constraintVariables.get(element).isNaN()) {
                        fw2.append("       NaN");
                    } else {
                        fw2.append("       " + constraintVariables.get(element) + " ");
                    }
                    fw2.append(IOUtils.LINE_SEPARATOR);
                }
                keyQueue.offer(element);
                ++n2;
            }
        }
        while (!keyQueue.isEmpty()) {
            String key;
            key = (String)keyQueue.poll();
            if ((this.currentActiveSetVectorNumber & 2) == 0) continue;
            fw2.append("[");
            String[] stringArray = this.variableOrderForWholeExecution;
            int n = this.variableOrderForWholeExecution.length;
            int n3 = 0;
            while (n3 < n) {
                String element = stringArray[n3];
                String gradientName = "\u2202" + key + "." + "\u2202" + element;
                if (this.compContext.getInputDataType(gradientName) == DataType.Vector) {
                    int j = 0;
                    while (j < Integer.valueOf(this.compContext.getOutputMetaDataValue(gradientName.substring(gradientName.lastIndexOf("\u2202") + 1), "vectorSize"))) {
                        if (functionVariablesGradients.containsKey(String.valueOf(gradientName) + "_" + j)) {
                            if (functionVariablesGradients.get(String.valueOf(gradientName) + "_" + j).isNaN()) {
                                fw2.append("       NaN");
                            } else {
                                fw2.append("       " + functionVariablesGradients.get(String.valueOf(gradientName) + "_" + j));
                            }
                        }
                        ++j;
                    }
                } else if (functionVariablesGradients.containsKey(gradientName)) {
                    if (functionVariablesGradients.get(gradientName).isNaN()) {
                        fw2.append("       NaN");
                    } else {
                        fw2.append("       " + functionVariablesGradients.get(gradientName));
                    }
                }
                ++n3;
            }
            fw2.append(" ]" + IOUtils.LINE_SEPARATOR);
        }
        fw2.flush();
        fw2.close();
    }

    public void readOutputFileFromExternalProgram(Map<String, TypedDatum> outputValueMap) throws IOException {
        block23: {
            File paramsFile = null;
            if (this.messageFromClient != null && this.messageFromClient.getCurrentWorkingDir() != null) {
                File cwd = new File(this.messageFromClient.getCurrentWorkingDir());
                if (cwd.listFiles() != null) {
                    File[] fileArray = cwd.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getAbsolutePath().endsWith("params.in")) {
                            paramsFile = f;
                        }
                        ++n2;
                    }
                }
                Throwable throwable = null;
                Object var5_8 = null;
                try (BufferedReader fr = new BufferedReader(new FileReader(paramsFile));){
                    String firstLineString = fr.readLine();
                    if (firstLineString == null) break block23;
                    String[] firstLine = firstLineString.split("\\s+");
                    int varCount = 0;
                    if (firstLine != null) {
                        try {
                            varCount = Integer.parseInt(firstLine[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Failed to parse parameters file", e);
                        }
                    }
                    HashMap<String, Double> newOutput = new HashMap<String, Double>();
                    int i = 0;
                    while (i < varCount) {
                        String[] xStrg;
                        String x = fr.readLine().trim();
                        if (x != null && (xStrg = x.split(" ", 2)) != null) {
                            if (!xStrg[0].contains("nan")) {
                                newOutput.put(xStrg[1], Double.parseDouble(xStrg[0]));
                            } else {
                                newOutput.put(xStrg[1], Double.NaN);
                            }
                        }
                        ++i;
                    }
                    String asvLineString = fr.readLine();
                    if (asvLineString != null) {
                        String[] asvLine = asvLineString.split(" ");
                        int j = 0;
                        while (asvLine != null && asvLine[j].isEmpty()) {
                            ++j;
                        }
                        this.currentActiveSetVectorNumber = asvLine != null ? Integer.parseInt(asvLine[j]) : 0;
                        fr.close();
                        outputValueMap.clear();
                        for (String key : newOutput.keySet()) {
                            this.processOutput(outputValueMap, newOutput, key);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void processOutput(Map<String, TypedDatum> outputValueMap, Map<String, Double> newOutput, String key) {
        if (key.contains("_")) {
            String variableName = key.substring(0, key.lastIndexOf("_"));
            if (this.compContext.getOutputs().contains(variableName) && this.compContext.getOutputDataType(variableName) == DataType.Vector) {
                if (!outputValueMap.containsKey(variableName)) {
                    VectorTD vector = this.typedDatumFactory.createVector(Integer.parseInt(this.compContext.getOutputMetaDataValue(variableName, "vectorSize")));
                    int i = 0;
                    while (i < vector.getRowDimension()) {
                        vector.setFloatTDForElement(this.typedDatumFactory.createFloat(newOutput.get(String.valueOf(variableName) + "_" + i).doubleValue()), i);
                        ++i;
                    }
                    outputValueMap.put(variableName, (TypedDatum)vector);
                }
            } else {
                outputValueMap.put(key, (TypedDatum)this.typedDatumFactory.createFloat(newOutput.get(key).doubleValue()));
            }
        }
        outputValueMap.put(key, (TypedDatum)this.typedDatumFactory.createFloat(newOutput.get(key).doubleValue()));
    }

    public int getOptimalRunNumber() {
        File output = new File(this.workingDir.getAbsolutePath(), "consoleStdOutput.txt");
        HashMap<String, Double> results = new HashMap<String, Double>();
        try {
            List outputLines = FileUtils.readLines((File)output);
            boolean readParameters = false;
            for (String s : outputLines) {
                String[] resultLine;
                if (s.startsWith("<<<<< Best data captured at function evaluation ")) {
                    return Integer.parseInt(s.substring("<<<<< Best data captured at function evaluation ".length()));
                }
                if (s.startsWith("<<<<< Best objective function")) {
                    readParameters = false;
                }
                if (readParameters && (resultLine = s.split("\\s+")) != null && resultLine.length == 3) {
                    results.put(resultLine[2], Double.parseDouble(resultLine[1]));
                }
                if (!s.startsWith("<<<<< Best parameters")) continue;
                readParameters = true;
            }
            for (Integer iteration : this.iterationData.keySet()) {
                Map iterationValues = (Map)this.iterationData.get(iteration);
                boolean containsAll = true;
                for (String variable : results.keySet()) {
                    if (!(Math.abs(((Double)iterationValues.get(variable) - (Double)results.get(variable)) / (Double)iterationValues.get(variable)) > 1.0E-9) && !Double.isNaN((Double)iterationValues.get(variable))) continue;
                    containsAll = false;
                }
                if (!containsAll) continue;
                return iteration;
            }
        }
        catch (IOException iOException) {
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    @TaskDescription(value="Optimizer Algorithm Executor Dakota")
    public void run() {
        String command = this.dakotaExecutablePath.getAbsolutePath();
        if (this.compContext.getConfigurationValue("usePrecalculation") != null && Boolean.parseBoolean(this.compContext.getConfigurationValue("usePrecalculation")) && (this.compContext.getConfigurationValue("isNestedLoop_5e0ed1cd") == null || !Boolean.parseBoolean(this.compContext.getConfigurationValue("isNestedLoop_5e0ed1cd")))) {
            command = String.valueOf(command) + " -read_restart \"" + new File(this.compContext.getConfigurationValue("preCalcFilePath")).getAbsolutePath() + "\" ";
        }
        command = String.valueOf(command) + INPUT_ARGUMENT;
        try {
            if (!this.initFailed.get()) {
                this.startProgram(command);
            }
        }
        catch (ComponentException e) {
            this.startFailed.set(true);
            this.startFailedException = e;
        }
        this.stop();
    }

    private void createDakotaInputFile() throws ComponentException {
        try {
            this.createScript();
            this.createValueAndConstraintOrders();
            boolean isSurrogate = this.algorithm.split(",").length > 1 && this.algorithm.split(",")[0].equalsIgnoreCase("Dakota Surrogate-Based Local");
            HashMap<String, String> valuesForSampleFile = new HashMap<String, String>();
            MethodDescription description = this.methodConfigurations.get(this.algorithm.split(",")[0]);
            valuesForSampleFile.put("%%METHOD_CODE%%", description.getMethodCode());
            valuesForSampleFile.put("%%METHOD_PROPERTIES%%", String.valueOf(this.createMethodsProperties(description.getCommonSettings())) + DakotaConstants.NEWLINE + this.createMethodsProperties(description.getSpecificSettings()));
            if (isSurrogate) {
                MethodDescription description2 = this.methodConfigurations.get(this.algorithm.split(",")[1]);
                valuesForSampleFile.put("%%METHOD_2_CODE%%", description2.getMethodCode());
                valuesForSampleFile.put("%%METHOD_2_PROPERTIES%%", String.valueOf(this.createMethodsProperties(description2.getCommonSettings())) + DakotaConstants.NEWLINE + this.createMethodsProperties(description2.getSpecificSettings()));
                MethodDescription description3 = this.methodConfigurations.get(this.algorithm.split(",")[2]);
                valuesForSampleFile.put("%%METHOD_3_CODE%%", description3.getMethodCode());
                valuesForSampleFile.put("%%METHOD_3_PROPERTIES%%", String.valueOf(this.createMethodsProperties(description3.getCommonSettings())) + DakotaConstants.NEWLINE + this.createMethodsProperties(description3.getSpecificSettings()));
            }
            this.writeContinousDesignVariables(valuesForSampleFile);
            this.writeDiscreteDesignVariables(valuesForSampleFile);
            if (OS.isFamilyWindows()) {
                valuesForSampleFile.put("%%DRIVER_FOR_OS%%", "'dakotaBlackBox.bat'");
            } else if (OS.isFamilyUnix()) {
                valuesForSampleFile.put("%%DRIVER_FOR_OS%%", "'dakotaBlackBox.sh'");
            }
            valuesForSampleFile.put("%%WORKDIR%%", String.valueOf(this.inputFileName) + "workdir'");
            valuesForSampleFile.put("%%OBJECTIVE_FUNCTIONS_COUNT%%", "" + this.countInput(this.input));
            valuesForSampleFile.put("%%OBJECTIVES_WEIGHT%%", this.getWeightString());
            valuesForSampleFile.put("%%CONSTRAINT_COUNT%%", "" + this.countConstraint(this.input));
            valuesForSampleFile.put("%%CONSTRAINT_LOWER%%", this.getConstraintBoundString("lower"));
            valuesForSampleFile.put("%%CONSTRAINT_UPPER%%", this.getConstraintBoundString("upper"));
            valuesForSampleFile.put("%%GRADIENT_SECTION%%", this.getGradientString(this.methodConfigurations.get(this.algorithm.split(",")[0])));
            if (isSurrogate) {
                valuesForSampleFile.put("%%GRADIENT_2_SECTION%%", this.getGradientString(this.methodConfigurations.get(this.algorithm.split(",")[2])));
            }
            String filePath = "/resources/dakota_standard.sample";
            if (isSurrogate) {
                filePath = "/resources/dakota_surrogate.sample";
            }
            String content = this.replacePlaceholderInSamplefile(filePath, valuesForSampleFile);
            this.dakotaInputFile = new File(String.valueOf(this.workingDir.getAbsolutePath()) + File.separator + this.inputFileName);
            this.dakotaInputFile.createNewFile();
            FileUtils.writeStringToFile((File)this.dakotaInputFile, (String)content);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create input file for Dakota", (Throwable)e);
        }
    }

    private void writeContinousDesignVariables(Map<String, String> valuesForSampleFile) {
        int cdvCount = this.countOutputs(false);
        if (cdvCount > 0) {
            valuesForSampleFile.put("%%CONTINUOUS_DESIGN_COUNT%%", "" + cdvCount);
        } else {
            valuesForSampleFile.put("%%CONTINUOUS_DESIGN_COUNT%%", "");
        }
        String startValuesString = this.createString(true, false);
        valuesForSampleFile.put("%%CDV_INITIAL_POINT%%", startValuesString);
        valuesForSampleFile.put("%%CDV_LOWER_BOUNDS%%", this.getDVBounds("lower", false));
        valuesForSampleFile.put("%%CDV_UPPER_BOUNDS%%", this.getDVBounds("upper", false));
        String dvNames = this.createString(false, false);
        valuesForSampleFile.put("%%CDV_NAMES%%", dvNames);
    }

    private void writeDiscreteDesignVariables(Map<String, String> valuesForSampleFile) {
        int ddvCount = this.countOutputs(true);
        if (ddvCount > 0) {
            valuesForSampleFile.put("%%DISCRETE_DESIGN_COUNT%%", "" + ddvCount);
        } else {
            valuesForSampleFile.put("%%DISCRETE_DESIGN_COUNT%%", "");
        }
        String startValuesString = this.createString(true, true);
        valuesForSampleFile.put("%%DDV_INITIAL_POINT%%", startValuesString);
        valuesForSampleFile.put("%%DDV_LOWER_BOUNDS%%", this.getDVBounds("lower", true));
        valuesForSampleFile.put("%%DDV_UPPER_BOUNDS%%", this.getDVBounds("upper", true));
        String dvNames = this.createString(false, true);
        valuesForSampleFile.put("%%DDV_NAMES%%", dvNames);
    }

    private String createString(boolean readFromMap, boolean isDiscrete) {
        String resultString = "";
        int i = 0;
        while (i < this.variableOrderForWholeExecution.length) {
            boolean discrete = false;
            String variableName = this.variableOrderForWholeExecution[i];
            if (!this.compContext.getOutputs().contains(this.variableOrderForWholeExecution[i]) && this.variableOrderForWholeExecution[i].contains("_")) {
                variableName = this.variableOrderForWholeExecution[i].substring(0, this.variableOrderForWholeExecution[i].lastIndexOf("_"));
            }
            if (this.compContext.getOutputMetaDataValue(variableName, "isDiscrete") != null && Boolean.parseBoolean(this.compContext.getOutputMetaDataValue(variableName, "isDiscrete"))) {
                discrete = true;
            }
            if (isDiscrete == discrete) {
                if (this.outputValues.get(this.variableOrderForWholeExecution[i]).getDataType() == DataType.Vector) {
                    int j = 0;
                    while (j < Integer.parseInt(this.compContext.getOutputMetaDataValue(this.variableOrderForWholeExecution[i], "vectorSize"))) {
                        resultString = readFromMap ? String.valueOf(resultString) + "\t" + ((VectorTD)this.outputValues.get(this.variableOrderForWholeExecution[i])).getFloatTDOfElement(j) : String.valueOf(resultString) + "\t'" + this.variableOrderForWholeExecution[i] + "_" + j + APOSTROPHE;
                        ++j;
                    }
                } else {
                    resultString = readFromMap ? String.valueOf(resultString) + "\t" + this.outputValues.get(this.variableOrderForWholeExecution[i]) : String.valueOf(resultString) + "\t'" + this.variableOrderForWholeExecution[i] + APOSTROPHE;
                }
            }
            ++i;
        }
        return resultString;
    }

    private int countOutputs(boolean discrete) {
        int count = 0;
        for (String e : this.outputValues.keySet()) {
            boolean isDiscrete = false;
            String variableName = e;
            if (!this.compContext.getOutputs().contains(e) && e.contains("_")) {
                variableName = e.substring(0, e.lastIndexOf("_"));
            }
            if (this.compContext.getOutputMetaDataValue(variableName, "isDiscrete") != null && Boolean.parseBoolean(this.compContext.getOutputMetaDataValue(variableName, "isDiscrete"))) {
                isDiscrete = true;
            }
            if (discrete != isDiscrete) continue;
            if (this.compContext.getOutputDataType(e) == DataType.Vector) {
                count += Integer.valueOf(this.compContext.getOutputMetaDataValue(e, "vectorSize")).intValue();
                continue;
            }
            ++count;
        }
        return count;
    }

    private String replacePlaceholderInSamplefile(String filePath, Map<String, String> valuesForSampleFile) throws IOException {
        String content = IOUtils.toString((InputStream)DakotaAlgorithm.class.getResourceAsStream(filePath));
        String[] splitted = content.split(DakotaConstants.NEWLINE);
        for (String key : valuesForSampleFile.keySet()) {
            if (valuesForSampleFile.get(key) == null || valuesForSampleFile.get(key).isEmpty()) {
                String[] stringArray = splitted;
                int n = splitted.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.contains(key)) {
                        content = content.replace(s, "");
                    }
                    ++n2;
                }
                continue;
            }
            content = content.replaceAll(key, valuesForSampleFile.get(key));
        }
        return content;
    }

    private void createValueAndConstraintOrders() {
        int position = 0;
        this.variableOrderForWholeExecution = new String[this.outputValues.size()];
        LinkedList<String> ordered = new LinkedList<String>(this.outputValues.keySet());
        Collections.sort(ordered);
        for (String key : ordered) {
            this.variableOrderForWholeExecution[position++] = key;
        }
        this.constraintOrder = new String[this.countConstraint(this.input)];
        int nextFreePosition = 0;
        LinkedList<String> orderedInput = new LinkedList<String>(this.input);
        Collections.sort(orderedInput);
        for (String e : orderedInput) {
            if (e.contains("\u2202") || !this.compContext.getDynamicInputIdentifier(e).equals("Constraint")) continue;
            this.constraintOrder[nextFreePosition++] = e;
        }
    }

    private String getDVBounds(String boundType, boolean isDiscrete) {
        String result = "";
        Map<String, Double> boundValues = null;
        boundValues = boundType == "lower" ? this.lowerMap : this.upperMap;
        int i = 0;
        while (i < this.variableOrderForWholeExecution.length) {
            boolean discrete = false;
            String variableName = this.variableOrderForWholeExecution[i];
            if (!this.compContext.getOutputs().contains(this.variableOrderForWholeExecution[i]) && this.variableOrderForWholeExecution[i].contains("_")) {
                variableName = this.variableOrderForWholeExecution[i].substring(0, this.variableOrderForWholeExecution[i].lastIndexOf("_"));
            }
            if (this.compContext.getOutputMetaDataValue(variableName, "isDiscrete") != null && Boolean.parseBoolean(this.compContext.getOutputMetaDataValue(variableName, "isDiscrete"))) {
                discrete = true;
            }
            if (discrete == isDiscrete) {
                if (this.compContext.getOutputDataType(this.variableOrderForWholeExecution[i]) == DataType.Vector) {
                    int j = 0;
                    while (j < Integer.parseInt(this.compContext.getOutputMetaDataValue(this.variableOrderForWholeExecution[i], "vectorSize"))) {
                        result = String.valueOf(result) + "\t" + boundValues.get(String.valueOf(this.variableOrderForWholeExecution[i]) + "_" + j);
                        ++j;
                    }
                } else {
                    result = String.valueOf(result) + "\t" + boundValues.get(this.variableOrderForWholeExecution[i]);
                }
            }
            ++i;
        }
        return result;
    }

    private String getWeightString() {
        String weights = "";
        for (String e : this.input) {
            if (!this.compContext.getDynamicInputIdentifier(e).equals("Objective") || e.contains("\u2202") || this.compContext.getInputMetaDataValue(e, "weight").equals("-")) continue;
            if (this.compContext.getInputDataType(e) == DataType.Vector) {
                int vectorSize = Integer.parseInt(this.compContext.getInputMetaDataValue(e, "vectorSize"));
                int i = 0;
                while (i < vectorSize) {
                    weights = String.valueOf(weights) + this.compContext.getInputMetaDataValue(e, "weight") + " ";
                    ++i;
                }
                continue;
            }
            weights = String.valueOf(weights) + this.compContext.getInputMetaDataValue(e, "weight") + " ";
        }
        return weights;
    }

    private String getConstraintBoundString(String type) {
        String result = "";
        Map<String, Double> boundValues = null;
        boundValues = type == "lower" ? this.lowerMap : this.upperMap;
        String[] stringArray = this.constraintOrder;
        int n = this.constraintOrder.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            for (String e : this.input) {
                if (!e.equals(element) || !this.compContext.getDynamicInputIdentifier(e).equals("Constraint")) continue;
                if (!e.contains("\u2202") && this.compContext.getInputDataType(e) == DataType.Vector) {
                    int vectorSize = Integer.parseInt(this.compContext.getInputMetaDataValue(e, "vectorSize"));
                    int j = 0;
                    while (j < vectorSize) {
                        result = String.valueOf(result) + boundValues.get(String.valueOf(e) + "_" + j) + " ";
                        ++j;
                    }
                    continue;
                }
                result = String.valueOf(result) + boundValues.get(e) + " ";
            }
            ++n2;
        }
        return result;
    }

    private String getGradientString(MethodDescription description) throws IOException {
        HashMap<String, String> gradientStrings = new HashMap<String, String>();
        String gradients = "";
        if (description.getResponsesSettings() != null && description.getResponsesSettings().get("gradients") != null) {
            Map respSettings = description.getResponsesSettings();
            String gradientValue = (String)((Map)respSettings.get("gradients")).get("Value");
            if (gradientValue == null || gradientValue.equals("")) {
                gradientValue = (String)((Map)respSettings.get("gradients")).get("DefaultValue");
            }
            if (gradientValue.equalsIgnoreCase("numerical_gradients")) {
                String intervalValue = (String)((Map)respSettings.get("interval_type")).get("Value");
                if (intervalValue == null || intervalValue.equals("")) {
                    intervalValue = (String)((Map)respSettings.get("interval_type")).get("DefaultValue");
                }
                gradientStrings.put("%%INTERVAL_TYPE%%", intervalValue);
                String stepSizeValue = (String)((Map)respSettings.get("fd_gradient_step_size")).get("Value");
                if (stepSizeValue == null || stepSizeValue.equals("")) {
                    stepSizeValue = (String)((Map)respSettings.get("fd_gradient_step_size")).get("DefaultValue");
                }
                gradientStrings.put("%%GRADIENT_STEP_SIZE%%", stepSizeValue);
                String hessiansValue = (String)((Map)respSettings.get("hessians")).get("Value");
                if (hessiansValue == null || hessiansValue.equals("")) {
                    hessiansValue = (String)((Map)respSettings.get("hessians")).get("DefaultValue");
                }
                gradientStrings.put("%%HESSIANS_VALUE%%", hessiansValue);
                if (!hessiansValue.equals("no_hessians")) {
                    String hessianIntervalValue = (String)((Map)respSettings.get("interval_type_hessian")).get("Value");
                    if (hessianIntervalValue == null || hessianIntervalValue.equals("")) {
                        hessianIntervalValue = (String)((Map)respSettings.get("interval_type_hessian")).get("DefaultValue");
                    }
                    gradientStrings.put("%%HESSIAN_INTERVALL%%", hessianIntervalValue);
                    String hessianStepValue = (String)((Map)respSettings.get("fd_hessian_step_size")).get("Value");
                    if (hessianStepValue == null || hessianStepValue.equals("")) {
                        hessianStepValue = (String)((Map)respSettings.get("fd_hessian_step_size")).get("DefaultValue");
                    }
                    gradientStrings.put("%%HESSIAN_STEP_SIZE%%", hessianStepValue);
                }
                gradientStrings.put("%%GRADIENTS%%", this.replacePlaceholderInSamplefile("/resources/dakota_gradients.sample", gradientStrings));
                if (!((String)gradientStrings.get("%%HESSIANS_VALUE%%")).equals("no_hessians")) {
                    gradientStrings.put("%%HESSIANS%%", this.replacePlaceholderInSamplefile("/resources/dakota_hessians.sample", gradientStrings));
                } else {
                    gradientStrings.put("%%HESSIANS%%", "no_hessians");
                }
            } else {
                gradientStrings.put("%%GRADIENTS%%", "analytic_gradients");
                gradientStrings.put("%%HESSIANS%%", "no_hessians");
            }
        } else {
            gradientStrings.put("%%GRADIENTS%%", "no_gradients");
            gradientStrings.put("%%HESSIANS%%", "no_hessians");
        }
        gradients = this.replacePlaceholderInSamplefile("/resources/dakota_gradients_base.sample", gradientStrings);
        return gradients;
    }

    private String createMethodsProperties(Map<String, Map<String, String>> settingsType) throws IOException {
        String methodProperties = "";
        Iterator<String> iterator = settingsType.keySet().iterator();
        while (iterator.hasNext()) {
            Map<String, Map<String, String>> settings = settingsType;
            String attributeKey = iterator.next();
            if (settings.get(attributeKey).get("doNotWrite") != null && settings.get(attributeKey).get("doNotWrite").equalsIgnoreCase("true")) continue;
            String value = settings.get(attributeKey).get("Value");
            if (value == null || value.equals("")) {
                value = settings.get(attributeKey).get("DefaultValue");
            }
            if (settings.get(attributeKey).get("dataType").equalsIgnoreCase("BOOL")) {
                if (value.equalsIgnoreCase("true")) {
                    methodProperties = String.valueOf(methodProperties) + "\t" + attributeKey;
                }
            } else if (!value.equalsIgnoreCase("")) {
                methodProperties = !(settings.get(attributeKey).get("NoKeyword") != null && settings.get(attributeKey).get("NoKeyword").equalsIgnoreCase("true") || attributeKey.equalsIgnoreCase("output") && value.equalsIgnoreCase("normal")) ? String.valueOf(methodProperties) + "\t" + attributeKey + " = " : String.valueOf(methodProperties) + " ";
                if (!attributeKey.equalsIgnoreCase("output") || !value.equalsIgnoreCase("normal")) {
                    methodProperties = settings.get(attributeKey).get("dataType").equalsIgnoreCase("String") ? String.valueOf(methodProperties) + "\"" + value + "\"" : String.valueOf(methodProperties) + value;
                }
            }
            if (settings.get(attributeKey).get("NoLinebreak") != null && settings.get(attributeKey).get("NoLinebreak").equalsIgnoreCase("true")) continue;
            methodProperties = String.valueOf(methodProperties) + DakotaConstants.NEWLINE;
        }
        return methodProperties;
    }

    private void createScript() {
        try {
            if (OS.isFamilyWindows()) {
                File bat = new File(String.valueOf(this.workingDir.getAbsolutePath()) + File.separator + "dakotaBlackBox.bat");
                FileWriter fw = new FileWriter(bat);
                fw.append("\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw.exe\" -jar " + this.workingDir.getAbsolutePath() + File.separator + "de.rcenvironment.components.optimizer.simulator.jar \"%CD%\" \"%1\"");
                fw.flush();
                fw.close();
            } else if (OS.isFamilyUnix()) {
                File sh = new File(this.workingDir + File.separator + "dakotaBlackBox.sh");
                FileWriter fw = new FileWriter(sh);
                fw.append("#!/bin/bash \n" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + " -jar " + this.workingDir.getAbsolutePath() + File.separator + "de.rcenvironment.components.optimizer.simulator.jar" + " `pwd` $1 \n");
                fw.append("echo $? \n");
                fw.flush();
                fw.close();
                sh.setExecutable(true);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    public boolean getDerivativedNeeded() {
        return (this.currentActiveSetVectorNumber & 2) != 0;
    }

    public void writeHistoryDataItem(OptimizerComponentHistoryDataItem historyItem) {
        if (historyItem != null) {
            if (this.dakotaInputFileReference == null) {
                try {
                    this.dakotaInputFileReference = ((ComponentDataManagementService)this.compContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.compContext, this.dakotaInputFile, "dakotaInput.in");
                }
                catch (IOException e) {
                    String errorMessage = "Failed to store Dakota input file into the data management; it is not available in the workflow data browser";
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                    this.compContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
                }
            }
            if (this.dakotaInputFileReference != null) {
                historyItem.setInputFileReference(this.dakotaInputFileReference.getFileReference());
            }
            try {
                String restartFileReference = ((ComponentDataManagementService)this.compContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.compContext, new File(this.workingDir, "dakota.rst"), "dakota.rst").getFileReference();
                historyItem.setRestartFileReference(restartFileReference);
            }
            catch (IOException e) {
                String errorMessage = "Failed to store Dakota restart file into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                this.compContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
    }
}

