/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.legacy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

@Deprecated
public abstract class FileSupport {
    private static final int EOF_INDICATOR = -1;
    private static final int BUFFER_SIZE = 8192;

    private FileSupport() {
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                boolean success = FileSupport.deleteFile(f);
                if (!success) {
                    return false;
                }
                ++n2;
            }
        }
        return file.delete();
    }

    public static byte[] zip(File file) throws IOException, InterruptedException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteOut);
        FileSupport.zip(file, file, zipOut);
        zipOut.close();
        byte[] result = byteOut.toByteArray();
        return result;
    }

    public static void zipToFile(File file, File zip) throws IOException, InterruptedException {
        if (!zip.exists()) {
            zip.createNewFile();
        }
        FileOutputStream fileOut = new FileOutputStream(zip);
        ZipOutputStream zipOut = new ZipOutputStream(fileOut);
        FileSupport.zip(file, file, zipOut);
        zipOut.close();
    }

    public static void zip(File file, File base, ZipOutputStream out) throws IOException, InterruptedException {
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("File does not exist or can not be read.");
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
        if (file.isDirectory()) {
            File[] subFiles;
            File[] fileArray = subFiles = file.listFiles();
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                FileSupport.zip(subFile, base, out);
                ++n2;
            }
        } else {
            int read;
            FileInputStream in = new FileInputStream(file);
            ZipEntry entry = new ZipEntry(file.getPath().substring(base.getPath().length() + 1));
            out.putNextEntry(entry);
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static void unzip(byte[] zip, File target) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(zip);
        FileSupport.unzip(inputStream, target);
    }

    public static void unzip(InputStream inputStream, File target) throws IOException {
        ZipEntry entry;
        ZipInputStream input = new ZipInputStream(inputStream);
        while ((entry = input.getNextEntry()) != null) {
            int count;
            byte[] data = new byte[8192];
            File file = new File(target, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File parent = file.getParentFile();
            parent.mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            while ((count = input.read(data, 0, 8192)) != -1) {
                out.write(data, 0, count);
            }
            out.close();
        }
        input.close();
    }
}

