/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui;

import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.gui.utils.incubator.Sleak;
import de.rcenvironment.core.start.common.InstanceRunner;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.gui.WorkspaceSettings;
import de.rcenvironment.core.start.gui.internal.ApplicationWorkbenchAdvisor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.misc.Policy;
import org.osgi.framework.Version;

public final class GUIInstanceRunner
extends InstanceRunner {
    private static final int MAX_RECENT_WORKSPACES_HISTORY = 5;
    private static final boolean ALLOW_WORKSPACE_CHOOSER_SUPPRESSION = true;
    private static final int GUI_STARTUP_READINESS_POLLING_INTERVAL_MSEC = 250;
    private static final String DRCE_DEBUG_SLEAK = "rce.debug.sleak";
    private static boolean tryWorkspaceChoosingAgain = false;
    private final CountDownLatch readyForShutdownSignalsLatch = new CountDownLatch(1);

    public int performRun() throws Exception {
        int exitCode = -1;
        String[] execCommandTokens = CommandLineArguments.getExecCommandTokens();
        if (execCommandTokens != null) {
            this.initiateAsyncCommandExecution(execCommandTokens, "execution of --exec commands", false);
        }
        this.storeVersionInformationToSystemProperties();
        ThreadGuard.setForbiddenThread((Thread)Thread.currentThread());
        boolean startSleak = System.getProperties().containsKey(DRCE_DEBUG_SLEAK);
        if (startSleak) {
            Policy.DEBUG_SWT_GRAPHICS = true;
            Policy.DEBUG_SWT_DEBUG = true;
        }
        final Display display = PlatformUI.createDisplay();
        if (startSleak) {
            Sleak sleak = new Sleak();
            sleak.open();
        }
        try {
            do {
                if (this.determineWorkspaceLocation(Platform.getInstanceLocation())) continue;
                int n = IApplication.EXIT_OK;
                return n;
            } while (tryWorkspaceChoosingAgain);
            Runnable enqueueGUIStartupCompletionCheck = new Runnable(){

                @Override
                public void run() {
                    boolean starting = PlatformUI.getWorkbench().isStarting();
                    if (!starting) {
                        GUIInstanceRunner.this.readyForShutdownSignalsLatch.countDown();
                    } else {
                        display.timerExec(250, (Runnable)this);
                    }
                }
            };
            display.timerExec(250, enqueueGUIStartupCompletionCheck);
            int platformUIExitCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            exitCode = platformUIExitCode == 1 ? IApplication.EXIT_RESTART.intValue() : IApplication.EXIT_OK.intValue();
        }
        finally {
            display.dispose();
        }
        return exitCode;
    }

    public void onShutdownRequired(List<InstanceValidationResult> validationResults) {
        InstanceValidationResult result = validationResults.get(0);
        this.showErrorDialog("Instance validation: failure", String.valueOf(result.getGuiDialogMessage()) + "\n\nRCE will be shut down.");
    }

    public boolean onRecoveryRequired(List<InstanceValidationResult> validationResults) {
        for (InstanceValidationResult result : validationResults) {
            if (this.showQuestionDialog("Instance validation: confirm startup", result.getGuiDialogMessage())) {
                try {
                    result.getCallback().onConfirmation();
                    continue;
                }
                catch (InstanceValidationResult.CallbackException e) {
                    this.showErrorDialog("Instance validation: recovery error", StringUtils.format((String)"Error during recovery from instance validation error: %s. See log for more details.", (Object[])new Object[]{e.getMessage()}));
                    this.log.error((Object)"Exception thrown during recovery from instance validation failure", (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean onConfirmationRequired(List<InstanceValidationResult> validationResults) {
        for (InstanceValidationResult result : validationResults) {
            if (this.showQuestionDialog("Instance validation: confirm startup", String.valueOf(result.getGuiDialogMessage()) + "\n\nWould you like to proceed anyway?")) continue;
            return false;
        }
        return true;
    }

    public void beforeAwaitShutdown() {
        PlatformUI.getWorkbench();
    }

    public void triggerShutdown() {
        this.triggerAsyncShutdownOrRestart(false);
    }

    public void triggerRestart() {
        this.triggerAsyncShutdownOrRestart(true);
    }

    private void triggerAsyncShutdownOrRestart(final boolean performRestart) {
        ConcurrencyUtils.getAsyncTaskService().execute("Process shutdown trigger (GUI mode)", () -> {
            boolean logWaitingPeriod;
            boolean bl2 = logWaitingPeriod = this.readyForShutdownSignalsLatch.getCount() != 0L;
            if (logWaitingPeriod) {
                this.log.debug((Object)"Shutdown triggered during early GUI startup; waiting for completion signal");
            }
            try {
                this.readyForShutdownSignalsLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.log.warn((Object)("Interrupted while waiting for shutdown readiness (restart flag=" + performRestart + ")"));
                return;
            }
            if (logWaitingPeriod) {
                this.log.debug((Object)"Received signal that early GUI startup has completed; proceeding with shutdown/restart request");
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    GUIInstanceRunner.this.log.debug((Object)"Triggering shutdown/restart of GUI platform");
                    if (performRestart) {
                        PlatformUI.getWorkbench().restart();
                    } else {
                        PlatformUI.getWorkbench().close();
                    }
                }
            });
        });
    }

    private boolean determineWorkspaceLocation(Location workspaceLocation) throws MalformedURLException, IOException {
        if (workspaceLocation.isSet()) {
            this.log.info((Object)("Not using the workspace chooser or locations stored in the RCE profile, as a workspace location was already defined (probably using the -data option): " + workspaceLocation.getURL()));
            return true;
        }
        WorkspaceSettings workspaceSettings = WorkspaceSettings.getInstance();
        File profileDirectory = BootstrapConfiguration.getInstance().getProfileDirectory();
        String lastWorkspaceLocation = workspaceSettings.getLastLocation();
        String recentWorkspacesData = workspaceSettings.getRecentLocationData();
        boolean useStandardWorkspace = CommandLineArguments.isUseDefaultWorkspaceRequested();
        String defaultWorkdirPath = useStandardWorkspace || lastWorkspaceLocation == null ? new File(profileDirectory, "workspace").getAbsolutePath() : new File(lastWorkspaceLocation).getAbsolutePath();
        String[] oldRecentWorkspaces = recentWorkspacesData != null ? StringUtils.splitAndUnescape((String)recentWorkspacesData) : new String[]{defaultWorkdirPath};
        ChooseWorkspaceData cwd = new ChooseWorkspaceData(defaultWorkdirPath);
        cwd.setRecentWorkspaces(oldRecentWorkspaces);
        if (!useStandardWorkspace && !workspaceSettings.getDontAskAgainSetting()) {
            ChooseWorkspaceDialog wd = new ChooseWorkspaceDialog(null, cwd, false, true);
            int cwdReturnCode = wd.open();
            if (cwdReturnCode == 1) {
                return false;
            }
            if (!cwd.getShowDialog()) {
                workspaceSettings.setDontAskAgainSetting(true);
            }
        }
        String currentWorkspace = useStandardWorkspace || cwd.getSelection() == null ? defaultWorkdirPath : new File(cwd.getSelection()).getAbsolutePath();
        ArrayList<String> newRecentWorkspaces = new ArrayList<String>();
        newRecentWorkspaces.add(0, currentWorkspace);
        int pos = 0;
        while (pos < oldRecentWorkspaces.length && newRecentWorkspaces.size() < 5) {
            String oldEntry = oldRecentWorkspaces[pos];
            if (!oldEntry.equals(currentWorkspace)) {
                newRecentWorkspaces.add(oldEntry);
            }
            ++pos;
        }
        String[] newRecentWorkspacesArray = newRecentWorkspaces.toArray(new String[newRecentWorkspaces.size()]);
        cwd.setRecentWorkspaces(newRecentWorkspacesArray);
        cwd.writePersistedData();
        workspaceSettings.updateLocationHistory(currentWorkspace, StringUtils.escapeAndConcat((String[])newRecentWorkspacesArray));
        URL userWSURL = new URL("file", null, currentWorkspace);
        try {
            workspaceLocation.set(userWSURL, true);
            tryWorkspaceChoosingAgain = false;
        }
        catch (IOException iOException) {
            this.showErrorDialog("Workspace", "Workspace directory could not be created or is read-only.");
            tryWorkspaceChoosingAgain = true;
            workspaceSettings.setDontAskAgainSetting(false);
        }
        return true;
    }

    private void storeVersionInformationToSystemProperties() {
        Version version = VersionUtils.getVersionOfProduct();
        String buildId = VersionUtils.getBuildIdAsString((Version)version);
        if (buildId == null) {
            buildId = "-";
        }
        System.setProperty("rce.version", VersionUtils.getVersionAsString((Version)version));
        System.setProperty("rce.buildId", buildId);
    }

    private void showErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    private boolean showQuestionDialog(String title, String message) {
        return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }
}

