/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.utils.common.AuditLog;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OSHISystemIntegrationAdapter
implements SystemIntegrationAdapter {
    private static final long BYTES_TO_MIB_FACTOR = 0x100000L;
    private final CentralProcessor processor;
    private final OperatingSystem os;
    private final GlobalMemory memory;
    private final long cachedTotalSystemRam;
    private final int selfJavaPid;
    private final int logicalProcessors;

    public OSHISystemIntegrationAdapter() {
        SystemInfo sysInfo = new SystemInfo();
        this.os = sysInfo.getOperatingSystem();
        this.selfJavaPid = this.os.getProcessId();
        HardwareAbstractionLayer hardware = sysInfo.getHardware();
        this.processor = hardware.getProcessor();
        this.logicalProcessors = this.processor.getLogicalProcessorCount();
        this.memory = hardware.getMemory();
        long totalSystemRamBytes = this.memory.getTotal();
        this.cachedTotalSystemRam = this.convertBytesToMiB(totalSystemRamBytes);
        Runtime systemRuntime = Runtime.getRuntime();
        String cpuCoreCount = Integer.toString(systemRuntime.availableProcessors());
        String maxHeapSize = Long.toString(systemRuntime.maxMemory());
        AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"monitoring.start").set("system_total_ram", totalSystemRamBytes).set("system_logical_cpus", this.logicalProcessors).set("jvm_processor_count", cpuCoreCount).set("jvm_heap_limit", maxHeapSize).set("jvm_pid", this.selfJavaPid));
    }

    @Override
    public int getSelfJavaPid() {
        return this.selfJavaPid;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        return this.processor.getSystemCpuLoadTicks();
    }

    @Override
    public double getSystemCpuLoadBetweenTicks(long[] previousCpuTicks) {
        return this.processor.getSystemCpuLoadBetweenTicks(previousCpuTicks);
    }

    @Override
    public long getTotalRam() {
        return this.cachedTotalSystemRam;
    }

    @Override
    public long getTotalRamUsage() {
        return this.cachedTotalSystemRam - this.convertBytesToMiB(this.memory.getAvailable());
    }

    @Override
    public List<OSProcess> getAllProcesses() {
        return this.os.getProcesses(OperatingSystem.ProcessFiltering.VALID_PROCESS, null, 0);
    }

    private long convertBytesToMiB(long valueInByte) {
        return valueInByte / 0x100000L;
    }

    @Override
    public int getLogicalProcessorsCount() {
        return this.logicalProcessors;
    }
}

