/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.palettetreenodes;

import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;

public class GroupNode
extends PaletteTreeNode {
    private boolean customGroup = false;

    protected GroupNode(PaletteTreeNode parent, String nodeName) {
        super(parent, nodeName);
    }

    @Override
    public void handleDoubleclick(PaletteView paletteView) {
        paletteView.setExpandedState(this, !paletteView.getPaletteTreeViewer().getExpandedState((Object)this));
    }

    @Override
    public void handleEditEvent() {
        throw new UnsupportedOperationException(StringUtils.format((String)"Unexpected edit event on %s", (Object[])new Object[]{this.getClass().getCanonicalName()}));
    }

    @Override
    public boolean canHandleEditEvent() {
        return false;
    }

    @Override
    public void handleWidgetSelected(WorkflowEditor editor) {
        editor.getViewer().getEditDomain().loadDefaultTool();
    }

    @Override
    public Optional<Image> getIcon() {
        boolean showExpanded = this.getContentProvider().getExpandedState(this) && this.isExpandable();
        return Optional.ofNullable(this.getIcon(showExpanded));
    }

    private boolean isExpandable() {
        return this.getContentProvider().isExpandable(this);
    }

    public Image getIcon(boolean showExpanded) {
        Image icon = showExpanded ? ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FOLDER_16) : ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FOLDER_CLOSED_16);
        if (this.isCustomGroup()) {
            icon = this.getOverlayIcon(icon);
        }
        return icon;
    }

    private Image getOverlayIcon(Image icon) {
        DecorationOverlayIcon overlayIcon = new DecorationOverlayIcon(icon, ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.DECORATOR_CUSTOM), 2);
        return overlayIcon.createImage();
    }

    public boolean isExpanded() {
        return this.getContentProvider().getExpandedState(this);
    }

    public boolean isCustomGroup() {
        return this.customGroup;
    }

    public void setCustomGroup(boolean isCustomGroup) {
        this.customGroup = isCustomGroup;
    }

    @Override
    public boolean isCustomized() {
        if (this.isCustomGroup()) {
            return true;
        }
        if (!this.hasChildren()) {
            return false;
        }
        PaletteTreeNode[] children = (PaletteTreeNode[])this.getChildren();
        return Stream.of(children).anyMatch(PaletteTreeNode::isCustomized);
    }

    @Override
    public void removeChild(TreeNode child) {
        super.removeChild(child);
        if (!this.hasChildren()) {
            this.getContentProvider().setExpandedState(this, false);
        }
    }

    public Image getMenuIcon() {
        Image icon = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FOLDER_CLOSED_16);
        if (this.isCustomGroup() && icon != null) {
            icon = this.getOverlayIcon(icon);
        }
        return icon;
    }

    @Override
    public Optional<String> getHelpContextID() {
        return Optional.empty();
    }
}

