/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser;

import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator instance = null;
    private static File bundleSpecificTempDir;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        bundleSpecificTempDir = TempFileServiceAccess.getInstance().createManagedTempDir();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(bundleSpecificTempDir);
        instance = null;
    }

    public static Activator getInstance() {
        return instance;
    }

    public synchronized File getBundleSpecificTempDir() {
        if (!bundleSpecificTempDir.exists() || !bundleSpecificTempDir.isDirectory()) {
            try {
                bundleSpecificTempDir = TempFileServiceAccess.getInstance().createManagedTempDir();
            }
            catch (IOException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"creating temp dir for dm gui bundle failed", (Throwable)e);
            }
        }
        return bundleSpecificTempDir;
    }
}

