/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.gui.communication.views.contributors.AbstractNetworkConnectionDialog;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class EditNetworkConnectionDialog
extends AbstractNetworkConnectionDialog {
    private static final String COLON = ":";
    private static final String DIALOG_TITLE = "Edit Connection";
    private static final String HINT = "Note: The connection will not be saved.\nTo create permanent connections, edit the configuration files.\nChanges will be applied after restarting the connection.";

    public EditNetworkConnectionDialog(Shell parentShell, String connectionName, String networkContactPointID) {
        super(parentShell, connectionName, networkContactPointID);
        if (this.networkContactPointID.startsWith("activemq-tcp:")) {
            this.networkContactPointID = this.networkContactPointID.replace("activemq-tcp:", "");
        }
        this.host = this.networkContactPointID.substring(0, this.networkContactPointID.indexOf(COLON));
        if (this.networkContactPointID.contains("(")) {
            int index = this.networkContactPointID.indexOf("(");
            String settings = this.networkContactPointID.substring(index);
            settings = settings.replaceAll("[()]", "");
            this.setConnectionSettings(settings);
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1, index);
            String network = this.networkContactPointID.substring(0, index);
            if (this.connectionName.equals(network)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        } else {
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1);
            if (this.connectionName.equals(this.networkContactPointID)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        }
        this.hint = HINT;
    }

    private void setConnectionSettings(String settings) {
        try {
            Map attributes = NetworkContactPointUtils.parseAttributePart((String)settings);
            if (attributes.containsKey("connectOnStartup")) {
                this.connectionSettings.setConnectOnStartup(Boolean.valueOf((String)attributes.get("connectOnStartup")));
            }
            if (attributes.containsKey("useDefaultSettings")) {
                this.connectionSettings.setUseDefaultSettings(Boolean.valueOf((String)attributes.get("useDefaultSettings")));
            }
            if (attributes.containsKey("autoRetryInitialDelay")) {
                this.connectionSettings.setAutoRetryInitialDelay(Integer.valueOf((String)attributes.get("autoRetryInitialDelay")));
            }
            if (attributes.containsKey("autoRetryMaximumDelay")) {
                this.connectionSettings.setAutoRetryMaximumDelay(Integer.valueOf((String)attributes.get("autoRetryMaximumDelay")));
            }
            if (attributes.containsKey("autoRetryDelayMultiplier")) {
                this.connectionSettings.setAutoRetryDelayMultiplier(Double.valueOf((String)attributes.get("autoRetryDelayMultiplier")));
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("The connection settings format is incorrect. The edit dialog cannot be displayed." + ex.toString());
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }
}

