/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.jpedal.PdfDecoder;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.CustomPrintHintingHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;

public class PdfStreamDecoderForPrinting
extends PdfStreamDecoder {
    public PdfStreamDecoderForPrinting(PdfObjectReader pdfObjectReader, boolean bl, PdfLayerList pdfLayerList) {
        super(pdfObjectReader, bl, pdfLayerList);
        this.isPrinting = true;
    }

    public void print(Graphics2D graphics2D, AffineTransform affineTransform, int n, Rectangle rectangle, CustomPrintHintingHandler customPrintHintingHandler, PdfDecoder pdfDecoder) {
        if (customPrintHintingHandler != null) {
            this.current.stopG2HintSetting(true);
            customPrintHintingHandler.preprint(graphics2D, pdfDecoder);
        }
        this.current.setPrintPage(n);
        this.current.setCustomColorHandler((ColorHandler)pdfDecoder.getExternalHandler(19));
        this.current.setG2(graphics2D);
        this.current.paint(null, affineTransform, rectangle);
    }

    public void setObjectValue(int n, Object object) {
        if (n == -8) {
            this.objectStoreStreamRef = (ObjectStore)object;
            this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, true);
            this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
            if (this.customImageHandler != null && this.current != null) {
                this.current.setCustomImageHandler(this.customImageHandler);
            }
        } else {
            super.setObjectValue(n, object);
        }
    }
}

