/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private Hashtable charStrings = new Hashtable();
    private int glyfCount = 0;
    private Map emptyCharStrings = new HashMap();
    private byte[] glyphTable;

    public Glyf(FontFile2 fontFile2, int n, int[] nArray) {
        this.glyfCount = n;
        int n2 = fontFile2.selectTable(3);
        if (n2 != 0) {
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray[i + 1]) {
                    this.charStrings.put(new Integer(i), new Integer(-1));
                    this.emptyCharStrings.put(new Integer(i), "x");
                    continue;
                }
                this.charStrings.put(new Integer(i), new Integer(nArray[i]));
            }
            this.glyphTable = fontFile2.getTableBytes(4);
        }
    }

    public boolean isPresent(int n) {
        Integer n2 = new Integer(n);
        Object v = this.charStrings.get(n2);
        return v != null && this.emptyCharStrings.get(n2) == null;
    }

    public int getCharString(int n) {
        Object v = this.charStrings.get(new Integer(n));
        if (v == null) {
            return n;
        }
        return (Integer)v;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlypfCount() {
        return this.glyfCount;
    }
}

