/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationMessages;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public class ValidationInfo
implements ValidationReport {
    private boolean WRAPPER_ERROR_SUPPORT_ENABLED = true;
    public static final int SEV_ERROR = 0;
    public static final int SEV_WARNING = 1;
    private String validating_file_uri = null;
    private URL validating_file_url = null;
    private boolean valid = true;
    private List messages = new ArrayList();
    private HashMap nestedMessages = new HashMap();
    private IScopeContext[] sameFilePreferenceContext = null;

    public ValidationInfo(String uri) {
        if (uri != null) {
            this.validating_file_uri = uri;
            try {
                this.validating_file_url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    @Override
    public String getFileURI() {
        return this.validating_file_uri;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void addError(String message, int line, int column, String uri) {
        this.addError(message, line, column, uri, null, null);
    }

    public void addError(String message, int line, int column, String uri, String key, Object[] messageArguments) {
        if (this.addMessage(message, line, column, uri, 0, key, messageArguments)) {
            this.valid = false;
        }
    }

    public void addWarning(String message, int line, int column, String uri) {
        this.addWarning(message, line, column, uri, null, null);
    }

    public void addWarning(String message, int line, int column, String uri, String key, Object[] messageArguments) {
        this.addMessage(message, line, column, uri, 1, key, messageArguments);
    }

    private boolean addMessage(String message, int line, int column, String uri, int severity, String key, Object[] messageArguments) {
        boolean successfullyAdded = false;
        if (message == null) {
            return successfullyAdded;
        }
        String errorURI = this.normalize(uri);
        URL errorURL = null;
        if (errorURI != null) {
            try {
                errorURL = new URL(errorURI);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (errorURL != null) {
            boolean isSameFile = this.validating_file_url != null && this.validating_file_url.sameFile(errorURL);
            int validationErrorSeverity = -1;
            if (!isSameFile) {
                int referencedFileSeverity = Platform.getPreferencesService().getInt(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "indicateReferencedFileContainsErrors", 0, this.getPreferenceScopes());
                if (referencedFileSeverity == 1) {
                    validationErrorSeverity = 4;
                } else if (referencedFileSeverity == 2) {
                    validationErrorSeverity = 2;
                }
            } else {
                validationErrorSeverity = severity == 0 ? 2 : 4;
            }
            successfullyAdded = true;
            if (validationErrorSeverity == -1) {
                return successfullyAdded;
            }
            if (!this.WRAPPER_ERROR_SUPPORT_ENABLED || isSameFile) {
                ValidationMessage valmes = new ValidationMessage(message, line, column, this.validating_file_uri, key, messageArguments);
                valmes.setSeverity(validationErrorSeverity);
                this.messages.add(valmes);
            } else if (this.WRAPPER_ERROR_SUPPORT_ENABLED) {
                String nesteduri = errorURL.toExternalForm();
                ValidationMessage nestedmess = new ValidationMessage(message, line, column, nesteduri, key, messageArguments);
                nestedmess.setSeverity(validationErrorSeverity);
                ValidationMessage container = (ValidationMessage)this.nestedMessages.get(nesteduri);
                if (container == null) {
                    container = new ValidationMessage(NLS.bind((String)XMLValidationMessages._UI_REF_FILE_ERROR_MESSAGE, (Object[])new Object[]{nesteduri}), 1, 0, nesteduri);
                    container.setSeverity(4);
                    this.nestedMessages.put(nesteduri, container);
                    this.messages.add(container);
                }
                container.addNestedMessage(nestedmess);
            }
        }
        return successfullyAdded;
    }

    private IScopeContext[] getPreferenceScopes() {
        if (this.sameFilePreferenceContext == null) {
            this.sameFilePreferenceContext = this.createPreferenceScopes(this.validating_file_url);
        }
        return this.sameFilePreferenceContext;
    }

    private IScopeContext[] createPreferenceScopes(URL url) {
        IProject p = null;
        try {
            URI uri = new URI(url.toString());
            IFile[] matching = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (matching != null && matching.length > 0) {
                p = matching[0].getProject();
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return this.createPreferenceScopesFromProject(p);
    }

    private IScopeContext[] createPreferenceScopesFromProject(IProject project) {
        ProjectScope projectScope;
        if (project != null && project.isAccessible() && (projectScope = new ProjectScope(project)).getNode(XMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            return new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    @Override
    public ValidationMessage[] getValidationMessages() {
        return this.messages.toArray(new ValidationMessage[this.messages.size()]);
    }

    @Override
    public HashMap getNestedMessages() {
        return this.nestedMessages;
    }

    private String normalize(String uri) {
        uri = uri.replaceAll("%20", " ");
        uri = uri.replaceAll("%5E", "^");
        uri = uri.replace('\\', '/');
        return uri;
    }
}

