/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.sun;

import com.sun.pdfview.PDFFile;
import de.vonloesch.pdf4eclipse.Messages;
import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.sun.SunOutlineNode;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFPage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SunPDFFile
implements IPDFFile {
    PDFFile pdfFile;
    File input;
    int pageNumbers;

    public SunPDFFile(File file) throws IOException {
        this.input = file;
        this.reload();
    }

    @Override
    public int getNumPages() {
        return this.pageNumbers;
    }

    @Override
    public IOutlineNode getOutline() throws IOException {
        if (this.pdfFile.getOutline() == null) {
            return null;
        }
        return new SunOutlineNode(this.pdfFile.getOutline());
    }

    @Override
    public void reload() throws IOException {
        long len = this.input.length();
        if (len > Integer.MAX_VALUE) {
            throw new IOException(String.valueOf(Messages.PDFEditor_ErrorMsg2) + this.input.getName());
        }
        int contentLength = (int)len;
        RandomAccessFile ff = new RandomAccessFile(this.input, "r");
        ByteBuffer buf = ByteBuffer.allocateDirect(contentLength);
        FileChannel c = ff.getChannel();
        c.read(buf);
        c.close();
        ff.close();
        this.pdfFile = new PDFFile(buf);
        this.pageNumbers = this.pdfFile.getNumPages();
    }

    @Override
    public IPDFPage getPage(int pageNr) {
        return new SunPDFPage(this.pdfFile.getPage(pageNr));
    }

    @Override
    public void close() {
        this.pdfFile = null;
    }

    public PDFFile getInternalPDFFile() {
        return this.pdfFile;
    }
}

