/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.api.threadcontext;

import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContext;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextHolder;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextNameProvider;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextStaticNameProvider;

public final class ThreadContextBuilder {
    private ThreadContext currentContextHead;

    private ThreadContextBuilder(ThreadContext parent) {
        this.currentContextHead = parent;
    }

    public static ThreadContextBuilder empty() {
        return new ThreadContextBuilder(new ImmutableRootThreadContextImpl());
    }

    public static ThreadContextBuilder from(ThreadContext parentContext) {
        return new ThreadContextBuilder(parentContext);
    }

    public static ThreadContextBuilder fromCurrent() {
        ThreadContext currentContext = ThreadContextHolder.getCurrentContext();
        if (currentContext != null) {
            return ThreadContextBuilder.from(currentContext);
        }
        return ThreadContextBuilder.empty();
    }

    public <T> ThreadContextBuilder setAspect(Class<T> key, T value) {
        this.currentContextHead = new ImmutableThreadContextImpl(this.currentContextHead, key, value);
        return this;
    }

    public ThreadContextBuilder setName(String staticName) {
        this.setAspect(ThreadContextNameProvider.class, new ThreadContextStaticNameProvider(staticName));
        return this;
    }

    public ThreadContextBuilder setNameProvider(ThreadContextNameProvider nameProvider) {
        this.setAspect(ThreadContextNameProvider.class, nameProvider);
        return this;
    }

    public ThreadContext build() {
        return this.currentContextHead;
    }

    private static final class ImmutableRootThreadContextImpl
    implements ThreadContext {
        private ImmutableRootThreadContextImpl() {
        }

        @Override
        public <T> T getAspect(Class<T> aspectType) {
            return null;
        }
    }

    private static final class ImmutableThreadContextImpl
    implements ThreadContext {
        private final ThreadContext parentContext;
        private final Object aspectKey;
        private final Object aspectValue;

        <T> ImmutableThreadContextImpl(ThreadContext parentContext, Class<T> aspectKey, T aspectValue) {
            this.parentContext = parentContext;
            this.aspectKey = aspectKey;
            this.aspectValue = aspectValue;
        }

        @Override
        public <T> T getAspect(Class<T> aspectType) {
            if (aspectType == this.aspectKey) {
                return (T)this.aspectValue;
            }
            return this.parentContext.getAspect(aspectType);
        }

        public String toString() {
            ThreadContextNameProvider nameProvider = this.getAspect(ThreadContextNameProvider.class);
            if (nameProvider != null) {
                return nameProvider.getName(this);
            }
            return super.toString();
        }
    }
}

