/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.ssh.jsch.executor.context;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Random;

class RemoteTempDirFactory {
    private static final int MIN_PLAUSIBLE_ROOT_DIR_LENGTH = "/tmp".length();
    private final String rootDir;
    private final Random random = new Random();

    RemoteTempDirFactory(String rootDir) {
        if (rootDir == null || rootDir.length() < MIN_PLAUSIBLE_ROOT_DIR_LENGTH) {
            throw new IllegalArgumentException("Invalid root path: " + rootDir);
        }
        if (rootDir.charAt(rootDir.length() - 1) != '/') {
            rootDir = String.valueOf(rootDir) + "/";
        }
        this.rootDir = rootDir;
    }

    public String createTempDirPath(String contextHint, String separator) {
        int randInt = this.random.nextInt();
        return StringUtils.format((String)"%s%s%s%d%s%d", (Object[])new Object[]{this.rootDir, contextHint, separator, System.currentTimeMillis(), separator, Math.abs(randInt)});
    }

    public String getRootDir() {
        return this.rootDir;
    }
}

