/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowModelService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowDescriptionValidationResult;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.editor.validator.WorkflowDescriptionValidationUtils;
import de.rcenvironment.core.gui.workflow.execute.ColorPalette;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.NodeIdentifierConfigurationHelper;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderPage;
import de.rcenvironment.core.gui.workflow.execute.WorkflowExecutionWizardValidationDialog;
import de.rcenvironment.core.gui.workflow.execute.WorkflowPage;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditorAction;
import de.rcenvironment.core.gui.workflow.view.properties.InputModel;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.provenance.api.ProvenanceEventListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class WorkflowExecutionWizard
extends Wizard
implements DistributedComponentKnowledgeListener {
    private static final int UI_EVENT_DISPATCH_INTERVAL_DURING_BLOCKING_REMOTE_CALL = 200;
    private static final int MINIMUM_HEIGHT = 250;
    private static final int MINIMUM_WIDTH = 500;
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionWizard.class);
    private final boolean inputTabEnabled;
    private final IFile wfFile;
    private WorkflowDescription wfDescription;
    private List<WorkflowNode> disabledWorkflowNodes;
    private List<Connection> disabledConnections;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private final WorkflowExecutionService workflowExecutionService;
    private final NodeIdentifierConfigurationHelper nodeIdConfigHelper;
    private WorkflowPage workflowPage;
    private PlaceholderPage placeholdersPage;
    private LogicalNodeId localDefaultNodeId;
    private boolean errorVisible = false;
    private ComponentValidationMessageStore messageStore = ComponentValidationMessageStore.getInstance();

    public WorkflowExecutionWizard(IFile workflowFile, WorkflowDescription workflowDescription) {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.workflowExecutionService = (WorkflowExecutionService)this.serviceRegistryAccess.getService(WorkflowExecutionService.class);
        Activator.getInstance().registerUndisposedWorkflowShutdownListener();
        this.inputTabEnabled = ((ConfigurationService)this.serviceRegistryAccess.getService(ConfigurationService.class)).getConfigurationSegment("general").getBoolean("enableDeprecatedInputTab", Boolean.valueOf(false));
        this.wfFile = workflowFile;
        this.disabledWorkflowNodes = WorkflowExecutionUtils.getDisabledWorkflowNodes((WorkflowDescription)workflowDescription);
        this.disabledConnections = workflowDescription.removeWorkflowNodesAndRelatedConnections(this.disabledWorkflowNodes);
        this.wfDescription = workflowDescription;
        this.nodeIdConfigHelper = new NodeIdentifierConfigurationHelper();
        this.localDefaultNodeId = ((PlatformService)this.serviceRegistryAccess.getService(PlatformService.class)).getLocalDefaultLogicalNodeId();
        this.wfDescription.setName(WorkflowExecutionUtils.generateDefaultNameforExecutingWorkflow((String)workflowFile.getName(), (WorkflowDescription)this.wfDescription));
        this.wfDescription.setFileName(workflowFile.getName());
        this.setWindowTitle(Messages.workflowExecutionWizardTitle);
        this.setNeedsProgressMonitor(true);
        ColorPalette.getInstance().loadColors();
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)this);
        NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread((NodeIdentifierService)((NodeIdentifierService)this.serviceRegistryAccess.getService(NodeIdentifierService.class)));
    }

    public void addPages() {
        this.workflowPage = new WorkflowPage(this.wfDescription.clone(), this.nodeIdConfigHelper);
        this.addPage((IWizardPage)this.workflowPage);
        this.placeholdersPage = new PlaceholderPage(this.wfDescription.clone());
        if (this.placeholdersPage.hasActivePlaceholders()) {
            this.addPage((IWizardPage)this.placeholdersPage);
        }
        this.getShell().setMinimumSize(500, 250);
    }

    public boolean canFinish() {
        if (!this.placeholdersPage.hasActivePlaceholders()) {
            return this.workflowPage.canFinish();
        }
        return this.workflowPage.canFinish() && (this.getContainer().getCurrentPage() == this.placeholdersPage || this.placeholdersPage.canFinish());
    }

    public boolean performFinish() {
        this.grabDataFromWorkflowPage();
        if (this.placeholdersPage.hasActivePlaceholders()) {
            this.grabDataFromPlaceholdersPage();
        }
        if (!this.performValidations()) {
            return false;
        }
        this.messageStore.emptyMessageStore();
        boolean isValid = true;
        isValid &= this.validateWorkflowControllerVisibility();
        isValid &= this.validateWorkflow();
        if (this.placeholdersPage.hasActivePlaceholders()) {
            isValid &= this.validatePlaceholder();
        }
        if (!isValid && !this.requestConfirmationForValidationErrorsWarnings()) {
            return false;
        }
        if (this.placeholdersPage.hasActivePlaceholders()) {
            this.placeholdersPage.savePlaceholdersToPersistentSettings();
        }
        if (this.placeholdersPage.hasActivePlaceholders()) {
            this.placeholdersPage.dispose();
        }
        WorkflowExecutionUtils.setNodeIdentifiersToTransientInCaseOfLocalOnes((WorkflowDescription)this.wfDescription, (LogicalNodeId)this.localDefaultNodeId);
        this.saveWorkflow();
        this.executeWorkflowInBackground(this.wfDescription.clone());
        return true;
    }

    private void executeWorkflowInBackground(final WorkflowDescription clonedWfDescription) {
        Job job = new Job(Messages.workflowExecutionWizardTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.settingUpWorkflow, 2);
                    monitor.worked(1);
                    WorkflowExecutionWizard.this.executeWorkflow(clonedWfDescription);
                    monitor.worked(1);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public synchronized boolean performValidations() {
        WorkflowDescriptionValidationResult validationResult = this.workflowExecutionService.validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(this.wfDescription);
        this.workflowPage.getWorkflowComposite().refreshContent();
        if (this.getContainer().getCurrentPage() == this.placeholdersPage && !validationResult.isSucceeded()) {
            if (!this.errorVisible) {
                this.errorVisible = true;
                MessageBox errorBox = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                errorBox.setMessage("Some of the selected instances are not available anymore:\n\n" + validationResult.toString() + "\n\nCheck your connection(s) or select (an)other instance(s).");
                errorBox.setText("Instances Error");
                int id = errorBox.open();
                if (id == 32 || id == 64) {
                    this.errorVisible = false;
                }
            }
            return false;
        }
        return validationResult.isSucceeded();
    }

    private void grabDataFromWorkflowPage() {
        this.wfDescription.setName(this.workflowPage.getWorkflowName());
        this.wfDescription.setControllerNode(this.workflowPage.getControllerNodeId());
        this.wfDescription.setAdditionalInformation(this.workflowPage.getAdditionalInformation());
        Map<WorkflowNodeIdentifier, ComponentInstallation> cmpInstallations = this.workflowPage.getComponentInstallations();
        for (WorkflowNodeIdentifier wfNodeId : cmpInstallations.keySet()) {
            this.wfDescription.getWorkflowNode(wfNodeId).getComponentDescription().setComponentInstallationAndUpdateConfiguration(cmpInstallations.get(wfNodeId));
        }
    }

    private void grabDataFromPlaceholdersPage() {
        this.placeholdersPage.performFinish();
        Map<String, Map<String, String>> placeholders = this.placeholdersPage.getPlaceholders();
        for (String wfNodeId : placeholders.keySet()) {
            this.wfDescription.getWorkflowNode(wfNodeId).getComponentDescription().getConfigurationDescription().setPlaceholders(placeholders.get(wfNodeId));
        }
    }

    private boolean validatePlaceholder() {
        return !this.placeholdersPage.validateErrors();
    }

    private boolean validateWorkflow() {
        WorkflowDescriptionValidationUtils.validateWorkflowDescription(this.wfDescription, true, true);
        return this.messageStore.isErrorAndWarningsFree();
    }

    private boolean validateWorkflowControllerVisibility() {
        LogicalNodeId controllerNode = this.wfDescription.getControllerNode();
        if (controllerNode == null || controllerNode.equals(this.localDefaultNodeId)) {
            LOG.debug((Object)"Running with a local workflow controller; no visibility checks required");
            return true;
        }
        Map<String, String> errors = this.performRemoteControllerVisibilityCheck();
        if (errors == null || errors.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> error : errors.entrySet()) {
            ComponentValidationMessage componentValidationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, null, null, error.getValue());
            ArrayList<ComponentValidationMessage> temp = new ArrayList<ComponentValidationMessage>();
            temp.add(componentValidationMessage);
            this.messageStore.addValidationMessagesByComponentId(error.getKey(), temp);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> performRemoteControllerVisibilityCheck() {
        Exchanger<Object> exchanger = new Exchanger<Object>();
        ConcurrencyUtils.getAsyncTaskService().execute("Run remote query for component visibility", () -> {
            try {
                exchanger.exchange(this.workflowExecutionService.validateRemoteWorkflowControllerVisibilityOfComponents(this.wfDescription));
            }
            catch (InterruptedException interruptedException) {
                LOG.warn((Object)"Interrupted while waiting for the GUI thread to receive a query result");
                Thread.currentThread().interrupt();
            }
        });
        while (true) {
            Display display;
            try {
                return exchanger.exchange(null, 200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.warn((Object)"Interrupted while waiting for a query result");
                return new HashMap<String, String>();
            }
            catch (TimeoutException timeoutException) {
                display = Display.getCurrent();
            }
            while (display.readAndDispatch()) {
            }
        }
    }

    private boolean requestConfirmationForValidationErrorsWarnings() {
        WorkflowExecutionWizardValidationDialog dialog = new WorkflowExecutionWizardValidationDialog(this.getShell(), this.messageStore.getMessageMap(), this.wfDescription, this.placeholdersPage);
        return dialog.open() == 0;
    }

    private void saveWorkflow() {
        this.wfDescription.addWorkflowNodesAndConnections(this.disabledWorkflowNodes, this.disabledConnections);
        WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream content = persistenceHandler.writeWorkflowDescriptionToStream(this.wfDescription);){
                ByteArrayInputStream input = new ByteArrayInputStream(content.toByteArray());
                this.wfFile.setContents((InputStream)input, true, false, null);
                this.wfFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error when Saving Workflow", (String)("Failed to save workflow: " + e.getMessage()));
            LOG.error((Object)StringUtils.format((String)"Failed to save workflow: %s", (Object[])new Object[]{this.wfFile.getRawLocation().toOSString()}));
        }
    }

    private void executeWorkflow(WorkflowDescription clonedWfDesc) {
        WorkflowExecutionInformation wfExeInfo;
        DistributedComponentKnowledge compKnowledge = ((DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class)).getCurrentSnapshot();
        try {
            WorkflowExecutionUtils.replaceNullNodeIdentifiersWithActualNodeIdentifier((WorkflowDescription)clonedWfDesc, (LogicalNodeId)this.localDefaultNodeId, (DistributedComponentKnowledge)compKnowledge);
        }
        catch (WorkflowExecutionException e) {
            this.handleWorkflowExecutionError(clonedWfDesc, e);
            return;
        }
        String name = clonedWfDesc.getName();
        if (name == null) {
            name = Messages.bind((String)Messages.defaultWorkflowName, (Object)this.wfFile.getName().toString());
        }
        WorkflowExecutionContextBuilder wfExeCtxBuilder = new WorkflowExecutionContextBuilder(clonedWfDesc);
        wfExeCtxBuilder.setInstanceName(name);
        wfExeCtxBuilder.setNodeIdentifierStartedExecution(this.localDefaultNodeId);
        if (clonedWfDesc.getAdditionalInformation() != null && !clonedWfDesc.getAdditionalInformation().isEmpty()) {
            wfExeCtxBuilder.setAdditionalInformationProvidedAtStart(clonedWfDesc.getAdditionalInformation());
        }
        WorkflowExecutionContext wfExecutionContext = wfExeCtxBuilder.build();
        try {
            wfExeInfo = this.workflowExecutionService.startWorkflowExecution(wfExecutionContext);
        }
        catch (WorkflowExecutionException | RemoteOperationException e) {
            this.handleWorkflowExecutionError(clonedWfDesc, e);
            return;
        }
        this.notifyProvenanceServiceAboutLoadedWorkflowFile(wfExeInfo);
        try {
            ((ConsoleRowModelService)this.serviceRegistryAccess.getService(ConsoleRowModelService.class)).ensureConsoleCaptureIsInitialized();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Failed initialize workflow console capturing for workflow: " + clonedWfDesc.getName()), (Throwable)e);
        }
        if (this.inputTabEnabled) {
            InputModel.ensureInputCaptureIsInitialized();
        }
        WorkflowExecutionUtils.removeDisabledWorkflowNodesWithoutNotify((WorkflowDescription)wfExeInfo.getWorkflowDescription());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new WorkflowRunEditorAction(wfExeInfo).run();
            }
        });
    }

    private void notifyProvenanceServiceAboutLoadedWorkflowFile(WorkflowExecutionInformation wfExeInfo) {
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
        Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
        provenanceService.ifPresent(service -> service.workflowFileLoaded(wfExeInfo.getExecutionIdentifier(), this.wfFile.getRawLocation().makeAbsolute().toFile()));
    }

    private void handleWorkflowExecutionError(WorkflowDescription clonedWfDesc, final Throwable e) {
        LOG.error((Object)("Failed to execute workflow: " + clonedWfDesc.getName()), e);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)WorkflowExecutionWizard.this.getShell(), (String)"Workflow Execution Error", (String)("Failed to execute workflow: " + e.getMessage()));
            }
        });
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
        super.dispose();
    }

    public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WorkflowExecutionWizard.this.workflowPage != null && !WorkflowExecutionWizard.this.workflowPage.getControl().isDisposed()) {
                        WorkflowExecutionWizard.this.performValidations();
                    } else {
                        LogFactory.getLog(this.getClass()).warn((Object)"Got callback (onDistributedComponentKnowledgeChanged) but widget(s) already disposed; the listener might not be disposed properly");
                    }
                }
            });
        }
    }
}

