/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowLabelSendLayerwiseCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeSendLayerwiseCommand;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWorkflowPartSendHandler
extends AbstractHandler {
    protected GraphicalViewer viewer;
    protected CommandStack commandStack;
    protected WorkflowDescription workflowDescription;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof WorkflowEditor) {
            this.viewer = ((WorkflowEditor)activePart).getViewer();
            this.commandStack = (CommandStack)((WorkflowEditor)activePart).getAdapter(CommandStack.class);
            this.workflowDescription = (WorkflowDescription)this.viewer.getContents().getModel();
            this.edit();
        }
        return null;
    }

    abstract void edit();

    protected void send(SendType sendType) {
        if (this.viewer.getSelectedEditParts().get(0) instanceof WorkflowLabelPart) {
            List labelParts = this.viewer.getSelectedEditParts();
            switch (sendType) {
                case SEND_BACK: 
                case SEND_TO_BACKGROUND: {
                    if (!this.onlyLabelsInBackgroundSelected(labelParts)) break;
                    return;
                }
                case SEND_FORWARD: 
                case SEND_TO_FOREGROUND: {
                    if (!this.onlyLabelsInForegroundSelected(labelParts)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.commandStack.execute((Command)new WorkflowLabelSendLayerwiseCommand((WorkflowDescription)this.viewer.getContents().getModel(), labelParts, sendType));
        } else if (this.viewer.getSelectedEditParts().get(0) instanceof WorkflowNodePart) {
            List nodeParts = this.viewer.getSelectedEditParts();
            switch (sendType) {
                case SEND_BACK: 
                case SEND_TO_BACKGROUND: {
                    if (!this.onlyNodesInBackgroundSelected(nodeParts)) break;
                    return;
                }
                case SEND_FORWARD: 
                case SEND_TO_FOREGROUND: {
                    if (!this.onlyNodesInForegroundSelected(nodeParts)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.commandStack.execute((Command)new WorkflowNodeSendLayerwiseCommand((WorkflowDescription)this.viewer.getContents().getModel(), nodeParts, sendType));
        }
    }

    protected boolean onlyLabelsInForegroundSelected(List<WorkflowLabelPart> labels) {
        int currentIndex;
        ArrayList<WorkflowLabelPart> returnList = new ArrayList<WorkflowLabelPart>();
        for (WorkflowLabelPart labelPart : labels) {
            returnList.add(labelPart);
        }
        int topIndex = this.workflowDescription.getWorkflowLabels().size() - 1;
        block1: do {
            currentIndex = topIndex;
            for (WorkflowLabelPart labelPart : returnList) {
                if (((WorkflowLabel)labelPart.getModel()).getZIndex() != topIndex) continue;
                returnList.remove(labelPart);
                --topIndex;
                continue block1;
            }
        } while (currentIndex != topIndex);
        return returnList.isEmpty();
    }

    protected boolean onlyLabelsInBackgroundSelected(List<WorkflowLabelPart> labels) {
        int currentIndex;
        ArrayList<WorkflowLabelPart> returnList = new ArrayList<WorkflowLabelPart>();
        for (WorkflowLabelPart labelPart : labels) {
            returnList.add(labelPart);
        }
        int bottomIndex = 0;
        block1: do {
            currentIndex = bottomIndex;
            for (WorkflowLabelPart labelPart : returnList) {
                if (((WorkflowLabel)labelPart.getModel()).getZIndex() != bottomIndex) continue;
                returnList.remove(labelPart);
                ++bottomIndex;
                continue block1;
            }
        } while (currentIndex != bottomIndex);
        return returnList.isEmpty();
    }

    protected boolean onlyNodesInForegroundSelected(List<WorkflowNodePart> nodes) {
        int currentIndex;
        ArrayList<WorkflowNodePart> returnList = new ArrayList<WorkflowNodePart>();
        for (WorkflowNodePart nodePart : nodes) {
            returnList.add(nodePart);
        }
        int topIndex = this.workflowDescription.getWorkflowNodes().size() - 1;
        block1: do {
            currentIndex = topIndex;
            for (WorkflowNodePart nodePart : returnList) {
                if (((WorkflowNode)nodePart.getModel()).getZIndex() != topIndex) continue;
                returnList.remove(nodePart);
                --topIndex;
                continue block1;
            }
        } while (currentIndex != topIndex);
        return returnList.isEmpty();
    }

    protected boolean onlyNodesInBackgroundSelected(List<WorkflowNodePart> nodes) {
        int currentIndex;
        ArrayList<WorkflowNodePart> returnList = new ArrayList<WorkflowNodePart>();
        for (WorkflowNodePart nodePart : nodes) {
            returnList.add(nodePart);
        }
        int bottomIndex = 0;
        block1: do {
            currentIndex = bottomIndex;
            for (WorkflowNodePart nodePart : returnList) {
                if (((WorkflowNode)nodePart.getModel()).getZIndex() != bottomIndex) continue;
                returnList.remove(nodePart);
                ++bottomIndex;
                continue block1;
            }
        } while (currentIndex != bottomIndex);
        return returnList.isEmpty();
    }

    public static enum SendType {
        SEND_BACK,
        SEND_FORWARD,
        SEND_TO_BACKGROUND,
        SEND_TO_FOREGROUND;

    }
}

