/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.InputWithOutputsCommandUtils;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputWithOutputsCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.LinkedList;
import java.util.List;

public class RemoveDynamicInputWithAnotherPossibleInputAndOutputsCommand
extends RemoveDynamicInputWithOutputsCommand {
    private final String addDynInputId;
    private final String inputNameSuffix;
    private final List<String> inputsWithSuffixInput;

    public RemoveDynamicInputWithAnotherPossibleInputAndOutputsCommand(String dynEndpointId, String addDynInputId, String inputNameSuffix, String addDynOutputId, String outputNameSuffix, List<String> names, Refreshable ... panes) {
        super(dynEndpointId, addDynOutputId, outputNameSuffix, names, panes);
        this.addDynInputId = addDynInputId;
        this.inputNameSuffix = inputNameSuffix;
        this.inputsWithSuffixInput = new LinkedList<String>();
    }

    @Override
    public void initialize() {
        for (String name : this.names) {
            this.oldDescriptions.put(name, this.getProperties().getInputDescriptionsManager().getEndpointDescription(name));
            EndpointDescription endpointDescription = this.getProperties().getInputDescriptionsManager().getEndpointDescription(String.valueOf(name) + this.inputNameSuffix);
            if (endpointDescription == null) continue;
            this.inputsWithSuffixInput.add(name);
        }
    }

    @Override
    public void execute() {
        for (String name : this.names) {
            EndpointDescription endpointDescription = this.getProperties().getInputDescriptionsManager().getEndpointDescription(String.valueOf(name) + this.inputNameSuffix);
            if (endpointDescription == null) continue;
            InputWithOutputsCommandUtils.removeInputWithSuffix(this.getProperties(), name, this.inputNameSuffix);
        }
        super.execute();
    }

    @Override
    public void undo() {
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            if (!this.inputsWithSuffixInput.contains(name)) continue;
            InputWithOutputsCommandUtils.addInputWithSuffix(this.getProperties(), this.addDynInputId, name, oldDescription.getDataType(), this.inputNameSuffix, "startValues");
        }
        super.undo();
    }
}

