/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import java.util.Properties;

final class SaveUserInputParameters {
    private static final String CHECKBOX_VALUE_KEY = "checkboxValue";
    private static final String CHECKBOX_VALUE_CHECKED = "checked";
    private static final String CHECKBOX_VALUE_UNCHECKED = "unchecked";
    private final Properties backingProperties = new Properties();

    private SaveUserInputParameters(Properties properties) {
        this.backingProperties.putAll((Map<?, ?>)properties);
    }

    public static SaveUserInputParameters createFromProperties(Properties properties) {
        SaveUserInputParameters.assertCheckboxValueKeyExists(properties);
        SaveUserInputParameters.assertCheckboxValueIsValid(properties);
        return new SaveUserInputParameters(properties);
    }

    private static void assertCheckboxValueKeyExists(Properties properties) {
        if (!properties.containsKey(CHECKBOX_VALUE_KEY)) {
            String errorMessage = StringUtils.format((String)"Properties given for constructing instance of %s do not contain key %s", (Object[])new Object[]{SaveUserInputParameters.class.getName(), CHECKBOX_VALUE_KEY});
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void assertCheckboxValueIsValid(Properties properties) {
        String checkboxValue = properties.getProperty(CHECKBOX_VALUE_KEY);
        if (CHECKBOX_VALUE_CHECKED.equals(checkboxValue)) {
            return;
        }
        if (CHECKBOX_VALUE_UNCHECKED.equals(checkboxValue)) {
            return;
        }
        String errorMessage = StringUtils.format((String)"Properties given for constructing instance of %s do not contain valid value for key %s. Contained value: %s. Valid values: %s, %s", (Object[])new Object[]{SaveUserInputParameters.class.getName(), CHECKBOX_VALUE_KEY, checkboxValue, CHECKBOX_VALUE_CHECKED, CHECKBOX_VALUE_UNCHECKED});
        throw new IllegalArgumentException(errorMessage);
    }

    public boolean isCheckboxChecked() {
        String checkboxValue = this.backingProperties.getProperty(CHECKBOX_VALUE_KEY);
        return CHECKBOX_VALUE_CHECKED.equals(checkboxValue);
    }
}

