/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class WorkflowGraphNode
implements Serializable {
    private static final long serialVersionUID = 272922098023592460L;
    private final ComponentExecutionIdentifier executionIdentifier;
    private final String wfNodeId;
    private final Set<String> inputIdentifiers;
    private final Set<String> outputIdentifiers;
    private final Map<String, String> endpointNames;
    private final boolean isDriver;
    private final boolean isDrivingFaultTolerantLoop;
    private final String name;

    public WorkflowGraphNode(String wfNodeId, ComponentExecutionIdentifier compExeId, Set<String> inputIdentifiers, Set<String> outputIdentifiers, Map<String, String> endpointNames, boolean isDriver, boolean isDrivingFaultTolerantLoop) {
        this(wfNodeId, compExeId, inputIdentifiers, outputIdentifiers, endpointNames, isDriver, isDrivingFaultTolerantLoop, compExeId.toString());
    }

    public WorkflowGraphNode(String wfNodeId, ComponentExecutionIdentifier compExeId, Set<String> inputIdentifiers, Set<String> outputIdentifiers, Map<String, String> endpointNames, boolean isDriver, boolean isDrivingFaultTolerantLoop, String name) {
        this.wfNodeId = wfNodeId;
        this.executionIdentifier = compExeId;
        this.inputIdentifiers = inputIdentifiers;
        this.outputIdentifiers = outputIdentifiers;
        this.endpointNames = endpointNames;
        this.isDriver = isDriver;
        this.isDrivingFaultTolerantLoop = isDrivingFaultTolerantLoop;
        this.name = name;
    }

    public ComponentExecutionIdentifier getExecutionIdentifier() {
        return this.executionIdentifier;
    }

    public String getWorkflowNodeIdentifier() {
        return this.wfNodeId;
    }

    public Set<String> getInputIdentifiers() {
        return this.inputIdentifiers;
    }

    public Set<String> getOutputIdentifiers() {
        return this.outputIdentifiers;
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    public boolean isDrivingFaultTolerantLoop() {
        return this.isDrivingFaultTolerantLoop;
    }

    public String getEndpointName(String endpointIdentifier) {
        return this.endpointNames.get(endpointIdentifier);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return StringUtils.format((String)"%s (driver: %b)", (Object[])new Object[]{this.getExecutionIdentifier(), this.isDriver()});
    }
}

