/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.view;

import de.rcenvironment.components.parametricstudy.common.Dimension;
import de.rcenvironment.components.parametricstudy.common.Measure;
import de.rcenvironment.components.parametricstudy.common.ParametricStudyService;
import de.rcenvironment.components.parametricstudy.common.Study;
import de.rcenvironment.components.parametricstudy.common.StudyDataset;
import de.rcenvironment.components.parametricstudy.common.StudyReceiver;
import de.rcenvironment.components.parametricstudy.common.StudyStructure;
import de.rcenvironment.components.parametricstudy.gui.view.DatasetNotificationSubscriber;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.NotificationSubscriber;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class StudyDatastore
extends Study {
    private static final long serialVersionUID = 990775937058384209L;
    private static DatasetNotificationSubscriber notificationSubscriber;
    private final List<StudyDataset> datasets = Collections.synchronizedList(new LinkedList());
    private final List<StudyDatasetAddListener> listeners = new LinkedList<StudyDatasetAddListener>();
    private final Map<String, Double> minValues = new HashMap<String, Double>();
    private final Map<String, Double> maxValues = new HashMap<String, Double>();

    public StudyDatastore(String identifier, String title, StudyStructure structure) {
        super(identifier, title, structure);
    }

    public void addDataset(StudyDataset dataset) {
        this.datasets.add(dataset);
        this.fireDatasetAdd(dataset);
        for (Dimension dimension : this.getStructure().getDimensions()) {
            this.adjustMinMaxRange(dataset, dimension.getName());
        }
        for (Measure measure : this.getStructure().getMeasures()) {
            this.adjustMinMaxRange(dataset, measure.getName());
        }
    }

    private void adjustMinMaxRange(StudyDataset dataset, String key) {
        Serializable value = dataset.getValue(key);
        if (value instanceof Number) {
            Double doubleValue = ((Number)value).doubleValue();
            if (this.minValues.get(key) == null || this.minValues.get(key) > doubleValue) {
                this.minValues.put(key, doubleValue);
            }
            if (this.maxValues.get(key) == null || this.maxValues.get(key) < doubleValue) {
                this.maxValues.put(key, doubleValue);
            }
        }
    }

    public Collection<StudyDataset> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public Double getMinValue(String key) {
        return this.minValues.get(key);
    }

    public Double getMaxValue(String key) {
        return this.maxValues.get(key);
    }

    public static StudyDatastore connect(String identifier, ResolvableNodeId platform, ParametricStudyService parametricStudyService) {
        StudyReceiver receiver = parametricStudyService.createReceiver(identifier, platform);
        if (receiver == null) {
            return null;
        }
        StudyDatastore datastore = new StudyDatastore(identifier, receiver.getStudy().getTitle(), receiver.getStudy().getStructure());
        notificationSubscriber = new DatasetNotificationSubscriber(datastore);
        receiver.setNotificationSubscriber((NotificationSubscriber)notificationSubscriber);
        receiver.initialize();
        return datastore;
    }

    public void addDatasetAddListener(StudyDatasetAddListener listener) {
        this.listeners.add(listener);
    }

    public void removeDatasetAddListener(StudyDatasetAddListener listener) {
        this.listeners.remove(listener);
    }

    private void fireDatasetAdd(StudyDataset dataset) {
        StudyDatasetAddListener[] listenersArray;
        StudyDatasetAddListener[] studyDatasetAddListenerArray = listenersArray = this.listeners.toArray(new StudyDatasetAddListener[0]);
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            StudyDatasetAddListener listener = studyDatasetAddListenerArray[n2];
            try {
                listener.handleStudyDatasetAdd(dataset);
            }
            catch (RuntimeException runtimeException) {
            }
            ++n2;
        }
    }

    public static interface StudyDatasetAddListener {
        public void handleStudyDatasetAdd(StudyDataset var1);
    }
}

