/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WarningErrorLabel
extends Composite {
    private static final int COMPOSITE_HEIGHT_HINT = 45;
    private final Text upperText;
    private final Text lowerText;
    private final CLabel upperLabel;
    private final CLabel lowerLabel;
    private final List<String> errors = new LinkedList<String>();
    private final List<String> warnings = new LinkedList<String>();

    public WarningErrorLabel(Composite parent, int style) {
        super(parent, style);
        this.setVisible(true);
        GridLayout gd = new GridLayout(2, false);
        gd.marginWidth = 0;
        GridData thisGridData = new GridData(768);
        this.setLayout((Layout)gd);
        this.setLayoutData(thisGridData);
        GridData labelGridData = new GridData(768);
        labelGridData.heightHint = 45;
        GridLayout configGroupLayout = new GridLayout();
        configGroupLayout.marginWidth = 0;
        this.upperLabel = new CLabel((Composite)this, 0);
        this.upperLabel.setText("xxxxxxxxxErrors");
        this.upperText = new Text((Composite)this, 520);
        this.upperText.setLayoutData((Object)labelGridData);
        this.lowerLabel = new CLabel((Composite)this, 0);
        this.lowerLabel.setText("xxxxxWarnings");
        this.lowerText = new Text((Composite)this, 520);
        this.lowerText.setLayoutData((Object)labelGridData);
        this.refresh();
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
        this.refresh();
    }

    public void addWarnings(Collection<String> warningsParam) {
        this.warnings.addAll(warningsParam);
        this.refresh();
    }

    public void clearWarnings() {
        this.warnings.clear();
        this.refresh();
    }

    public void addError(String error) {
        this.errors.add(error);
        this.refresh();
    }

    public void addErrors(Collection<String> errorsParam) {
        this.errors.addAll(errorsParam);
        this.refresh();
    }

    public void clearErrors() {
        this.errors.clear();
        this.refresh();
    }

    private void refresh() {
        Optional<Object> warningLabel;
        Optional<Object> warningText;
        Optional<Object> errorLabel;
        Optional<Object> errorText;
        if (this.errors.isEmpty()) {
            errorText = Optional.empty();
            errorLabel = Optional.empty();
            if (this.warnings.isEmpty()) {
                warningText = Optional.empty();
                warningLabel = Optional.empty();
            } else {
                warningText = Optional.of(this.upperText);
                warningLabel = Optional.of(this.upperLabel);
            }
        } else {
            errorText = Optional.of(this.upperText);
            errorLabel = Optional.of(this.upperLabel);
            if (this.warnings.isEmpty()) {
                warningText = Optional.empty();
                warningLabel = Optional.empty();
            } else {
                warningText = Optional.of(this.lowerText);
                warningLabel = Optional.of(this.lowerLabel);
            }
        }
        this.upperText.setVisible(false);
        this.lowerText.setVisible(false);
        this.upperLabel.setVisible(false);
        this.lowerLabel.setVisible(false);
        if (errorText.isPresent()) {
            ((CLabel)errorLabel.get()).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
            ((CLabel)errorLabel.get()).setText("Errors:");
            ((CLabel)errorLabel.get()).setVisible(true);
            ((Text)errorText.get()).setText(String.join((CharSequence)"\n", this.errors));
            ((Text)errorText.get()).setVisible(true);
        }
        if (warningText.isPresent()) {
            ((CLabel)warningLabel.get()).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
            ((CLabel)warningLabel.get()).setText("Warnings:");
            ((CLabel)warningLabel.get()).setVisible(true);
            ((Text)warningText.get()).setText(String.join((CharSequence)"\n", this.warnings));
            ((Text)warningText.get()).setVisible(true);
        }
    }
}

